/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.gson.Gson;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.mvc.telemetry.DataCollectionConfigurator;
import com.vmware.vise.mvc.util.FilenameHelper;
import com.vmware.vise.mvc.util.I18nServiceHelper;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vsphere.client.security.util.Util;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AppStartController {
    private static final String INDEX_PAGE = "index";
    private static final Log _logger = LogFactory.getLog(AppStartController.class);
    private static final String ADV_PERF_CHART_PLUGIN_ID = "com.vmware.opsmgmt.client.advperfcharts";
    private static final String COMMON_MODULE_PLUGIN_ID = "com.vmware.vsphere.client.commonModule";
    private static final String STORAGE_MODULE_PLUGIN_ID = "com.vmware.vsphere.client.storage";
    private static final String NETWORK_LIB_UI_MODULE_PLUGIN_ID = "com.vmware.vsphere.client.networkLibUi";
    private static final String HMAC_SHA_256 = "HmacSHA256";
    private final ExtensionService _extensionService;
    private final I18nServiceHelper _i18nServiceHelper;
    private final ConfigurationService _configurationService;
    private static final boolean _isReleaseBuild = BuildProperties.isReleaseBuild();
    private static final String _xsrfCookieName = BuildProperties.getXsrfCookieName();
    private static final String _xsrfHeaderName = BuildProperties.getXsrfHeaderName();
    private Date _applicationStartedDate;
    private final DataCollectionConfigurator _dataCollectionConfigurator;

    @Autowired
    public AppStartController(ExtensionService extensionService, I18nServiceHelper i18nServiceHelper, ConfigurationService configurationService, DataCollectionConfigurator dataCollectionConfigurator) {
        this._extensionService = extensionService;
        this._i18nServiceHelper = i18nServiceHelper;
        this._configurationService = configurationService;
        this._applicationStartedDate = new Date();
        this._dataCollectionConfigurator = dataCollectionConfigurator;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public final String getIndexPage(ModelMap modelMap, @RequestParam(value="debug", required=false, defaultValue="false") boolean bl) throws Exception {
        _logger.debug((Object)"GET /");
        Predicate<PluginInfo> predicate = new Predicate<PluginInfo>(){

            public boolean evaluate(PluginInfo pluginInfo) {
                return true;
            }
        };
        String string = this.getPage(modelMap, bl, predicate);
        _logger.trace((Object)"Finish execution of GET /");
        return string;
    }

    @RequestMapping(value={"/cache/h5-namespace-init"}, method={RequestMethod.GET})
    public final String getH5NamespaceInitPage(ModelMap modelMap) throws Exception {
        _logger.debug((Object)"GET /cache/h5-namespace-init");
        Locale locale = ResourceUtil.getLocale();
        String string = this._i18nServiceHelper.getResources(locale.toString());
        boolean bl = this.isTelemetryEnabled();
        String string2 = this._configurationService.getProperty("installation.id");
        if (string2 == null) {
            string2 = "";
        }
        String string3 = this._configurationService.getProperty("telemetry.collectorId");
        String string4 = this._configurationService.getProperty("feedback.collectorId");
        String string5 = this._configurationService.getProperty("telemetry.cookieDomain");
        modelMap.addAttribute("applicationStartedDate", (Object)this._applicationStartedDate);
        modelMap.addAttribute("languageResource", (Object)string);
        modelMap.addAttribute("xsrfCookieName", (Object)_xsrfCookieName);
        modelMap.addAttribute("xsrfHeaderName", (Object)_xsrfHeaderName);
        modelMap.addAttribute("isReleaseBuild", (Object)_isReleaseBuild);
        modelMap.addAttribute("isTelemetryEnabled", (Object)bl);
        modelMap.addAttribute("installationId", (Object)string2);
        modelMap.addAttribute("locale", (Object)locale.toLanguageTag());
        modelMap.addAttribute("telemetryCollectorId", (Object)string3);
        modelMap.addAttribute("feedbackCollectorId", (Object)string4);
        modelMap.addAttribute("telemetryCookieDomain", (Object)string5);
        String string6 = this._configurationService.getProperty("error.popup.show");
        if (string6 == null) {
            string6 = "true";
        }
        modelMap.addAttribute("isErrorPopupEnabled", (Object)Boolean.parseBoolean(string6));
        _logger.trace((Object)"Finish execution of GET /cache/h5-namespace-init");
        return "h5-namespace-init";
    }

    @RequestMapping(value={"/chart"}, method={RequestMethod.GET})
    public final String getChartPage(ModelMap modelMap, @RequestParam(value="debug", required=false, defaultValue="false") boolean bl) throws Exception {
        _logger.debug((Object)"GET / chart");
        Predicate<PluginInfo> predicate = new Predicate<PluginInfo>(){

            public boolean evaluate(PluginInfo pluginInfo) {
                return AppStartController.ADV_PERF_CHART_PLUGIN_ID.equals(pluginInfo.getId()) || AppStartController.COMMON_MODULE_PLUGIN_ID.equals(pluginInfo.getId());
            }
        };
        modelMap.addAttribute("popupPage", (Object)"chart");
        String string = this.getPage(modelMap, bl, predicate);
        _logger.trace((Object)"Finish execution of GET /chart");
        return string;
    }

    @RequestMapping(value={"/datastore-browser"}, method={RequestMethod.GET})
    public final String getDatastoreBrowserPage(ModelMap modelMap, @RequestParam(value="debug", required=false, defaultValue="false") boolean bl) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"GET / datastore-browser");
        }
        Predicate<PluginInfo> predicate = new Predicate<PluginInfo>(){

            public boolean evaluate(PluginInfo pluginInfo) {
                return AppStartController.STORAGE_MODULE_PLUGIN_ID.equals(pluginInfo.getId()) || AppStartController.COMMON_MODULE_PLUGIN_ID.equals(pluginInfo.getId()) || AppStartController.NETWORK_LIB_UI_MODULE_PLUGIN_ID.equals(pluginInfo.getId());
            }
        };
        modelMap.addAttribute("popupPage", (Object)"datastore-browser");
        return this.getPage(modelMap, bl, predicate);
    }

    @RequestMapping(value={"/userHash"}, method={RequestMethod.GET})
    @ResponseBody
    public final String getHashedUserId(@RequestParam(value="userId") String string) {
        String string2 = this._configurationService.getProperty("intercom.hash.key");
        return AppStartController.encodeIntercomUserId(string, string2);
    }

    private List<PluginDependency> getPluginDependencies(PluginInfo pluginInfo) {
        ConcurrentMap concurrentMap;
        Map map;
        PluginDependency[] pluginDependencyArray = pluginInfo.getDependencies();
        if (pluginDependencyArray == null) {
            return null;
        }
        IdVersionPair idVersionPair = pluginInfo.getPackageRef();
        PluginPackageInfo pluginPackageInfo = null;
        try {
            pluginPackageInfo = this._extensionService.getPluginPackageInfo(idVersionPair);
        }
        catch (Exception exception) {
            _logger.error((Object)("Cannot determine if this is a remote plugin to load the remote CSS dependencies. Failed to get pluginPackageInfo for " + pluginInfo.getId()), (Throwable)exception);
        }
        if (pluginPackageInfo != null && pluginPackageInfo.isRemotePlugin() && (map = (Map)(concurrentMap = pluginPackageInfo.getMetadata()).get("pluginRegistrationUrlByServer")) != null) {
            String string = (String)map.values().iterator().next() + "/";
            ArrayList<PluginDependency> arrayList = new ArrayList<PluginDependency>();
            for (PluginDependency pluginDependency : pluginDependencyArray) {
                PluginDependency pluginDependency2 = new PluginDependency(pluginDependency.getType(), string + pluginDependency.getUri());
                arrayList.add(pluginDependency2);
            }
            return arrayList;
        }
        return Arrays.asList(pluginDependencyArray);
    }

    /*
     * WARNING - void declaration
     */
    private String getPage(ModelMap modelMap, Boolean bl, Predicate<PluginInfo> predicate) throws Exception {
        void var11_14;
        Object object;
        String string;
        Object object22;
        String string2 = this._configurationService.getProperty("browser.context.menu");
        boolean bl2 = Boolean.parseBoolean(string2);
        modelMap.addAttribute("isBrowserContextMenuEnabled", (Object)bl2);
        modelMap.addAttribute("i18nResourcesVersion", (Object)this._i18nServiceHelper.getInternalVersion());
        UserSession userSession = Util.getUserSession();
        modelMap.addAttribute("hasUserSession", (Object)(userSession != null ? 1 : 0));
        modelMap.addAttribute("configurationJson", (Object)"{}");
        if (userSession == null) {
            return INDEX_PAGE;
        }
        LinkedHashSet<PluginDependency> linkedHashSet = new LinkedHashSet<PluginDependency>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        PluginInfo[] pluginInfoArray = this._extensionService.getPluginInfos();
        FilenameHelper filenameHelper = new FilenameHelper(bl);
        for (Object object22 : pluginInfoArray) {
            if (!predicate.evaluate(object22)) continue;
            string = object22.getType().trim();
            if ("angularjs".equalsIgnoreCase(string)) {
                linkedHashSet2.add(object22.getId().trim());
            }
            if ((object = this.getPluginDependencies((PluginInfo)object22)) == null) continue;
            linkedHashSet.addAll((Collection<PluginDependency>)object);
        }
        modelMap.addAttribute("isTelemetryEnabled", (Object)this.isTelemetryEnabled());
        String string3 = this._configurationService.getProperty("installation.id");
        if (string3 == null) {
            String string4 = "";
        }
        String string5 = this._configurationService.getProperty("intercom.hash.key");
        String string6 = this._configurationService.getProperty("walkMe.url");
        object22 = this._configurationService.getProperty("segment.appId");
        string = this._configurationService.getProperty("sddc.id");
        object = userSession.userName;
        String string7 = this.getUserSuffix();
        if (string7 != null && !string7.isEmpty()) {
            object = (String)object + string7;
        }
        String string8 = ResourceUtil.getLocale().toLanguageTag().toLowerCase();
        modelMap.addAttribute("angularModules", (Object)new Gson().toJson(linkedHashSet2));
        modelMap.addAttribute("dependencies", linkedHashSet);
        modelMap.addAttribute("filenameHelper", (Object)filenameHelper);
        modelMap.addAttribute("installationId", (Object)var11_14);
        modelMap.addAttribute("languageTag", (Object)string8);
        modelMap.addAttribute("walkMeUrl", (Object)string6);
        modelMap.addAttribute("sddcId", (Object)string);
        modelMap.addAttribute("segmentAppId", object22);
        modelMap.addAttribute("userName", (Object)userSession.userName);
        modelMap.addAttribute("intercomUserId", object);
        modelMap.addAttribute("hashedIntercomUserId", (Object)AppStartController.encodeIntercomUserId((String)object, string5));
        modelMap.addAttribute("i18nResourcesVersion", (Object)(string8 + this._i18nServiceHelper.getInternalVersion()));
        modelMap.addAttribute("configurationJson", (Object)new Gson().toJson((Object)this._configurationService.getPublicConfiguration()));
        return INDEX_PAGE;
    }

    private String getUserSuffix() {
        String string = this._configurationService.getProperty("sddc.id");
        String string2 = this._configurationService.getProperty("installation.id");
        String string3 = null;
        if (!StringUtil.isNullOrEmpty((String)string)) {
            string3 = "-sddc" + string;
        } else {
            _logger.error((Object)"Missing sddc id in the configuration file. Post installation scripts failed to set the property");
            if (!StringUtil.isNullOrEmpty((String)string2)) {
                string3 = "-vcenter" + string2.substring(4);
            }
        }
        return string3;
    }

    private static String encodeIntercomUserId(String string, String string2) {
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byte[] byArray;
            Mac mac = Mac.getInstance(HMAC_SHA_256);
            SecretKeySpec secretKeySpec = new SecretKeySpec(string2.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256);
            mac.init(secretKeySpec);
            for (byte by : byArray = mac.doFinal(string.getBytes(StandardCharsets.UTF_8))) {
                stringBuffer.append(String.format("%02X", by));
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"Unable to encode intercom user id.");
            return string;
        }
        return stringBuffer.toString();
    }

    private boolean isTelemetryEnabled() {
        boolean bl = false;
        if (this.hasClientId()) {
            try {
                bl = this._dataCollectionConfigurator.isCeipEnabled();
            }
            catch (NotAuthenticatedError notAuthenticatedError) {
            }
            catch (Exception exception) {
                _logger.error((Object)"Error checking whether the telemetry is enabled.", (Throwable)exception);
            }
        }
        return bl;
    }

    protected boolean hasClientId() {
        return SessionUtil.getClientId((HttpSession)SessionUtil.getHttpSession()) != null;
    }
}

