/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.model.data.MultiPropertyRequestSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.util.VCAuthorizationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/authorization"}, method={RequestMethod.POST})
public class AuthorizationServiceController {
    private static final Log _logger = LogFactory.getLog(AuthorizationServiceController.class);
    private static String GRANTED_PRIV_PROP_NAME = "grantedPrivileges";
    private final ObjectReferenceService _objectReferenceService;
    private final QueryService _queryService;

    @Autowired
    public AuthorizationServiceController(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, @Qualifier(value="queryServiceFactory") QueryServiceFactory queryServiceFactory) {
        this._objectReferenceService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @ResponseBody
    @RequestMapping(value={"/privileges/entities"})
    public Map<String, Object> hasPrivilegeOnEntities(@RequestBody MultiPropertyRequestSpec multiPropertyRequestSpec) throws Exception {
        ManagedObjectReference[] managedObjectReferenceArray;
        Object object2;
        _logger.debug((Object)"GET /authorization/privileges/entities");
        Object[] objectArray = multiPropertyRequestSpec.objectIds;
        Object[] objectArray2 = multiPropertyRequestSpec.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || ArrayUtil.isNullOrEmpty((Object[])objectArray2)) {
            return Collections.emptyMap();
        }
        ArrayList<ManagedObjectReference[]> arrayList = new ArrayList<ManagedObjectReference[]>(objectArray.length);
        for (Object object2 : objectArray) {
            managedObjectReferenceArray = this._objectReferenceService.getReference((String)object2, true);
            boolean entityPrivilegeArray = managedObjectReferenceArray instanceof ManagedObjectReference;
            if (!entityPrivilegeArray) {
                throw new IllegalArgumentException("Object should refer to an instance of managed object");
            }
            arrayList.add(managedObjectReferenceArray);
        }
        String string = this._objectReferenceService.getServerGuid(arrayList.get(0));
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            throw new IllegalArgumentException("vcService cannot be found based on provided server guid");
        }
        String string2 = vcService.getConnectionInfo().getUserSession().getKey();
        object2 = VCAuthorizationUtil.getAuthorizationManager((String)string);
        managedObjectReferenceArray = arrayList.toArray(new ManagedObjectReference[0]);
        AuthorizationManager.EntityPrivilege[] entityPrivilegeArray = object2.hasPrivilegeOnEntities(managedObjectReferenceArray, string2, (String[])objectArray2);
        Map<String, Object> map = this.transformResults(entityPrivilegeArray);
        _logger.trace((Object)"Finish execution of GET /authorization/privileges/entities");
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/grantedPrivileges/entities"})
    public Map<String, Object> checkGrantedPrivilegesOnEntities(@RequestBody MultiPropertyRequestSpec multiPropertyRequestSpec) {
        String[] stringArray;
        _logger.debug((Object)"GET /authorization/grantedPrivileges/entities");
        ResultSet resultSet = multiPropertyRequestSpec.objectIds;
        Object[] objectArray = multiPropertyRequestSpec.properties;
        if (ArrayUtil.isNullOrEmpty((Object[])resultSet) || ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            return Collections.emptyMap();
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>(((Object[])resultSet).length);
        String string = null;
        for (Object object : resultSet) {
            stringArray = this._objectReferenceService.getReference((String)object, true);
            if (string == null) {
                string = this._objectReferenceService.getResourceObjectType((Object)stringArray);
            }
            arrayList.add(stringArray);
        }
        ResultSet resultSet2 = this._queryService.select(new String[]{GRANTED_PRIV_PROP_NAME}).from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, arrayList).fetch();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Object object : resultSet2.getItems()) {
            stringArray = (String[])object.getPropertyValues().get(0);
            HashMap<Object, Boolean> hashMap2 = new HashMap<Object, Boolean>();
            for (Object object2 : objectArray) {
                boolean bl = false;
                for (String string2 : stringArray) {
                    if (!((String)object2).equals(string2)) continue;
                    bl = true;
                    break;
                }
                hashMap2.put(object2, bl);
            }
            String object3 = this._objectReferenceService.getUid(object.getKey(), true);
            hashMap.put(object3, hashMap2);
        }
        _logger.trace((Object)"Finish execution of GET /authorization/grantedPrivileges/entities");
        return hashMap;
    }

    private Map<String, Object> transformResults(AuthorizationManager.EntityPrivilege[] entityPrivilegeArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (AuthorizationManager.EntityPrivilege entityPrivilege : entityPrivilegeArray) {
            ManagedObjectReference managedObjectReference = entityPrivilege.entity;
            String string = this._objectReferenceService.getUid((Object)managedObjectReference, true);
            AuthorizationManager.PrivilegeAvailability[] privilegeAvailabilityArray = entityPrivilege.getPrivAvailability();
            HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
            for (AuthorizationManager.PrivilegeAvailability privilegeAvailability : privilegeAvailabilityArray) {
                hashMap2.put(privilegeAvailability.getPrivId(), privilegeAvailability.isIsGranted());
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }
}

