/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.util.client.configuration.ConfigurationPayload;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/configuration"})
public class ConfigurationServiceController {
    private static final Log _logger = LogFactory.getLog(ConfigurationServiceController.class);
    private final ConfigurationService _configurationService;
    private static final List<String> CONFIGURATION_KEY_BLACKLIST = new ArrayList<String>(){
        {
            this.add("intercom.*");
            this.add("segment.*");
        }
    };
    private static final String HIDDEN_VALUE = "<hidden>";

    @Autowired
    public ConfigurationServiceController(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public final ConfigurationPayload getConfiguration() throws Exception {
        _logger.debug((Object)"GET /configuration/");
        ConfigurationPayload configurationPayload = this._configurationService.getConfiguration();
        _logger.trace((Object)"Finish execution of GET /configuration/");
        return this.hideSensitiveConfigProperties(configurationPayload);
    }

    private ConfigurationPayload hideSensitiveConfigProperties(ConfigurationPayload configurationPayload) {
        ConfigurationPayload configurationPayload2 = new ConfigurationPayload();
        configurationPayload2.featureStates = configurationPayload.featureStates;
        configurationPayload2.configParams = new HashMap();
        for (Map.Entry entry : configurationPayload.configParams.entrySet()) {
            Object k = entry.getKey();
            if (this.checkForBlackListedKeyMatch(k)) {
                configurationPayload2.configParams.put(k, HIDDEN_VALUE);
                continue;
            }
            configurationPayload2.configParams.put(k, entry.getValue());
        }
        return configurationPayload2;
    }

    private boolean checkForBlackListedKeyMatch(Object object) {
        for (String string : CONFIGURATION_KEY_BLACKLIST) {
            if (!object.toString().matches(string)) continue;
            return true;
        }
        return false;
    }
}

