/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.query.util.QueryBindingServiceFactory;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.model.data.FilterSpec;
import com.vmware.vise.mvc.model.data.MultiPropertyRequestSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.mvc.util.ParameterSpecHelper;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.http.transport.data.IDownloadHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/data"}, method={RequestMethod.GET})
public class DataAccessController {
    private static final String OBJECT_ID = "id";
    private static final Log _logger = LogFactory.getLog(DataAccessController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final ObjectReferenceService _objectReferenceService;
    private final ClassLoaderService _classLoaderService;
    private final ObjectMapper _objectMapper;
    private final QueryBindingServiceFactory _queryBindingServiceFactory;
    private final QueryService _queryService;
    private final ServiceRegistry _serviceRegistry;

    @Autowired
    public DataAccessController(ObjectMapper objectMapper, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ClassLoaderService classLoaderService, QueryBindingServiceFactory queryBindingServiceFactory, QueryServiceFactory queryServiceFactory, ServiceRegistry serviceRegistry) {
        this._objectMapper = objectMapper;
        this._objectReferenceService = objectReferenceService;
        this._classLoaderService = classLoaderService;
        this._queryBindingServiceFactory = queryBindingServiceFactory;
        this._queryService = queryServiceFactory.getQueryService();
        this._serviceRegistry = serviceRegistry;
    }

    @RequestMapping(value={"/{objectId:.*}"})
    @ResponseBody
    public <T> T getData(@PathVariable(value="objectId") String string, @RequestParam(value="model", required=true) String string2, @RequestHeader(value="queryName", required=false) String string3) throws ClassNotFoundException {
        if (StringUtil.isNullOrEmpty((String)string3)) {
            string3 = this._opId;
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return null;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /data/", string, " for ", string2, " with queryName " + string3}));
        }
        Object object = this._objectReferenceService.getReference(string, true);
        Class clazz = this._classLoaderService.loadClass(string2);
        if (!clazz.isAnnotationPresent(QueryBinding.class)) {
            throw new UnsupportedOperationException("Not supported model class " + clazz);
        }
        QueryBindingService queryBindingService = this._queryBindingServiceFactory.getQueryBindingService();
        Object object2 = queryBindingService.prepare(clazz).opId(string3).fetch(object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /data/", string, " for ", string2, " with queryName " + string3}));
        }
        return (T)object2;
    }

    @RequestMapping(value={"/properties/{objectId:.*}"})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String string, @RequestParam(value="properties", required=true) String string2, @RequestParam(value="resourceModels", required=false) String[] stringArray, @RequestHeader(value="queryName", required=false) String string3) throws Exception {
        if (StringUtil.isNullOrEmpty((String)string3)) {
            string3 = this._opId;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /data/properties/", string, " with queryName " + string3}));
        }
        Map<String, Object> map = this.getPropertiesWithParams(string, string2, stringArray, null, string3);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /data/properties/", string, " with queryName " + string3}));
        }
        return map;
    }

    @RequestMapping(value={"/propertiesByRelation/{objectId:.*}"})
    @ResponseBody
    public Map<String, Object> getPropertiesForRelatedObject(@PathVariable(value="objectId") String string, @RequestParam(value="relation", required=true) String string2, @RequestParam(value="targetType", required=true) String[] stringArray, @RequestParam(value="properties", required=true) String string3) throws Exception {
        String string4 = this._opId;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /data/propertiesByRelation/", string, " with queryName " + string4}));
        }
        Object object = this._objectReferenceService.getReference(string, true);
        String[] stringArray2 = !StringUtil.isNullOrWhitespace((String)string3) ? StringUtil.splitAndTrim((String)string3, (String)",") : new String[]{};
        ResultSet resultSet = this._queryService.select(stringArray2).from(stringArray).where(string2, PropertyPredicate.ComparisonOperator.EQUAL, object).opId(string4).fetch();
        Map<String, Object> map = this.transformResults(resultSet, stringArray2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /data/propertiesByRelation/", string, " with queryName " + string4}));
        }
        return map;
    }

    @RequestMapping(value={"/propertiesWithParameters/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getProperties(@PathVariable(value="objectId") String string, @RequestParam(value="properties", required=true) String string2, @RequestParam(value="resourceModels", required=false) String[] stringArray, @RequestBody(required=false) ParamSpec[] paramSpecArray, @RequestHeader(value="queryName", required=false) String string3) throws Exception {
        if (StringUtil.isNullOrEmpty((String)string3)) {
            string3 = this._opId;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /data/propertiesWithParameters/", string, " with queryName " + string3}));
        }
        ParameterSpecHelper parameterSpecHelper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, paramSpecArray);
        Map<String, List<ParameterSpec>> map = parameterSpecHelper.getParameterSpecs();
        Map<String, Object> map2 = this.getPropertiesWithParams(string, string2, stringArray, map, string3);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /data/propertiesWithParameters/", string, " with queryName " + string3}));
        }
        return map2;
    }

    @RequestMapping(value={"/propertiesByFilter"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getPropertiesByFilter(@RequestParam(value="properties", required=true) String string, @RequestParam(value="resourceModels", required=true) String[] stringArray, @RequestBody FilterSpec filterSpec, @RequestHeader(value="queryName", required=false) String string2) throws Exception {
        Validate.notEmpty((Object[])stringArray, (String)"The resource models can't be null or empty!");
        Validate.notNull((Object)filterSpec, (String)"No filter has been extracted from the request body!");
        if (StringUtil.isNullOrEmpty((String)string2)) {
            string2 = this._opId;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /data/propertiesByFilter with queryName ", string2}));
        }
        if (StringUtil.isNullOrWhitespace((String)string)) {
            return Collections.EMPTY_MAP;
        }
        String[] stringArray2 = StringUtil.splitAndTrim((String)string, (String)",");
        ResultSet resultSet = this._queryService.select(stringArray2).from(stringArray).where(filterSpec.buildFilterFromSpec()).opId(string2).fetch();
        return this.transformResults(resultSet, stringArray2);
    }

    @RequestMapping(value={"/multipleProperties"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getProperties(@RequestBody(required=false) MultiPropertyRequestSpec multiPropertyRequestSpec, @RequestHeader(value="queryName", required=false) String string) throws Exception {
        if (multiPropertyRequestSpec.objectIds == null || multiPropertyRequestSpec.objectIds.length == 0) {
            return Collections.emptyMap();
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = this._opId;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /data/multipleProperties/ with queryName ", string}));
        }
        int n = multiPropertyRequestSpec.objectIds.length;
        Object[] objectArray = new Object[n];
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objectReferenceService.getReference(multiPropertyRequestSpec.objectIds[i], true);
            string2 = this._objectReferenceService.getResourceObjectType(objectArray[i]);
            if (string3 != null && !string3.equals(string2)) {
                throw new IllegalArgumentException("Cannot retrieve properties for heterogeneous object set.");
            }
            string3 = string2;
        }
        ParameterSpecHelper parameterSpecHelper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, multiPropertyRequestSpec.params);
        Map<String, List<ParameterSpec>> map = parameterSpecHelper.getParameterSpecs();
        String[] stringArray = ArrayUtil.isNullOrEmpty((Object[])multiPropertyRequestSpec.resourceModels) ? new String[]{string2} : multiPropertyRequestSpec.resourceModels;
        List<PropertyPredicate> list = this.buildFilterSpec(objectArray, map);
        if (StringUtil.isNullOrEmpty((String)string)) {
            string = this._opId;
        }
        ResultSet resultSet = this._queryService.select(multiPropertyRequestSpec.properties).from(stringArray).where(LogicalOperator.AND, list).opId(string).fetch();
        Map<String, Object> map2 = this.transformResults(resultSet, multiPropertyRequestSpec.properties);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /data/multipleProperties/ with queryName ", string}));
        }
        return map2;
    }

    @RequestMapping(value={"/download/{downloadPath:.*}"}, method={RequestMethod.GET})
    public void download(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="downloadPath") String string) throws Exception {
        List list = this._serviceRegistry.getServices(IDownloadHandler.class.getName());
        ArrayList<IDownloadHandler> arrayList = new ArrayList<IDownloadHandler>();
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList();
            for (IDownloadHandler iDownloadHandler : list) {
                if (!iDownloadHandler.canHandleDownloadRequest(httpServletRequest, string)) continue;
                arrayList.add(iDownloadHandler);
            }
        }
        if (arrayList.size() == 1) {
            ((IDownloadHandler)arrayList.get(0)).download(httpServletRequest, httpServletResponse);
        } else if (arrayList.size() == 0) {
            httpServletResponse.sendError(404);
        } else {
            httpServletResponse.sendError(500);
            _logger.error((Object)String.format("Found more than one handler for path: %s", string));
            for (IDownloadHandler iDownloadHandler : arrayList) {
                _logger.error((Object)String.format("Handler %s can handle path: %s", iDownloadHandler.getClass().getName(), string));
            }
        }
    }

    private Map<String, Object> transformResults(ResultSet resultSet, String[] stringArray) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object = resourceItem.getKey();
            String string = this._objectReferenceService.getUid(object, true);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap.put(string, hashMap2);
            for (String string2 : stringArray) {
                hashMap2.put(string2, resourceItem.get(string2));
            }
        }
        return hashMap;
    }

    private Map<String, Object> getPropertiesWithParams(String string, String string2, String[] stringArray, Map<String, List<ParameterSpec>> map, String string3) {
        Object object = this._objectReferenceService.getReference(string, true);
        String[] stringArray2 = !StringUtil.isNullOrWhitespace((String)string2) ? StringUtil.splitAndTrim((String)string2, (String)",") : new String[]{};
        List<PropertyPredicate> list = this.buildFilterSpec(new Object[]{object}, map);
        String[] stringArray3 = stringArray == null ? new String[]{this._objectReferenceService.getResourceObjectType(object)} : stringArray;
        if (StringUtil.isNullOrEmpty((String)string3)) {
            string3 = this._opId;
        }
        ResultSet resultSet = this._queryService.select(stringArray2).from(stringArray3).where(LogicalOperator.AND, list).opId(string3).fetch();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object object2 = resourceItem.getKey();
            hashMap.put(OBJECT_ID, this._objectReferenceService.getUid(object2, true));
            for (String string4 : stringArray2) {
                hashMap.put(string4, resourceItem.get(string4));
            }
        }
        return hashMap;
    }

    private List<PropertyPredicate> buildFilterSpec(Object[] objectArray, Map<String, List<ParameterSpec>> map) {
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>();
        arrayList.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(objectArray)));
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, List<ParameterSpec>> entry : map.entrySet()) {
                for (ParameterSpec parameterSpec : entry.getValue()) {
                    PropertyPredicate propertyPredicate = new PropertyPredicate(entry.getKey() + "/@param", PropertyPredicate.ComparisonOperator.EQUAL, parameterSpec.parameter);
                    arrayList.add(propertyPredicate);
                }
            }
        }
        return arrayList;
    }
}

