/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.FileManager;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.data.query.commands.DataFetchCommandFactory;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreBrowserItem;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreData;
import com.vmware.vise.mvc.datastorebrowser.model.DatastoreItem;
import com.vmware.vise.mvc.datastorebrowser.model.FileItem;
import com.vmware.vise.mvc.datastorebrowser.model.FolderItem;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.storage.FileSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/datastoreBrowserTree"}, method={RequestMethod.GET})
public class DatastoreBrowserController {
    private static final Log _logger = LogFactory.getLog(DatastoreBrowserController.class);
    private final DataService _dataService;
    private final ObjectReferenceService _objReferenceService;
    private final String HOST_DATASTORE_BROWSER_TYPE = "HostDatastoreBrowser";
    private final String SEARCHABLE_DATASTORES_PROP_NAME = "searchableDatastore";
    private final String FILE_PROP_NAME = "file";
    private static final int VM_DISK_TYPE = 1;
    private static final int FLOPPY_IMAGE_TYPE = 2;
    private static final int ISO_IMAGE_TYPE = 4;
    private static final int VM_CONFIG_FILES_TYPE = 8;
    private static final String ALL_FILES_TYPE_STR = "0x0010";
    private static final int ALL_FILES_TYPE = Integer.parseInt("0x0010".replaceAll("0x", ""), 16);
    private static final int FOLDERS_TYPE = 32;
    private static final int VM_DISK_TYPE_WITH_DETAILS = 64;

    @Autowired
    public DatastoreBrowserController(DataService dataService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._dataService = dataService;
        this._objReferenceService = objectReferenceService;
    }

    @ResponseBody
    @RequestMapping(value={"/root/{objectId}"})
    public List<DatastoreBrowserItem> getRoot(@PathVariable(value="objectId") String string, @RequestParam(value="datastores", required=false) String[] stringArray, @RequestParam(value="showVmImagesFolder", required=false, defaultValue="false") boolean bl) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /datastoreBrowserTree/root/", string}));
        }
        List<DatastoreBrowserItem> list = null;
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._objReferenceService.getReference(string, true);
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        Object[] objectArray = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, (String)"HostDatastoreBrowser")) {
            if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
                return null;
            }
            objectArray = new ManagedObjectReference[stringArray.length];
            int n = 0;
            for (String string2 : stringArray) {
                ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this._objReferenceService.getReference(string2, true);
                objectArray[n++] = managedObjectReference2;
            }
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, VirtualMachine.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, HostSystem.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ClusterComputeResource.class)) {
            objectArray = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)managedObjectReference, (String)"searchableDatastore");
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Datastore.class)) {
            objectArray = new ManagedObjectReference[]{managedObjectReference};
        }
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            throw new IllegalArgumentException("No datastores to request data for");
        }
        list = this.getDatastoreItems((ManagedObjectReference[])objectArray);
        if (bl) {
            list.add(this.createVmImagesFolderItem());
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /datastoreBrowserTree/root/", string}));
        }
        return list;
    }

    @ResponseBody
    @RequestMapping(value={"/children/{objectId}"})
    public List<DatastoreBrowserItem> getChildren(@PathVariable(value="objectId") String string, @RequestParam(value="datastorePath", required=true) String string2, @RequestParam(value="fileQueryType", required=false, defaultValue="0x0010") int n, @RequestParam(value="pattern", required=false) String string3, @RequestParam(value="searchInSubFolders", required=false, defaultValue="false") boolean bl) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /datastoreBrowserTree/children/", string, " for ", string2}));
        }
        ArrayList<DatastoreBrowserItem> arrayList = new ArrayList<DatastoreBrowserItem>();
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._objReferenceService.getReference(string, true);
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        DatastoreBrowser.SearchSpec searchSpec = this.createSearchSpec(n, string3, true);
        FileSpec fileSpec = this.createFileSpec(string2, searchSpec, bl);
        Map<String, List<ParameterSpec>> map = this.getFilePropParamSpecs(fileSpec);
        PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)managedObjectReference, (String[])new String[]{"file"}, map);
        OperationResult operationResult = (OperationResult)propertyValueArray[0].value;
        if (operationResult.result == null) {
            return arrayList;
        }
        DatastoreBrowser.SearchResults[] searchResultsArray = null;
        if (operationResult.result instanceof DatastoreBrowser.SearchResults) {
            searchResultsArray = new DatastoreBrowser.SearchResults[]{(DatastoreBrowser.SearchResults)operationResult.result};
        } else if (operationResult.result.getClass().isArray()) {
            searchResultsArray = (DatastoreBrowser.SearchResults[])operationResult.result;
        } else {
            return arrayList;
        }
        FolderItem folderItem = null;
        for (DatastoreBrowser.SearchResults searchResults : searchResultsArray) {
            if (searchResults.file == null) continue;
            for (DatastoreBrowser.FileInfo fileInfo : searchResults.file) {
                if (fileInfo instanceof DatastoreBrowser.FolderInfo) {
                    folderItem = this.createFolderItem((DatastoreBrowser.FolderInfo)fileInfo, searchResults.folderPath);
                    arrayList.add(folderItem);
                } else if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
                    folderItem = this.createFileItem(fileInfo, searchResults.folderPath);
                    DatastoreBrowser.VmDiskInfo vmDiskInfo = (DatastoreBrowser.VmDiskInfo)fileInfo;
                    folderItem.diskExtents = vmDiskInfo.diskExtents;
                    arrayList.add(folderItem);
                } else {
                    folderItem = this.createFileItem(fileInfo, searchResults.folderPath);
                    arrayList.add(folderItem);
                }
                folderItem.localizedType = this.getLocalizedFileType(fileInfo);
                folderItem.friendlyName = fileInfo.friendlyName;
            }
        }
        this.sortDatastoreItems(arrayList);
        this.updateSortOrder(arrayList);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /datastoreBrowserTree/children/", string, " for ", string2}));
        }
        return arrayList;
    }

    @ResponseBody
    @RequestMapping(value={"/isFileExists/{objectId}"})
    public boolean isFileExists(@PathVariable(value="objectId") String string, @RequestParam(value="filePath", required=true) String string2, @RequestParam(value="fileQueryType", required=true) int n) throws Exception {
        Object object;
        Object object2;
        ManagedObjectReference managedObjectReference;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /datastoreBrowserTree/isFileExists/", string, " for ", string2, " for file type = ", n}));
        }
        if ((managedObjectReference = (ManagedObjectReference)this._objReferenceService.getReference(string, true)) == null) {
            throw new IllegalArgumentException("Object id is invalid");
        }
        if (StringUtil.isNullOrEmpty((String)string2)) {
            throw new IllegalArgumentException("File path cannot be null");
        }
        Integer n2 = string2.lastIndexOf(47);
        if (n2 == -1) {
            n2 = string2.indexOf(93);
            if (n2 == -1 || n2 == string2.length() - 1) {
                return false;
            }
            object2 = n2;
            n2 = n2 + 1;
            object = n2;
        }
        object2 = string2.substring(0, n2);
        object = string2.substring(n2 + 1);
        DatastoreBrowser.SearchSpec searchSpec = this.createSearchSpec(n, (String)object, false);
        FileSpec fileSpec = this.createFileSpec((String)object2, searchSpec, false);
        Map<String, List<ParameterSpec>> map = this.getFilePropParamSpecs(fileSpec);
        PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object)managedObjectReference, (String[])new String[]{"file"}, map);
        OperationResult operationResult = (OperationResult)propertyValueArray[0].value;
        if (operationResult.result == null) {
            return false;
        }
        DatastoreBrowser.SearchResults searchResults = (DatastoreBrowser.SearchResults)operationResult.result;
        if (searchResults == null || ArrayUtil.isNullOrEmpty((Object[])searchResults.getFile())) {
            return false;
        }
        DatastoreBrowser.FileInfo fileInfo = searchResults.getFile()[0];
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /datastoreBrowserTree/isFileExists/", string, " for ", string2, " for file type = ", n}));
        }
        return ((String)object).equals(fileInfo.getPath());
    }

    private void sortDatastoreItems(List<DatastoreBrowserItem> list) {
        Collections.sort(list, new Comparator<DatastoreBrowserItem>(){

            @Override
            public int compare(DatastoreBrowserItem datastoreBrowserItem, DatastoreBrowserItem datastoreBrowserItem2) {
                if (datastoreBrowserItem.getType() == null) {
                    if (datastoreBrowserItem2.getType() == null) {
                        return this.compareItemsByName(datastoreBrowserItem, datastoreBrowserItem2);
                    }
                    return -1;
                }
                if (datastoreBrowserItem2.getType() == null) {
                    return 1;
                }
                if (datastoreBrowserItem.getType().equals(datastoreBrowserItem2.getType())) {
                    return this.compareItemsByName(datastoreBrowserItem, datastoreBrowserItem2);
                }
                if (datastoreBrowserItem.getType().equals("folder")) {
                    return -1;
                }
                if (datastoreBrowserItem2.getType().equals("folder")) {
                    return 1;
                }
                return this.compareItemsByName(datastoreBrowserItem, datastoreBrowserItem2);
            }

            private int compareItemsByName(DatastoreBrowserItem datastoreBrowserItem, DatastoreBrowserItem datastoreBrowserItem2) {
                String string;
                String string2 = datastoreBrowserItem.friendlyName != null && !datastoreBrowserItem.friendlyName.isEmpty() ? datastoreBrowserItem.friendlyName : datastoreBrowserItem.name;
                String string3 = string = datastoreBrowserItem2.friendlyName != null && !datastoreBrowserItem2.friendlyName.isEmpty() ? datastoreBrowserItem2.friendlyName : datastoreBrowserItem2.name;
                if (string2 == null && string == null) {
                    return 0;
                }
                if (string2 == null) {
                    return -1;
                }
                if (string == null) {
                    return 1;
                }
                return string2.compareToIgnoreCase(string);
            }
        });
    }

    private void updateSortOrder(List<DatastoreBrowserItem> list) {
        int n = 0;
        for (DatastoreBrowserItem datastoreBrowserItem : list) {
            datastoreBrowserItem.nameSortOrder = n++;
        }
    }

    private List<DatastoreBrowserItem> getDatastoreItems(ManagedObjectReference[] managedObjectReferenceArray) {
        ArrayList<DatastoreBrowserItem> arrayList = new ArrayList<DatastoreBrowserItem>();
        DataFetchCommand dataFetchCommand = DataFetchCommandFactory.getDataFetchCommand((DataService)this._dataService);
        Collection collection = dataFetchCommand.execute(DatastoreData.class, (Object[])managedObjectReferenceArray);
        if (collection == null) {
            return arrayList;
        }
        for (DatastoreData datastoreData : collection) {
            DatastoreItem datastoreItem = this.createDatastoreItem(datastoreData);
            arrayList.add(datastoreItem);
        }
        return arrayList;
    }

    private DatastoreItem createDatastoreItem(DatastoreData datastoreData) {
        DatastoreItem datastoreItem = new DatastoreItem();
        datastoreItem.name = datastoreData.name;
        datastoreItem.path = String.format("[%s]", datastoreData.name);
        datastoreItem.spriteCssClass = datastoreData.primaryIconId;
        datastoreItem.totalCapacity = FormatUtil.getStorageFormatted((Long)datastoreData.totalCapacity, (long)1L, (long)-1L);
        datastoreItem.availableCapacity = FormatUtil.getStorageFormatted((Long)datastoreData.availableCapacity, (long)1L, (long)-1L);
        return datastoreItem;
    }

    private FolderItem createVmImagesFolderItem() {
        return this.createFolderItem(null, null);
    }

    private FolderItem createFolderItem(DatastoreBrowser.FolderInfo folderInfo, String string) {
        FolderItem folderItem = new FolderItem();
        folderItem.spriteCssClass = "vsphere-icon-folder";
        if (folderInfo == null) {
            folderItem.name = CommonUtils.text("vmImagesFolder.name");
            folderItem.path = "<vmimages>";
        } else {
            folderItem.name = folderInfo.path;
            folderItem.path = this.getFilePath(folderItem.name, string);
            folderItem.lastModified = folderInfo.modification;
        }
        return folderItem;
    }

    private FileItem createFileItem(DatastoreBrowser.FileInfo fileInfo, String string) {
        DatastoreBrowser.VmConfigInfo.VmConfigEncryptionInfo vmConfigEncryptionInfo;
        DatastoreBrowser.VmDiskInfo vmDiskInfo;
        FileItem fileItem = new FileItem();
        fileItem.name = fileInfo.path;
        fileItem.path = this.getFilePath(fileInfo.path, string);
        fileItem.fileType = FileManager.FileType.File.name();
        fileItem.className = fileInfo.getClass().getSimpleName();
        if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
            vmDiskInfo = (DatastoreBrowser.VmDiskInfo)fileInfo;
            fileItem.fileType = FileManager.FileType.VirtualDisk.name();
            fileItem.isInflatable = this.isInflatable(vmDiskInfo);
            vmConfigEncryptionInfo = vmDiskInfo.encryption;
            boolean bl = fileItem.isEncrypted = vmConfigEncryptionInfo != null && vmConfigEncryptionInfo.keyId != null;
        }
        if (fileInfo instanceof DatastoreBrowser.VmConfigInfo) {
            vmDiskInfo = (DatastoreBrowser.VmConfigInfo)fileInfo;
            vmConfigEncryptionInfo = vmDiskInfo.encryption;
            fileItem.isEncrypted = vmConfigEncryptionInfo != null && vmConfigEncryptionInfo.keyId != null;
        }
        fileItem.fileInfo = fileInfo;
        fileItem.spriteCssClass = this.getFileIcon(fileInfo);
        fileItem.lastModified = fileInfo.modification;
        fileItem.size = fileInfo.fileSize;
        return fileItem;
    }

    private boolean isInflatable(DatastoreBrowser.VmDiskInfo vmDiskInfo) {
        return vmDiskInfo != null && vmDiskInfo.capacityKb != null && vmDiskInfo.fileSize != null && vmDiskInfo.thin == true && vmDiskInfo.capacityKb * 1024L > vmDiskInfo.fileSize;
    }

    private String getFilePath(String string, String string2) {
        String string3 = null;
        String string4 = StringUtils.trim((String)string2);
        string3 = string4.endsWith("/") ? string4 + string : (string4.endsWith("]") ? String.format("%s %s", string4, string) : String.format("%s/%s", string4, string));
        return string3;
    }

    private String getFileIcon(DatastoreBrowser.FileInfo fileInfo) {
        if (fileInfo instanceof DatastoreBrowser.FloppyImageInfo) {
            return "icon-vSphere-dsFloppyImage";
        }
        if (fileInfo instanceof DatastoreBrowser.VmDiskInfo) {
            return "icon-vSphere-dsVmDisk";
        }
        if (fileInfo instanceof DatastoreBrowser.VmLogInfo) {
            return "icon-vSphere-dsVmLog";
        }
        if (fileInfo instanceof DatastoreBrowser.VmNvramInfo) {
            return "icon-vSphere-dsVmNvram";
        }
        if (fileInfo instanceof DatastoreBrowser.IsoImageInfo) {
            return "icon-vSphere-dsIsoImage";
        }
        if (fileInfo instanceof DatastoreBrowser.VmSnapshotInfo) {
            return "icon-vSphere-dsVmSnapshot";
        }
        if (fileInfo instanceof DatastoreBrowser.TemplateVmConfigInfo) {
            return "icon-vSphere-dsVmTemplate";
        }
        if (fileInfo instanceof DatastoreBrowser.VmConfigInfo) {
            return "vsphere-icon-vm";
        }
        return "icon-vSphere-dsFile";
    }

    public String getLocalizedFileType(DatastoreBrowser.FileInfo fileInfo) {
        String string = "";
        string = fileInfo instanceof DatastoreBrowser.FloppyImageInfo ? "dsExplorer.floppyImage" : (fileInfo instanceof DatastoreBrowser.IsoImageInfo ? "dsExplorer.isoImage" : (fileInfo instanceof DatastoreBrowser.VmDiskInfo ? "dsExplorer.vmDisk" : (fileInfo instanceof DatastoreBrowser.TemplateVmConfigInfo ? "dsExplorer.templateVMConfig" : (fileInfo instanceof DatastoreBrowser.VmConfigInfo ? "dsExplorer.vmConfig" : (fileInfo instanceof DatastoreBrowser.VmLogInfo ? "dsExplorer.vmLog" : (fileInfo instanceof DatastoreBrowser.VmNvramInfo ? "dsExplorer.vmNvram" : (fileInfo instanceof DatastoreBrowser.VmSnapshotInfo ? "dsExplorer.vmSnapshot" : (fileInfo instanceof DatastoreBrowser.FolderInfo ? "dsExplorer.folder" : "dsExplorer.file"))))))));
        return CommonUtils.text(string);
    }

    private FileSpec createFileSpec(String string, DatastoreBrowser.SearchSpec searchSpec, boolean bl) {
        FileSpec fileSpec = new FileSpec();
        fileSpec.datastorePath = string;
        fileSpec.subFolders = bl;
        fileSpec.searchSpec = searchSpec;
        return fileSpec;
    }

    private DatastoreBrowser.SearchSpec createSearchSpec(int n, String string, boolean bl) {
        DatastoreBrowser.VmDiskQuery vmDiskQuery;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if ((n & 2) > 0) {
            arrayList.add(new DatastoreBrowser.FloppyImageQuery());
        }
        if ((n & 4) > 0) {
            arrayList.add(new DatastoreBrowser.IsoImageQuery());
        }
        if ((n & 1) > 0) {
            arrayList.add(new DatastoreBrowser.VmDiskQuery());
        }
        if ((n & 0x40) > 0) {
            vmDiskQuery = new DatastoreBrowser.VmDiskQuery();
            vmDiskQuery.details = new DatastoreBrowser.VmDiskQuery.Details();
            vmDiskQuery.details.capacityKb = true;
            vmDiskQuery.details.diskType = true;
            vmDiskQuery.details.thin = true;
            vmDiskQuery.details.hardwareVersion = true;
            vmDiskQuery.details.encryption = true;
            arrayList.add(vmDiskQuery);
        }
        if ((n & 8) > 0) {
            arrayList.add(new DatastoreBrowser.VmConfigQuery());
            arrayList.add(new DatastoreBrowser.TemplateVmConfigQuery());
        }
        if ((n & 0x20) > 0) {
            arrayList.add(new DatastoreBrowser.FolderQuery());
        }
        if ((n & ALL_FILES_TYPE) > 0) {
            arrayList.add(new DatastoreBrowser.FolderQuery());
            arrayList.add(new DatastoreBrowser.FloppyImageQuery());
            arrayList.add(new DatastoreBrowser.IsoImageQuery());
            vmDiskQuery = new DatastoreBrowser.VmConfigQuery();
            vmDiskQuery.details = new DatastoreBrowser.VmConfigQuery.Details();
            vmDiskQuery.details.encryption = true;
            arrayList.add(vmDiskQuery);
            DatastoreBrowser.TemplateVmConfigQuery templateVmConfigQuery = new DatastoreBrowser.TemplateVmConfigQuery();
            templateVmConfigQuery.details = new DatastoreBrowser.VmConfigQuery.Details();
            templateVmConfigQuery.details.encryption = true;
            arrayList.add(new DatastoreBrowser.TemplateVmConfigQuery());
            arrayList.add(new DatastoreBrowser.VmLogQuery());
            arrayList.add(new DatastoreBrowser.VmNvramQuery());
            arrayList.add(new DatastoreBrowser.VmSnapshotQuery());
            DatastoreBrowser.VmDiskQuery vmDiskQuery2 = new DatastoreBrowser.VmDiskQuery();
            vmDiskQuery2.details = new DatastoreBrowser.VmDiskQuery.Details();
            vmDiskQuery2.details.capacityKb = true;
            vmDiskQuery2.details.diskExtents = true;
            vmDiskQuery2.details.thin = true;
            vmDiskQuery2.details.encryption = true;
            arrayList.add(vmDiskQuery2);
            arrayList.add(new DatastoreBrowser.Query());
        }
        vmDiskQuery = new DatastoreBrowser.SearchSpec();
        vmDiskQuery.query = arrayList.toArray(new DatastoreBrowser.Query[0]);
        if (bl) {
            vmDiskQuery.searchCaseInsensitive = true;
            vmDiskQuery.sortFoldersFirst = true;
            vmDiskQuery.details = new DatastoreBrowser.FileInfo.Details();
            vmDiskQuery.details.fileOwner = true;
            vmDiskQuery.details.fileSize = true;
            vmDiskQuery.details.fileType = true;
            vmDiskQuery.details.modification = true;
        }
        if (!StringUtil.isNullOrEmpty((String)string)) {
            vmDiskQuery.matchPattern = new String[]{string};
        }
        return vmDiskQuery;
    }

    private Map<String, List<ParameterSpec>> getFilePropParamSpecs(FileSpec fileSpec) {
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = fileSpec;
        parameterSpec.propertyName = "file";
        ArrayList<ParameterSpec> arrayList = new ArrayList<ParameterSpec>(1);
        arrayList.add(parameterSpec);
        HashMap<String, List<ParameterSpec>> hashMap = new HashMap<String, List<ParameterSpec>>();
        hashMap.put("file", arrayList);
        return hashMap;
    }
}

