/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.CombinedExtensionPointInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginConstants;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.mvc.controllers.ExtensionServiceUtil;
import com.vmware.vise.mvc.model.Plugin;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ExtensionServiceController {
    private static final String BUNDLE_NAME = "CommonMvc";
    private static final Log _logger = LogFactory.getLog(ExtensionServiceController.class);
    private final ExtensionService _extensionService;
    private final ObjectReferenceService _objRefService;
    private final String CERTIFIED_YES = "Plugin.vmwareCertified.yes";
    private final String CERTIFIED_NO = "Plugin.vmwareCertified.no";
    private final String CERTIFIED_UNKNOWN = "Plugin.vmwareCertified.unknown";

    @Autowired
    public ExtensionServiceController(ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._extensionService = extensionService;
        this._objRefService = objectReferenceService;
    }

    @RequestMapping(value={"/extensions/{pointId}/{objectId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public <T> List<T> getExtensionObjects(@PathVariable(value="pointId") String string, @PathVariable(value="objectId") String string2) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /extensions/", string, "/", string2}));
        }
        Map<String, Object> map = ExtensionServiceUtil.getFilterContext(this._objRefService, string2);
        List list = this._extensionService.getExtensionObjects(string, map, true);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /extensions/", string, "/", string2}));
        }
        return list;
    }

    @RequestMapping(value={"/hostedextensions/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public <T> List<T> getHostedExtensionObjectsByExtensionId(@PathVariable(value="extensionId") String string, @RequestParam(value="objectId", required=false) String string2) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /hostedextensions/", string, " for ", string2}));
        }
        List list = ExtensionServiceUtil.getHostedExtensionObjectsByExtensionId(this._extensionService, string, this._objRefService, string2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /hostedextensions/", string, " for ", string2}));
        }
        return list;
    }

    @RequestMapping(value={"/allExtensions"}, method={RequestMethod.GET})
    @ResponseBody
    public CombinedExtensionPointInfo[] getAllExtensionObjects() {
        _logger.debug((Object)"GET /allExtensions");
        CombinedExtensionPointInfo[] combinedExtensionPointInfoArray = this._extensionService.getAllCombinedExtensionPointInfos();
        Arrays.sort(combinedExtensionPointInfoArray, new Comparator<CombinedExtensionPointInfo>(){

            @Override
            public int compare(CombinedExtensionPointInfo combinedExtensionPointInfo, CombinedExtensionPointInfo combinedExtensionPointInfo2) {
                return combinedExtensionPointInfo.getPoint().getId().compareTo(combinedExtensionPointInfo2.getPoint().getId());
            }
        });
        _logger.trace((Object)"Finish execution of GET /allExtensions");
        return combinedExtensionPointInfoArray;
    }

    @RequestMapping(value={"/plugins"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Plugin> getAllUserPlugins() throws Exception {
        _logger.debug((Object)"GET /plugins");
        PluginPackageInfo[] pluginPackageInfoArray = this._extensionService.getAllKnownPluginPackageInfos();
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        for (int i = 0; i < pluginPackageInfoArray.length; ++i) {
            PluginPackageInfo pluginPackageInfo = pluginPackageInfoArray[i];
            if (ArrayUtil.contains((Object)pluginPackageInfo.getId(), (Object[])PluginConstants.CORE_VSPHERE_CLIENT_PACKAGE_IDS).booleanValue()) continue;
            Plugin plugin = new Plugin(pluginPackageInfo);
            String string = this.calculateVmwareCertifiedMessage(pluginPackageInfo.getSigningState());
            plugin.setVmwareCertifiedMessage(string);
            arrayList.add(plugin);
        }
        _logger.trace((Object)"Finish execution of GET /plugins");
        return arrayList;
    }

    @RequestMapping(value={"/pluginInfos"}, method={RequestMethod.GET})
    @ResponseBody
    public PluginInfo[] getAllPluginInfos() throws Exception {
        PluginInfo[] pluginInfoArray = this._extensionService.getPluginInfos();
        return pluginInfoArray;
    }

    @RequestMapping(value={"/checkForNewPlugins"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean areNewPluginsInstalled() throws Exception {
        PluginInfo[] pluginInfoArray;
        PluginInfo[] pluginInfoArray2 = this._extensionService.getPluginInfos();
        if (pluginInfoArray2.length < (pluginInfoArray = this._extensionService.getAllPluginInfos()).length) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginInfo pluginInfo : pluginInfoArray2) {
            String string = pluginInfo.getId();
            hashSet.add(string);
        }
        for (PluginInfo pluginInfo : pluginInfoArray) {
            if (hashSet.contains(pluginInfo.getId())) continue;
            return true;
        }
        return false;
    }

    private String calculateVmwareCertifiedMessage(PluginPackageInfo.PluginPackageSigningState pluginPackageSigningState) {
        if (pluginPackageSigningState == PluginPackageInfo.PluginPackageSigningState.SIGNED) {
            return this.getLocalizedString("Plugin.vmwareCertified.yes");
        }
        if (pluginPackageSigningState == PluginPackageInfo.PluginPackageSigningState.UNSIGNED) {
            return this.getLocalizedString("Plugin.vmwareCertified.no");
        }
        return this.getLocalizedString("Plugin.vmwareCertified.unknown");
    }

    private String getLocalizedString(String string) {
        return ResourceUtil.getString((String)BUNDLE_NAME, (String)string, (String[])new String[0], (ClassLoader)ExtensionServiceController.class.getClassLoader());
    }
}

