/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.util.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionServiceUtil {
    private static final Log _logger = LogFactory.getLog(ExtensionServiceUtil.class);
    private static final String ONLY_LOCAL_FILTERS = "onlyLocalFilters";

    public static Map<String, Object> getFilterContext(ObjectReferenceService objectReferenceService, String string) {
        Object object = null;
        if (string != null) {
            object = objectReferenceService.getReference(string, true);
        }
        HashMap<String, Object[]> hashMap = null;
        if (object != null) {
            hashMap = new HashMap<String, Object[]>();
            hashMap.put("contextObjects", new Object[]{object});
        }
        return hashMap;
    }

    public static <T> List<T> getHostedExtensionObjectsByExtensionId(ExtensionService extensionService, String string, ObjectReferenceService objectReferenceService, String string2) throws Exception {
        return ExtensionServiceUtil.getHostedExtensionObjectsByExtensionId(extensionService, string, objectReferenceService, string2, null);
    }

    public static <T> List<T> getHostedExtensionObjectsByExtensionId(ExtensionService extensionService, String string, ObjectReferenceService objectReferenceService, String string2, Predicate<String> predicate) throws Exception {
        ExtensionInfo extensionInfo = extensionService.getExtensionInfo(string);
        if (extensionInfo.getHostedPointsIds() == null || extensionInfo.getHostedPointsIds().length == 0) {
            return Collections.emptyList();
        }
        Map<String, Object> map = ExtensionServiceUtil.getFilterContext(objectReferenceService, string2);
        ArrayList arrayList = new ArrayList();
        for (String string3 : extensionInfo.getHostedPointsIds()) {
            if (predicate != null && predicate.evaluate((Object)string3)) continue;
            arrayList.addAll(extensionService.getExtensionObjects(string3, map, true));
        }
        return arrayList;
    }
}

