/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.alarm.AlarmInfo;
import com.vmware.vise.actionsfw.Action;
import com.vmware.vise.actionsfw.ActionContext;
import com.vmware.vise.actionsfw.ActionEvaluation;
import com.vmware.vise.actionsfw.ActionsRequestSpec;
import com.vmware.vise.actionsfw.ActionsService;
import com.vmware.vise.actionsfw.RequestPolicy;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.mvc.issues.model.IssueSummaryItem;
import com.vmware.vise.mvc.issues.model.IssueSummaryItemResultSet;
import com.vmware.vise.mvc.util.VmToolsUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class IssuesViewController {
    private static final Log _logger = LogFactory.getLog(IssuesViewController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final ObjectReferenceService _objectReferenceService;
    private final QuerySpecBuilder _querySpecBuilder;
    private final QueryExecutor _queryExecutor;
    private final ActionsService _actionsService;
    private static final String ISSUE_TYPE = "Issue";
    private static final String ISSUE_INFO_PROPERTY = "info";
    private static final String ISSUE_ENTITY_PROPERTY = "info.entity";
    private static final String VM_TOOLS_ISSUE = "VmToolsIssue";
    private static final String CONFIG_ISSUE = "ConfigIssue";
    private static final String VM_COMPATIBILITY_ISSUE_TYPE = "VmCompatibilityIssue";
    private static final String ALARM_ISSUE = "AlarmIssue";
    private static final String DETAILS_PROPERTY = "details";
    private static final String ACTION_ID_UNLOCK_VM = "vsphere.core.vm.actions.cryptoUnlock";
    private static final String ACTION_ID_ENABLE_ENCRYPTION_MODE = "vsphere.core.host.actions.enableEncryptionMode";
    private static final String ACTION_ID_ACKNOWLEDGE = "vsphere.opsmgmt.alarms.acknowledge";
    private static final String ACTION_ID_RESET_TO_GREEN = "vsphere.opsmgmt.alarms.reset";
    private static final String ALARM_SYSTEM_NAME_VM_IS_LOCKED = "alarm.VmCryptoStateLockedAlarm";
    private static final String ALARM_SYSTEM_NAME_HOST_REQUIRES_ENCRYPTION_MODE_ENABLED = "alarm.HostRequiresEncryptionModeEnabledAlarm";

    @Autowired
    public IssuesViewController(ObjectReferenceService objectReferenceService, QuerySpecBuilder querySpecBuilder, QueryExecutor queryExecutor, ActionsService actionsService) {
        this._objectReferenceService = objectReferenceService;
        this._querySpecBuilder = querySpecBuilder;
        this._queryExecutor = queryExecutor;
        this._actionsService = actionsService;
    }

    @RequestMapping(value={"/issues"})
    @ResponseBody
    public final IssueSummaryItemResultSet getIssues(@RequestParam(value="objectId", required=true) String string, @RequestParam(value="pageSize", defaultValue="-1") int n, @RequestParam(value="skip", defaultValue="0") int n2, @RequestParam(value="getActionEvaluations", required=false, defaultValue="false") boolean bl) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /issues for ", string}));
        }
        PropertyConstraint propertyConstraint = null;
        Object object = null;
        String[] stringArray = new String[]{ISSUE_INFO_PROPERTY};
        ResultSpec resultSpec = new ResultSpec();
        if (string != null) {
            object = this._objectReferenceService.getReference(string, true);
            propertyConstraint = this.createPropertyConstraint(object);
        }
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(propertyConstraint, stringArray, Collections.singleton(ISSUE_TYPE));
        querySpec.name = this._opId;
        resultSpec.maxResultCount = n;
        resultSpec.offset = n2;
        querySpec.resultSpec = resultSpec;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        IssueSummaryItemResultSet issueSummaryItemResultSet = this.formatResults(resultSet, object, bl);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /issues for ", string}));
        }
        return issueSummaryItemResultSet;
    }

    @RequestMapping(value={"/issues/actions/evaluations"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ActionEvaluation> getIssueActions(@RequestParam(value="objectId", required=true) String string, @RequestParam(value="issueId", required=true) String string2, @RequestBody Map<String, Object> map) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("GET /issues/actions/evaluations for %s and issue %s", string, string2));
        }
        Object object = null;
        if (map != null && !map.isEmpty() && map.containsKey(DETAILS_PROPERTY)) {
            object = map.get(DETAILS_PROPERTY);
        }
        Object object2 = this._objectReferenceService.getReference(string, true);
        Object object3 = this._objectReferenceService.getReference(string2, true);
        ActionsRequestSpec actionsRequestSpec = IssuesViewController.createActionsSpec(object3);
        List<ActionEvaluation> list = new ArrayList<ActionEvaluation>();
        try {
            List<Action> list2 = this._actionsService.getActions(actionsRequestSpec, false);
            list2 = this.filterIssueActions(list2, object, object3, object2);
            list = this.evaluateActions(list2, object2);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error while evaluating available actions for: " + object3), (Throwable)exception);
        }
        return list;
    }

    private PropertyConstraint createPropertyConstraint(Object object) {
        return QueryUtil.createPropertyConstraint((String)ISSUE_TYPE, (String)ISSUE_ENTITY_PROPERTY, (Comparator)Comparator.EQUALS, (Object)object);
    }

    private IssueSummaryItemResultSet formatResults(ResultSet resultSet, Object object, boolean bl) {
        IssueSummaryItemResultSet issueSummaryItemResultSet = new IssueSummaryItemResultSet();
        ArrayList<IssueSummaryItem> arrayList = new ArrayList<IssueSummaryItem>();
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                IssueInfo issueInfo = (IssueInfo)propertyValue.value;
                IssueSummaryItem issueSummaryItem = new IssueSummaryItem();
                issueSummaryItem.issueUid = this._objectReferenceService.getUid(resultItem.resourceObject);
                if (issueInfo.entity != null) {
                    issueSummaryItem.entity = issueInfo.entity;
                    issueSummaryItem.entityId = this._objectReferenceService.getUid(issueInfo.entity);
                }
                if (object != null && !object.equals(issueInfo.entity)) {
                    issueSummaryItem.entityName = issueInfo.entityName;
                }
                issueSummaryItem.description = issueInfo.description;
                issueSummaryItem.descriptionKey = issueInfo.descriptionKey;
                issueSummaryItem.status = issueInfo.status;
                issueSummaryItem.issueType = issueInfo.typeDisplayName;
                issueSummaryItem.details = issueInfo.details;
                issueSummaryItem.dateText = issueInfo.timestamp != null ? new SimpleDateFormat("MM/dd/yyyy h:mm:ss a").format(issueInfo.timestamp) : "";
                if (bl) {
                    ActionsRequestSpec actionsRequestSpec = IssuesViewController.createActionsSpec(resultItem.resourceObject);
                    try {
                        List<Action> list = this._actionsService.getActions(actionsRequestSpec, false);
                        list = this.filterIssueActions(list, issueInfo.details, resultItem.resourceObject, object);
                        issueSummaryItem.actionEvaluations = this.evaluateActions(list, object);
                    }
                    catch (Exception exception) {
                        _logger.error((Object)("Error while evaluating available actions for: " + resultItem.resourceObject), (Throwable)exception);
                    }
                }
                arrayList.add(issueSummaryItem);
            }
        }
        issueSummaryItemResultSet.totalMatchedObjectCount = resultSet.totalMatchedObjectCount;
        issueSummaryItemResultSet.summaryItemSpecs = arrayList;
        return issueSummaryItemResultSet;
    }

    private List<Action> filterIssueActions(List<Action> list, Object object, Object object2, Object object3) {
        if (object == null || object3 == null || object2 == null) {
            return list;
        }
        String string = this._objectReferenceService.getResourceObjectType(object2);
        String string2 = this._objectReferenceService.getResourceObjectType(object3);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (Action action : list) {
            if (!this.checkIsActionApplicable(action, string, string2, object)) continue;
            arrayList.add(action);
        }
        return arrayList;
    }

    private boolean checkIsActionApplicable(Action action, String string, String string2, Object object) {
        List list = action.getApplicableTargetTypes();
        if (list.contains(string) && list.contains(string2)) {
            return this.checkIsActionApplicableByIssueType(string, action, object, list);
        }
        return false;
    }

    private boolean checkIsActionApplicableByIssueType(String string, Action action, Object object, List<String> list) {
        String string2 = object.getClass().getSimpleName();
        if (string.equals(VM_TOOLS_ISSUE)) {
            if (!VmToolsUtil.isVmIssueActionInapplicable(action, object).booleanValue()) {
                return true;
            }
        } else if (string.equals(CONFIG_ISSUE)) {
            if (list.contains(string2)) {
                return true;
            }
        } else {
            if (string.equals(VM_COMPATIBILITY_ISSUE_TYPE) && object instanceof Boolean) {
                return (Boolean)object;
            }
            if (string.equals(ALARM_ISSUE)) {
                try {
                    if (ACTION_ID_UNLOCK_VM.equals(action.getUid()) || ACTION_ID_ENABLE_ENCRYPTION_MODE.equals(action.getUid())) {
                        Field field = object.getClass().getDeclaredField("alarmInfo");
                        AlarmInfo alarmInfo = (AlarmInfo)field.get(object);
                        if (ACTION_ID_UNLOCK_VM.equals(action.getUid())) {
                            return ALARM_SYSTEM_NAME_VM_IS_LOCKED.equals(alarmInfo.systemName);
                        }
                        if (ACTION_ID_ENABLE_ENCRYPTION_MODE.equals(action.getUid())) {
                            return ALARM_SYSTEM_NAME_HOST_REQUIRES_ENCRYPTION_MODE_ENABLED.equals(alarmInfo.systemName);
                        }
                    }
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    _logger.debug((Object)reflectiveOperationException);
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private List<ActionEvaluation> evaluateActions(List<Action> list, Object object) throws Exception {
        if (ArrayUtil.isNullOrEmpty(list)) {
            return null;
        }
        ActionsRequestSpec actionsRequestSpec = IssuesViewController.createActionsSpec(object);
        actionsRequestSpec.actionUids = new ArrayList(list.size());
        for (Action action : list) {
            actionsRequestSpec.actionUids.add(action.getUid());
        }
        return this._actionsService.getEvaluatedActions(actionsRequestSpec, false);
    }

    private static ActionsRequestSpec createActionsSpec(Object object) {
        ActionsRequestSpec actionsRequestSpec = new ActionsRequestSpec();
        actionsRequestSpec.context = new ActionContext();
        actionsRequestSpec.globalActions = RequestPolicy.EXCLUDE;
        actionsRequestSpec.context.setTargetObjects(Arrays.asList(object));
        return actionsRequestSpec;
    }
}

