/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.vmware.cis.data.api.ComplexQuerySupport;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.common.api.filters.QueryFilterRegistry;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.metadata.MetadataService;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.mvc.lists.ColumnDataSourceInfo;
import com.vmware.vise.mvc.lists.ListOptions;
import com.vmware.vise.mvc.listview.ListViewExportSpec;
import com.vmware.vise.mvc.listview.ListViewSpec;
import com.vmware.vise.mvc.listview.SortDirection;
import com.vmware.vise.mvc.listview.SortSpec;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.model.data.ParamSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.util.ParameterSpecHelper;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import com.vmware.vsphere.client.export.ExportColumn;
import com.vmware.vsphere.client.export.ExportFormat;
import com.vmware.vsphere.client.export.ExportListSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/list"})
public class ListViewController {
    private static final Log _logger = LogFactory.getLog(ListViewController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private static final String RELATED_ITEMS_LIST_FILTER_ID = "relatedItemsListFilterId";
    private static final String SIMPLE_SEARCH_LIST_FILTER_ID = "simpleSearchListFilterId";
    private static final String PROPERTY_LENGTH_SUFFIX = "._length";
    private static final String PROPERTY_FORMAT_SUFFIX = "@formatted";
    private final ObjectReferenceService _objectReferenceService;
    private final ExtensionService _extensionService;
    private final MetadataService _metadataService;
    private final QueryServiceFactory _queryServiceFactory;
    private final QueryFilterRegistry _queryFilterRegistry;
    private final RelatedItemsManager _relatedItemsManager;
    private final ObjectTypesManager _objectTypesManager;
    private final ClassLoaderService _classLoaderService;
    private final ObjectMapper _objectMapper;
    private final MutationService _mutationService;
    private static final String OBJECT_ID = "id";

    @Autowired
    public ListViewController(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ExtensionService extensionService, MetadataService metadataService, QueryServiceFactory queryServiceFactory, QueryFilterRegistry queryFilterRegistry, RelatedItemsManager relatedItemsManager, ObjectTypesManager objectTypesManager, ClassLoaderService classLoaderService, ObjectMapper objectMapper, MutationService mutationService) {
        this._objectReferenceService = objectReferenceService;
        this._extensionService = extensionService;
        this._metadataService = metadataService;
        this._queryServiceFactory = queryServiceFactory;
        this._queryFilterRegistry = queryFilterRegistry;
        this._relatedItemsManager = relatedItemsManager;
        this._objectTypesManager = objectTypesManager;
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._mutationService = mutationService;
    }

    @RequestMapping(value={"/ex/"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> getListDataEx(@RequestBody ListViewSpec listViewSpec) throws Exception {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listViewSpec.queryFilterId) ? 1 : 0) != 0, (Object)"Need a filterId to retrieve the list data.");
        Preconditions.checkArgument((!ArrayUtil.isNullOrEmpty((Object[])listViewSpec.dataModels) ? 1 : 0) != 0, (Object)"Data model(s) are required.");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /list/ex for ", listViewSpec.queryFilterId}));
        }
        ResultSet resultSet = this.getListDataResult(listViewSpec);
        Map<String, Object> map = this.transformRelationDataToMap(resultSet);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /list/ex for ", listViewSpec.queryFilterId}));
        }
        return map;
    }

    @RequestMapping(value={"/columndefinitions/{listViewId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ColumnDataSourceInfo> getListColumnDefinitions(@PathVariable(value="listViewId") String string, @RequestParam(value="listViewType", required=false) String string2, @RequestParam(value="objectId", required=false) String string3) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /list/columndefinitions/", string}));
        }
        return this.getColumnDataSourceInfos(string, string2, string3);
    }

    @RequestMapping(value={"/listOptions/{listViewId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public ListOptions getListOptions(@PathVariable(value="listViewId") String string, @RequestParam(value="listViewType", required=false) String string2, @RequestParam(value="objectId", required=false) String string3) throws Exception {
        ListOptions listOptions = new ListOptions();
        listOptions.columnDataSourceInfos = this.getColumnDataSourceInfos(string, string2, string3);
        ExtensionInfo extensionInfo = this._extensionService.getExtensionInfo(string);
        ComponentSpec componentSpec = null;
        if (extensionInfo != null) {
            componentSpec = (ComponentSpec)this._extensionService.getExtensionObject(extensionInfo, null, true);
        }
        listOptions.metadata = componentSpec != null && componentSpec.contentSpec != null && componentSpec.contentSpec.metadata != null ? componentSpec.contentSpec.metadata : Collections.emptyMap();
        return listOptions;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult getExportResult(@RequestBody ListViewExportSpec listViewExportSpec) throws Exception {
        ExportColumn exportColumn2;
        ListViewSpec listViewSpec = listViewExportSpec.listViewSpec;
        Preconditions.checkArgument((listViewSpec != null ? 1 : 0) != 0, (Object)"Need a list view spec.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)listViewSpec.queryFilterId) ? 1 : 0) != 0, (Object)"Need a filterId to retrieve the list data.");
        Preconditions.checkArgument((!ArrayUtil.isNullOrEmpty((Object[])listViewSpec.dataModels) ? 1 : 0) != 0, (Object)"Data model(s) are required.");
        Preconditions.checkArgument((!ArrayUtil.isNullOrEmpty((Object[])listViewExportSpec.columns) ? 1 : 0) != 0, (Object)"Columns are required.");
        listViewSpec.skip = 0;
        listViewSpec.take = -1;
        if (!ArrayUtil.isNullOrEmpty((Object[])listViewExportSpec.selectedObjectIds)) {
            listViewSpec.queryFilterId = SIMPLE_SEARCH_LIST_FILTER_ID;
            listViewSpec.filterParams = new String[listViewExportSpec.selectedObjectIds.length];
            int n = 0;
            for (String string : listViewExportSpec.selectedObjectIds) {
                listViewSpec.filterParams[n++] = string;
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /list/export for ", listViewSpec.queryFilterId}));
        }
        String[] stringArray = new String[listViewExportSpec.columns.length];
        int n = 0;
        for (ExportColumn exportColumn2 : listViewExportSpec.columns) {
            stringArray[n++] = exportColumn2.propertyName;
        }
        listViewSpec.requestedProperties = stringArray;
        ResultSet resultSet = this.getListDataResult(listViewSpec);
        ResultItem[] resultItemArray = this.transformRelationDataToExportItems(resultSet);
        ExportListSpec exportListSpec = new ExportListSpec();
        exportListSpec.items = resultItemArray;
        exportListSpec.columns = listViewExportSpec.columns;
        exportListSpec.format = listViewExportSpec.format != null ? listViewExportSpec.format : ExportFormat.CSV;
        exportColumn2 = this._mutationService.add((Object)exportListSpec);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /list/export for ", listViewSpec.queryFilterId}));
        }
        return exportColumn2;
    }

    private List<ColumnDataSourceInfo> getColumnDataSourceInfos(String string, String string2, String string3) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        if (string2 != null) {
            hashSet.add(string2);
        } else {
            hashSet.addAll(this.getListViewTypesById(string));
        }
        Collection<String> collection = this.getUnsearchableProperties(hashSet);
        List<ColumnDataSourceInfo> list = this.getColumDefinitions(string, string3);
        ListViewController.augmentColumnDefinitions(list, collection);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /list/columndefinitions/", string}));
        }
        return list;
    }

    private List<ColumnDataSourceInfo> getColumDefinitions(String string, String string2) throws Exception {
        ExtensionInfo extensionInfo = this._extensionService.getExtensionInfo(string);
        if (extensionInfo == null || extensionInfo.getHostedPointsIds() == null || extensionInfo.getHostedPointsIds().length == 0) {
            return Collections.emptyList();
        }
        Map<String, Object> map = this.createFilterContextForColumnDefinitions(string2);
        ArrayList<ColumnDataSourceInfo> arrayList = new ArrayList<ColumnDataSourceInfo>();
        for (String string3 : extensionInfo.getHostedPointsIds()) {
            arrayList.addAll(this._extensionService.getExtensionObjects(string3, map, true));
        }
        return arrayList;
    }

    private Map<String, Object> createFilterContextForColumnDefinitions(String string) {
        Object object = null;
        object = string != null ? this._objectReferenceService.getReference(string, true) : "NO_OBJECT";
        HashMap<String, Object[]> hashMap = null;
        if (object != null) {
            hashMap = new HashMap<String, Object[]>();
            hashMap.put("contextObjects", new Object[]{object});
        }
        return hashMap;
    }

    private Collection<String> getListViewTypesById(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Map<String, ObjectTypeSpec> map = this._objectTypesManager.getAllObjectTypeSpecs();
        for (ObjectTypeSpec objectTypeSpec : map.values()) {
            if (objectTypeSpec == null || objectTypeSpec.types == null || objectTypeSpec.listViewId == null || !objectTypeSpec.listViewId.equals(string)) continue;
            hashSet.addAll(Arrays.asList(objectTypeSpec.types));
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    private Collection<String> getUnsearchableProperties(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : collection) {
            PropertyDescriptor[] propertyDescriptorArray;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = this._metadataService.getPropertyMetadata(string)) {
                String string2 = propertyDescriptor.inapplicableOperators;
                if (string2 == null || !string2.contains(Comparator.TEXTUALLY_MATCHES.name())) continue;
                hashSet.add(propertyDescriptor.name);
                if (propertyDescriptor.aliases == null) continue;
                hashSet.addAll(Arrays.asList(propertyDescriptor.aliases));
            }
        }
        return Collections.unmodifiableCollection(hashSet);
    }

    private static void augmentColumnDefinitions(Collection<ColumnDataSourceInfo> collection, Collection<String> collection2) {
        for (ColumnDataSourceInfo columnDataSourceInfo : collection) {
            String string = columnDataSourceInfo.sortProperty;
            if (StringUtil.isNullOrEmpty((String)string)) {
                columnDataSourceInfo.searchable = false;
                continue;
            }
            if (string.endsWith(PROPERTY_LENGTH_SUFFIX)) {
                columnDataSourceInfo.searchable = false;
                continue;
            }
            if (!collection2.contains(string = ListViewController.removeFormatSuffix(string))) continue;
            columnDataSourceInfo.searchable = false;
        }
    }

    private Optional<Filter> createFilterForRelatedItems(String string, String[] stringArray) {
        Object object;
        if (ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            throw new IllegalArgumentException("Filter parameters expected.");
        }
        String string2 = stringArray[0];
        if (string != null) {
            object = this._objectReferenceService.getReference(string, true);
        } else {
            String string3 = stringArray[1];
            object = DefaultUriSchemeUtil.createUri((String)string3, (String)string3);
        }
        return this._relatedItemsManager.getFilterByRelationId(object, string2);
    }

    private Optional<Filter> createFilterForSearch(String[] stringArray) {
        Validate.notNull((Object)stringArray, (String)"Filter parameters expected.");
        if (stringArray.length == 0) {
            return Optional.absent();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object object = this._objectReferenceService.getReference(string, true);
            if (object == null) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Unrecognized object type.");
        }
        PropertyPredicate propertyPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, arrayList);
        return Optional.of((Object)new Filter(Collections.singletonList(propertyPredicate)));
    }

    private Optional<Filter> createFilter(String string, String string2, String[] stringArray, ParamSpec[] paramSpecArray) throws IOException, ClassNotFoundException {
        Validate.notNull((Object)"Need a constraint object id to retrieve the list data.");
        Filter filter = ArrayUtil.isNullOrEmpty((Object[])stringArray) ? this._queryFilterRegistry.get(string2, new Object[]{string}) : this._queryFilterRegistry.get(string2, new Object[]{string, stringArray});
        Validate.notNull((Object)filter, (String)("Invalid filter Id: " + string2));
        if (!ArrayUtil.isNullOrEmpty((Object[])paramSpecArray)) {
            ParameterSpecHelper parameterSpecHelper = new ParameterSpecHelper(this._classLoaderService, this._objectMapper, paramSpecArray);
            Map<String, List<ParameterSpec>> map = parameterSpecHelper.getParameterSpecs();
            ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>();
            arrayList.addAll(filter.getCriteria());
            LogicalOperator logicalOperator = filter.getOperator();
            for (Map.Entry<String, List<ParameterSpec>> entry : map.entrySet()) {
                for (ParameterSpec parameterSpec : entry.getValue()) {
                    PropertyPredicate propertyPredicate = new PropertyPredicate(entry.getKey() + "/@param", PropertyPredicate.ComparisonOperator.EQUAL, parameterSpec.parameter);
                    arrayList.add(propertyPredicate);
                }
            }
            filter = new Filter(arrayList, logicalOperator);
        }
        return Optional.of((Object)filter);
    }

    private static Optional<Filter> createUserFilteringCriteria(String string, String[] stringArray) {
        if (StringUtil.isNullOrEmpty((String)string) || ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            return Optional.absent();
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>();
        for (String string2 : stringArray) {
            if (StringUtil.isNullOrEmpty((String)string2)) continue;
            PropertyPredicate propertyPredicate = PropertyPredicate.containsIgnoreCase((String)string2, (String)string);
            arrayList.add(propertyPredicate);
        }
        if (arrayList.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new Filter(arrayList, LogicalOperator.OR));
    }

    private ResultSet getListDataResult(ListViewSpec listViewSpec) throws Exception {
        Optional<Filter> optional2 = RELATED_ITEMS_LIST_FILTER_ID.equals(listViewSpec.queryFilterId) ? this.createFilterForRelatedItems(listViewSpec.constraintObjectId, listViewSpec.filterParams) : (SIMPLE_SEARCH_LIST_FILTER_ID.equals(listViewSpec.queryFilterId) ? this.createFilterForSearch(listViewSpec.filterParams) : this.createFilter(listViewSpec.constraintObjectId, listViewSpec.queryFilterId, listViewSpec.filterParams, listViewSpec.propertyParamSpecs));
        Optional<Filter> optional3 = ListViewController.createUserFilteringCriteria(listViewSpec.searchTerm, listViewSpec.searchableProperties);
        QueryService queryService = this._queryServiceFactory.getQueryService();
        List<SortCriterion> list = this.createSortCriteria(listViewSpec.sort);
        if (list.isEmpty()) {
            list.add(new SortCriterion("@modelKey"));
        }
        QueryCommand.Builder builder = queryService.select(Arrays.asList(listViewSpec.requestedProperties)).from(listViewSpec.dataModels).orderBy(list).offset(listViewSpec.skip).limit(listViewSpec.take).withTotalCount().opId(this.buildOperationId(listViewSpec));
        if (optional2.isPresent()) {
            builder.where((Filter)optional2.get());
        }
        ResultSet resultSet = optional3.isPresent() ? ComplexQuerySupport.joinFilter((QueryCommand)builder.build(), (Filter)((Filter)optional3.get())) : builder.fetch();
        return resultSet;
    }

    private List<SortCriterion> createSortCriteria(SortSpec[] sortSpecArray) {
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>();
        if (!ArrayUtil.isNullOrEmpty((Object[])sortSpecArray)) {
            for (SortSpec sortSpec : sortSpecArray) {
                SortCriterion.SortDirection sortDirection = SortCriterion.SortDirection.ASCENDING;
                if (SortDirection.desc.equals((Object)sortSpec.dir)) {
                    sortDirection = SortCriterion.SortDirection.DESCENDING;
                }
                SortCriterion sortCriterion = new SortCriterion(ListViewController.removeFormatSuffix(sortSpec.field), sortDirection);
                arrayList.add(sortCriterion);
            }
        }
        return arrayList;
    }

    private Map<String, Object> transformRelationDataToMap(ResultSet resultSet) {
        ArrayList arrayList = new ArrayList();
        List list = resultSet.getItems();
        for (ResourceItem resourceItem : resultSet.getItems()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String string : resultSet.getProperties()) {
                Object object = resourceItem.get(string);
                if (object != null && this._objectReferenceService.getResourceObjectType(object) != null) {
                    hashMap.put(string, this._objectReferenceService.getUid(object, true));
                    continue;
                }
                hashMap.put(string, object);
            }
            hashMap.put(OBJECT_ID, this._objectReferenceService.getUid(resourceItem.getKey(), true));
            arrayList.add(hashMap);
        }
        HashMap hashMap = new HashMap();
        hashMap.put("data", arrayList);
        hashMap.put("totalResultCount", resultSet.getTotalCount());
        return hashMap;
    }

    private ResultItem[] transformRelationDataToExportItems(ResultSet resultSet) {
        List list = resultSet.getItems();
        ResultItem[] resultItemArray = new ResultItem[list.size()];
        int n = 0;
        for (ResourceItem resourceItem : list) {
            List list2 = resultSet.getProperties();
            PropertyValue[] propertyValueArray = new PropertyValue[list2.size()];
            int n2 = 0;
            for (String string : list2) {
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.propertyName = string;
                propertyValue.value = resourceItem.get(string);
                propertyValueArray[n2++] = propertyValue;
            }
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = resourceItem.getKey();
            resultItem.properties = propertyValueArray;
            resultItemArray[n++] = resultItem;
        }
        return resultItemArray;
    }

    private String buildOperationId(ListViewSpec listViewSpec) {
        String string = this._opId;
        if (listViewSpec.isLiveRefreshRequest) {
            String string2;
            string = string + ".liveRefreshRequest";
            if (!StringUtil.isNullOrEmpty((String)listViewSpec.listViewId)) {
                string = string + "; listViewId=" + listViewSpec.listViewId;
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])listViewSpec.filterParams) && !StringUtil.isNullOrEmpty((String)(string2 = listViewSpec.filterParams[0]))) {
                string = string + "; relationId=" + string2;
            }
        }
        return string;
    }

    private static String removeFormatSuffix(String string) {
        int n = string.lastIndexOf(PROPERTY_FORMAT_SUFFIX);
        if (n > 1) {
            return string.substring(0, n - 1);
        }
        return string;
    }
}

