/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vim.binding.pbm.fault.CompatibilityCheckFault;
import com.vmware.vise.core.model.EntitySpecPair;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.model.data.EntitySpecPairMulti;
import com.vmware.vise.mvc.util.ObjectConvertUtils;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ClassLoaderService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mutation"})
public class MutationServiceController {
    private final MutationService _mutationService;
    private final ObjectReferenceService _objRefService;
    private final ClassLoaderService _classLoaderService;
    private final ObjectMapper _objectMapper;
    private static final Log _logger = LogFactory.getLog(MutationServiceController.class);

    @Autowired
    public MutationServiceController(MutationService mutationService, ClassLoaderService classLoaderService, ObjectMapper objectMapper, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._mutationService = mutationService;
        this._classLoaderService = classLoaderService;
        this._objectMapper = objectMapper;
        this._objRefService = objectReferenceService;
    }

    @RequestMapping(value={"/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult apply(@PathVariable(value="objectId") String string, @RequestParam(value="propertyName", required=true) String string2, @RequestBody Map<String, Object> map) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/", string, " for change in ", string2}));
        }
        ResourceSpec resourceSpec = new ResourceSpec();
        Object object = this._objRefService.getReference(string, true);
        ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
        objectIdentityConstraint.target = object;
        resourceSpec.constraint = objectIdentityConstraint;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = new String[]{string2};
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = map;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        OperationResult[] operationResultArray = this._mutationService.applyData(resourceSpec);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/", string, " for change in ", string2}));
        }
        return operationResultArray[0];
    }

    @RequestMapping(value={"/apply/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult apply(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType", required=true) String string2, @RequestBody String string3) {
        Object object;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/apply", string, " for ", string2}));
        }
        OperationResult operationResult = new OperationResult();
        Object object2 = null;
        try {
            object = this._classLoaderService.loadClass(string2);
            object2 = ObjectConvertUtils.fromJson(this._objectMapper, object, string3);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return operationResult;
        }
        object = this._objRefService.getReference(string, true);
        operationResult = this._mutationService.apply(object, object2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/apply", string, " for ", string2}));
        }
        return operationResult;
    }

    @RequestMapping(value={"/applyMultiSpec/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult applyMultiSpec(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType") String string2, @RequestBody List<Map<String, Object>> list) {
        Class clazz;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/applyMultiSpec", string, " for ", string2}));
        }
        Object[] objectArray = new Object[list.size()];
        try {
            clazz = this._classLoaderService.loadClass(string2);
            for (int i = 0; i < list.size(); ++i) {
                objectArray[i] = this.getJsonObject(list.get(i), clazz);
            }
        }
        catch (Exception exception) {
            OperationResult operationResult = new OperationResult();
            operationResult.error = exception;
            return operationResult;
        }
        clazz = this._mutationService.applyMultiSpec(this._objRefService.getReference(string, true), objectArray);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/applyMultiSpec", string, " for ", string2}));
        }
        return clazz;
    }

    @RequestMapping(value={"/applyOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] applyOnMultiEntity(@RequestParam(value="objectIds", required=true) String[] stringArray, @RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/applyOnMultiEntity for ", string}));
        }
        OperationResult operationResult = new OperationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return new OperationResult[]{operationResult};
        }
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objRefService.getReference(stringArray[i], true);
        }
        OperationResult[] operationResultArray = this._mutationService.applyOnMultiEntity(objectArray, object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/applyOnMultiEntity for ", string}));
        }
        return operationResultArray;
    }

    @RequestMapping(value={"/applyMulti"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] applyMulti(@RequestParam(value="propertyObjectType") String string, @RequestBody EntitySpecPairMulti[] entitySpecPairMultiArray) {
        OperationResult[] operationResultArray;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/applyMulti for ", string}));
        }
        EntitySpecPair[] entitySpecPairArray = new EntitySpecPair[entitySpecPairMultiArray.length];
        try {
            operationResultArray = this._classLoaderService.loadClass(string);
            for (int i = 0; i < entitySpecPairMultiArray.length; ++i) {
                entitySpecPairArray[i] = new EntitySpecPair();
                entitySpecPairArray[i].spec = this.getJsonObject(entitySpecPairMultiArray[i].spec, (Class<?>)operationResultArray);
                entitySpecPairArray[i].entity = this._objRefService.getReference(entitySpecPairMultiArray[i].entity, true);
            }
        }
        catch (Exception exception) {
            OperationResult[] operationResultArray2 = new OperationResult[]{new OperationResult()};
            operationResultArray2[0].error = exception;
            return operationResultArray2;
        }
        operationResultArray = this._mutationService.applyMulti(entitySpecPairArray);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/applyMulti for ", string}));
        }
        return operationResultArray;
    }

    private <T> T getJsonObject(Map<String, Object> map, Class<?> clazz) throws JSONException, IOException {
        JSONObject jSONObject = new JSONObject();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jSONObject.put(entry.getKey(), entry.getValue());
        }
        return (T)this._objectMapper.readValue(jSONObject.toString(), clazz);
    }

    @RequestMapping(value={"/validateOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult[] validateOnMultiEntity(@RequestParam(value="objectIds", required=true) String[] stringArray, @RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/validateOnMultiEntity for ", string}));
        }
        ValidationResult validationResult = new ValidationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            validationResult.error = exception;
            return new ValidationResult[]{validationResult};
        }
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objRefService.getReference(stringArray[i], true);
        }
        ValidationResult[] validationResultArray = this._mutationService.validateOnMultiEntity(objectArray, object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/validateOnMultiEntity for ", string}));
        }
        return validationResultArray;
    }

    @RequestMapping(value={"/validate/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult validate(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType", required=true) String string2, @RequestBody String string3) {
        Object object;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/validate/", string, " for ", string2}));
        }
        ValidationResult validationResult = new ValidationResult();
        Object object2 = null;
        try {
            object = this._classLoaderService.loadClass(string2);
            object2 = ObjectConvertUtils.fromJson(this._objectMapper, object, string3);
        }
        catch (Exception exception) {
            validationResult.error = exception;
            return validationResult;
        }
        object = this._objRefService.getReference(string, true);
        validationResult = this._mutationService.validate(object, object2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/validate/", string, " for ", string2}));
        }
        return validationResult;
    }

    @RequestMapping(value={"/validateSpec"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult validate(@RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/validateSpec/ for ", string}));
        }
        ValidationResult validationResult = new ValidationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            validationResult.error = exception;
            return validationResult;
        }
        validationResult = this._mutationService.validate(null, object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/validateSpec/ for ", string}));
        }
        return validationResult;
    }

    @RequestMapping(value={"/validateMultiSpec"}, method={RequestMethod.POST})
    @ResponseBody
    public ValidationResult[] validateMultiSpec(@RequestParam(value="propertyObjectType", required=true) String string, @RequestBody List<Map<String, Object>> list) throws CompatibilityCheckFault {
        ValidationResult[] validationResultArray;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/validateMultiSpec/ for ", string}));
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[] objectArray = new Object[list.size()];
        try {
            validationResultArray = this._classLoaderService.loadClass(string);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : list.get(i).entrySet()) {
                    jSONObject.put(entry.getKey(), entry.getValue());
                }
                objectArray[i] = ObjectConvertUtils.fromJson(this._objectMapper, validationResultArray, jSONObject.toString());
            }
        }
        catch (Exception exception) {
            return null;
        }
        validationResultArray = this._mutationService.validateMultiSpec(null, objectArray);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/validateMultiSpec/ for ", string}));
        }
        return validationResultArray;
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult add(@RequestParam(value="propertyObjectType", required=true) String string, @RequestBody String string2) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/add/ for ", string}));
        }
        OperationResult operationResult = new OperationResult();
        Object object = null;
        try {
            Class clazz = this._classLoaderService.loadClass(string);
            object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return operationResult;
        }
        operationResult = this._mutationService.add(object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/add/ for ", string}));
        }
        return operationResult;
    }

    @RequestMapping(value={"/addMulti"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] addMulti(@RequestParam(value="propertyObjectType") String string, @RequestBody List<Map<String, Object>> list) {
        OperationResult[] operationResultArray;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/addMulti for ", string}));
        }
        Object[] objectArray = new Object[list.size()];
        try {
            operationResultArray = this._classLoaderService.loadClass(string);
            for (int i = 0; i < list.size(); ++i) {
                JSONObject jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : list.get(i).entrySet()) {
                    jSONObject.put(entry.getKey(), entry.getValue());
                }
                objectArray[i] = this._objectMapper.readValue(jSONObject.toString(), (Class)operationResultArray);
            }
        }
        catch (Exception exception) {
            OperationResult operationResult = new OperationResult();
            operationResult.error = exception;
            return new OperationResult[]{operationResult};
        }
        operationResultArray = this._mutationService.addMulti(objectArray);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/addMulti for ", string}));
        }
        return operationResultArray;
    }

    @RequestMapping(value={"/remove/{objectId:.*}"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult remove(@PathVariable(value="objectId") String string, @RequestParam(value="propertyObjectType", required=false) String string2, @RequestBody(required=false) String string3) {
        Object object;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/remove/", string, " for ", string2}));
        }
        OperationResult operationResult = new OperationResult();
        try {
            object = this.loadPropertyObject(string2, string3);
        }
        catch (Exception exception) {
            operationResult.error = exception;
            _logger.error((Object)String.format("Failed to load property object: %s", string2), (Throwable)exception);
            return operationResult;
        }
        Object object2 = this._objRefService.getReference(string, true);
        operationResult = this._mutationService.remove(object2, object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/remove/", string, " for ", string2}));
        }
        return operationResult;
    }

    @RequestMapping(value={"/removeOnMultiEntity"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult[] removeOnMultiEntity(@RequestParam(value="objectIds", required=true) String[] stringArray, @RequestParam(value="propertyObjectType", required=false) String string, @RequestBody(required=false) String string2) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"POST /mutation/removeOnMultiEntity for ", string}));
        }
        OperationResult operationResult = new OperationResult();
        Object object = null;
        try {
            if (string != null) {
                Class clazz = this._classLoaderService.loadClass(string);
                object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
            }
        }
        catch (Exception exception) {
            operationResult.error = exception;
            return new OperationResult[]{operationResult};
        }
        int n = stringArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this._objRefService.getReference(stringArray[i], true);
        }
        OperationResult[] operationResultArray = this._mutationService.removeOnMultiEntity(objectArray, object);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of POST /mutation/removeOnMultiEntity for ", string}));
        }
        return operationResultArray;
    }

    private Object loadPropertyObject(String string, String string2) throws IOException, ClassNotFoundException {
        Object object = null;
        if (string == null) {
            return object;
        }
        Class clazz = this._classLoaderService.loadClass(string);
        object = ObjectConvertUtils.fromJson(this._objectMapper, clazz, string2);
        return object;
    }
}

