/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.common.base.Throwables;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginConstants;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.mvc.filters.ObjectPropertyFilter;
import com.vmware.vise.mvc.filters.PrivilegeFilter;
import com.vmware.vise.mvc.model.ViewSpecInternal;
import com.vmware.vise.mvc.navigation.NavigationNode;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.IUID;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NavigationServiceController {
    private static final List<String> VSPHERE_OBJECT_VALUES = Arrays.asList(VirtualMachine.class.getSimpleName(), HostSystem.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), VirtualApp.class.getSimpleName(), ResourcePool.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), Network.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), "com.vmware.content.Library", "com.vmware.content.library.Item");
    private static final Set<String> VSPHERE_OBJECT_TYPES = new HashSet<String>(VSPHERE_OBJECT_VALUES);
    private static final Set<String> VALID_PLUGIN_PACKAGE_IDS = new HashSet<String>(Arrays.asList(PluginConstants.CORE_VSPHERE_CLIENT_PACKAGE_IDS));
    private static final String PUBLIC_EXT_POINTS = "vsphere\\.core\\..+\\.(monitorViews|manageViews|manage\\.settingsViews|monitor\\.issuesViews|monitor\\.performanceViews|manage\\.alarmDefinitionsViews)";
    private static final Pattern CONFIG_OR_MONITOR_EXT_ID = Pattern.compile("vsphere\\.core\\..+\\.(monitorViews|manageViews|manage\\.settingsViews|monitor\\.issuesViews|monitor\\.performanceViews|manage\\.alarmDefinitionsViews)");
    private static final Log _logger = LogFactory.getLog(NavigationServiceController.class);
    private final String _opId = "h5c-" + this.getClass().getSimpleName() + ":";
    private final ObjectReferenceService _objRefService;
    private final QueryServiceFactory _queryServiceFactory;
    private final ExtensionService _extensionService;
    private static final String ONLY_LOCAL_FILTERS = "onlyLocalFilters";
    private static NavigationNode OBJECT_NOT_FOUND;
    private final ServiceRegistry _serviceRegistry;

    @Autowired
    public NavigationServiceController(QueryServiceFactory queryServiceFactory, ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ServiceRegistry serviceRegistry) {
        this._extensionService = extensionService;
        this._queryServiceFactory = queryServiceFactory;
        this._objRefService = objectReferenceService;
        this._serviceRegistry = serviceRegistry;
        OBJECT_NOT_FOUND = new NavigationNode();
        NavigationServiceController.OBJECT_NOT_FOUND.error = NavigationNode.ErrorType.OBJECT_NOT_FOUND;
    }

    @RequestMapping(value={"/navigation/data/{extensionId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigationNode getNavigationData(@PathVariable(value="extensionId") String string, @RequestParam(value="objectId", required=false) String string2) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /navigation/data/", string, " for object ", string2}));
        }
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        NavigationNode navigationNode = this.navigate(string, string2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /navigation/data/", string, " for object ", string2}));
        }
        return navigationNode;
    }

    public NavigationNode navigate(String string, String string2) throws Exception {
        ValidationUtil.notNull((Object)string, (String)"extensionId cannot be null");
        ExtensionInfo[][] extensionInfoArray = this._extensionService.getExtensionHosts(string);
        if (extensionInfoArray == null || extensionInfoArray.length == 0) {
            _logger.warn((Object)("No navigation path found for: " + string));
            return null;
        }
        NavigationNode navigationNode = null;
        NavigationNode navigationNode2 = null;
        for (ExtensionInfo[] extensionInfoArray2 : extensionInfoArray) {
            List<ExtensionInfo> list;
            if (extensionInfoArray2[0].getExtendedPointIds().length > 1) continue;
            Map<String, Object> map = this.createFilterContext(string2);
            navigationNode = new NavigationNode();
            navigationNode.extensionObject = this._extensionService.getExtensionObject(extensionInfoArray2[0], map, false);
            if (navigationNode.extensionObject == null) {
                return OBJECT_NOT_FOUND;
            }
            String string3 = ((IUID)navigationNode.extensionObject).getUid();
            ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
            arrayList.add(this.getExtensionInfo(string3));
            this.buildTree(navigationNode, arrayList, string2, extensionInfoArray2, 0);
            if (string2 != null) {
                String string4;
                list = this.excludePluginExtensions(arrayList, string2, string);
                Set<String> set = this.runRemoteFilters(list, string2);
                if (!set.contains(string4 = ((IUID)navigationNode.extensionObject).getUid())) {
                    return OBJECT_NOT_FOUND;
                }
                NavigationServiceController.pruneInvalidNodes(navigationNode, set);
            }
            list = this.probeExtensionPath(navigationNode, extensionInfoArray2);
            if (!((PathResult)((Object)list)).isDesiredExtension) continue;
            navigationNode2 = ((PathResult)((Object)list)).navigationNode;
            break;
        }
        if (navigationNode2 == null) {
            return navigationNode;
        }
        do {
            if (navigationNode2.extensionObject instanceof IUID) continue;
            _logger.warn((Object)"Can't explore the navigation path any further as extension object is not an IUID.");
            return navigationNode;
        } while ((navigationNode2 = this.activateChildIndex(navigationNode2, null)) != null);
        return navigationNode;
    }

    private Set<String> runRemoteFilters(List<ExtensionInfo> list, String string) {
        Object object = this._objRefService.getReference(string, true);
        assert (object != null);
        Filterer filterer = new Filterer(false);
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        hashMap.put("contextObjects", new Object[]{object});
        List list2 = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
        Filterer.FilterResult filterResult = filterer.filterExtensions(list, hashMap, list2);
        if (this.needsExistsCheck(filterResult.executedFilters) && !this.objectExists(object)) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (ExtensionInfo extensionInfo : filterResult.extensionInfos) {
            hashSet.add(extensionInfo.getId());
        }
        return hashSet;
    }

    private boolean needsExistsCheck(List<ExtensionObjectFilter> list) {
        for (ExtensionObjectFilter extensionObjectFilter : list) {
            if (!(extensionObjectFilter instanceof ObjectPropertyFilter) && !(extensionObjectFilter instanceof PrivilegeFilter)) continue;
            return false;
        }
        return true;
    }

    private void buildTree(NavigationNode navigationNode, ArrayList<ExtensionInfo> arrayList, String string, ExtensionInfo[] extensionInfoArray, int n) {
        String string2 = ((IUID)navigationNode.extensionObject).getUid();
        if (n < extensionInfoArray.length && !string2.equals(extensionInfoArray[n].getId())) {
            return;
        }
        ++n;
        List list = this.fetchChildren(string2, string);
        for (Object t : list) {
            NavigationNode navigationNode2 = new NavigationNode();
            navigationNode2.extensionObject = t;
            String string3 = ((IUID)navigationNode2.extensionObject).getUid();
            navigationNode.children.add(navigationNode2);
            arrayList.add(this.getExtensionInfo(string3));
            this.buildTree(navigationNode2, arrayList, string, extensionInfoArray, n);
        }
    }

    private static void pruneInvalidNodes(NavigationNode navigationNode, Set<String> set) {
        if (navigationNode == null || ArrayUtil.isNullOrEmpty(navigationNode.children)) {
            return;
        }
        Iterator<NavigationNode> iterator = navigationNode.children.iterator();
        while (iterator.hasNext()) {
            NavigationNode navigationNode2 = iterator.next();
            assert (navigationNode2 != null);
            String string = ((IUID)navigationNode2.extensionObject).getUid();
            if (set.contains(string)) {
                NavigationServiceController.pruneInvalidNodes(navigationNode2, set);
                continue;
            }
            iterator.remove();
        }
    }

    private PathResult probeExtensionPath(NavigationNode navigationNode, ExtensionInfo[] extensionInfoArray) throws Exception {
        for (int i = 0; i < extensionInfoArray.length; ++i) {
            NavigationNode navigationNode2;
            String string = null;
            if (i + 1 < extensionInfoArray.length) {
                string = extensionInfoArray[i + 1].getId();
            }
            if ((navigationNode2 = this.activateChildIndex(navigationNode, string)) == null && i != extensionInfoArray.length - 1) {
                return new PathResult(false, null);
            }
            navigationNode = navigationNode2;
        }
        return new PathResult(true, navigationNode);
    }

    private NavigationNode activateChildIndex(NavigationNode navigationNode, String string) throws Exception {
        NavigationNode navigationNode2 = null;
        for (int i = 0; i < navigationNode.children.size(); ++i) {
            NavigationNode navigationNode3 = navigationNode.children.get(i);
            if (navigationNode2 != null || !(navigationNode3.extensionObject instanceof IUID)) continue;
            String string2 = ((IUID)navigationNode3.extensionObject).getUid();
            ViewSpecInternal viewSpecInternal = (ViewSpecInternal)navigationNode.extensionObject;
            if (string == null && viewSpecInternal != null && !viewSpecInternal.hostsMultipleViewsSimultaneously) {
                string = string2;
            }
            if (string == null || !string.equals(string2)) continue;
            navigationNode.childIndexToActivate = i;
            navigationNode2 = navigationNode3;
        }
        return navigationNode2;
    }

    private <T> List<T> fetchChildren(String string, String string2) {
        ExtensionInfo extensionInfo = this.getExtensionInfo(string);
        if (extensionInfo.getHostedPointsIds() == null || extensionInfo.getHostedPointsIds().length == 0) {
            return Collections.emptyList();
        }
        Map<String, Object> map = this.createFilterContext(string2);
        ArrayList arrayList = new ArrayList();
        for (String string3 : extensionInfo.getHostedPointsIds()) {
            if (this.isSummaryPortlet(string3)) continue;
            arrayList.addAll(this._extensionService.getExtensionObjects(string3, map, true));
        }
        return arrayList;
    }

    private boolean isSummaryPortlet(String string) {
        return string != null && string.endsWith("summarySectionViews");
    }

    private ExtensionInfo getExtensionInfo(String string) {
        ExtensionInfo extensionInfo = null;
        try {
            extensionInfo = this._extensionService.getExtensionInfo(string);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
        }
        assert (extensionInfo != null);
        return extensionInfo;
    }

    private boolean objectExists(Object object) {
        if (object == null) {
            return true;
        }
        QueryService queryService = this._queryServiceFactory.getQueryService();
        String string = this._objRefService.getResourceObjectType(object);
        ResultSet resultSet = queryService.select(new String[0]).withTotalCount().from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).limit(0).opId(this._opId + object).fetch();
        return resultSet.getTotalCount() != 0;
    }

    private Map<String, Object> createFilterContext(String string) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string != null && (object = this._objRefService.getReference(string, true)) != null) {
            hashMap.put("contextObjects", new Object[]{object});
            hashMap.put(ONLY_LOCAL_FILTERS, true);
        }
        return hashMap;
    }

    private List<ExtensionInfo> excludePluginExtensions(List<ExtensionInfo> list, String string, String string2) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        Object object = this._objRefService.getReference(string, true);
        String string3 = this._objRefService.getResourceObjectType(object);
        if (!VSPHERE_OBJECT_TYPES.contains(string3)) {
            return list;
        }
        for (ExtensionInfo extensionInfo : list) {
            String string4;
            if (!NavigationServiceController.isConfigureOrMonitorView(extensionInfo)) {
                arrayList.add(extensionInfo);
                continue;
            }
            Map map = extensionInfo.getMetadata();
            Object v = map.get("pluginPackageId");
            if (v instanceof String && VALID_PLUGIN_PACKAGE_IDS.contains(string4 = (String)v)) {
                arrayList.add(extensionInfo);
                continue;
            }
            if (!string2.equals(extensionInfo.getId())) continue;
            return list;
        }
        return arrayList;
    }

    private static boolean isConfigureOrMonitorView(ExtensionInfo extensionInfo) {
        String[] stringArray = extensionInfo.getExtendedPointIds();
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            Matcher matcher = CONFIG_OR_MONITOR_EXT_ID.matcher(string);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private static class PathResult {
        public boolean isDesiredExtension;
        public NavigationNode navigationNode;

        public PathResult(boolean bl, NavigationNode navigationNode) {
            this.isDesiredExtension = bl;
            this.navigationNode = navigationNode;
        }
    }
}

