/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorNavigationManager;
import com.vmware.vise.mvc.objectnavigator.model.CategoryNode;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/navigator"})
public class ObjectNavigatorController {
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorController.class);
    private final ObjectNavigatorManager _objectNavigatorManager;
    private final ObjectNavigatorNavigationManager _objectNavigatorNavigationManager;

    @Autowired
    public ObjectNavigatorController(ObjectNavigatorManager objectNavigatorManager, ObjectNavigatorNavigationManager objectNavigatorNavigationManager) {
        this._objectNavigatorManager = objectNavigatorManager;
        this._objectNavigatorNavigationManager = objectNavigatorNavigationManager;
    }

    @RequestMapping(value={"/root"}, method={RequestMethod.GET})
    @ResponseBody
    public CategoryNode getRootElement() throws Exception {
        _logger.debug((Object)"GET /navigator/root");
        CategoryNode categoryNode = this._objectNavigatorManager.getRoot(this._objectNavigatorManager.getNodeSpecs());
        _logger.trace((Object)"Finish execution of GET /navigator/root");
        return categoryNode;
    }

    @RequestMapping(value={"/node"}, method={RequestMethod.GET})
    @ResponseBody
    public CategoryNode getCategoryNode(@RequestParam(value="nodeId", required=false) String string) throws Exception {
        CategoryNode categoryNode;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /navigator/node/", string}));
        }
        List<ObjectNavigatorNodeSpec> list = this._objectNavigatorManager.getNodeSpecs();
        if (string == null || StringUtil.isNullOrEmpty((String)string)) {
            categoryNode = this._objectNavigatorManager.getRoot(list);
            if (categoryNode == null) {
                return null;
            }
            string = categoryNode.uid;
        }
        if ((categoryNode = this._objectNavigatorManager.getCategoryNode(string, list)) == null) {
            return null;
        }
        Set<String> set = this._objectNavigatorManager.getValidExtensionUids(categoryNode);
        if (!set.contains(categoryNode.uid)) {
            return null;
        }
        ObjectNavigatorController.pruneInvalidCategoryNodes(categoryNode.children, set);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /navigator/node/", string}));
        }
        return categoryNode;
    }

    private static void pruneInvalidCategoryNodes(List<CategoryNode> list, Set<String> set) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator<CategoryNode> iterator = list.iterator();
        while (iterator.hasNext()) {
            CategoryNode categoryNode = iterator.next();
            if (!set.contains(categoryNode.uid)) {
                iterator.remove();
                continue;
            }
            ObjectNavigatorController.pruneInvalidCategoryNodes(categoryNode.children, set);
        }
    }

    @RequestMapping(value={"/navigate/{targetViewId:.*}"}, method={RequestMethod.GET})
    @ResponseBody
    public NavigationResponse handleNavigation(@PathVariable(value="targetViewId") String string, @RequestParam(value="context", required=false) String string2, @RequestParam(value="navigator", required=false) String string3, @RequestParam(value="prevNavigator", required=false) String string4) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /navigator/navigate/", string}));
        }
        NavigationResponse navigationResponse = this._objectNavigatorNavigationManager.handleNavigationRequest(string, string2, string3, string4);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /navigator/navigate/", string}));
        }
        return navigationResponse;
    }
}

