/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.util.StringUtil;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/objectTypes"}, method={RequestMethod.GET})
public class ObjectTypesManagerController {
    private static final Log _logger = LogFactory.getLog(ObjectTypesManagerController.class);
    private final ObjectTypesManager _ObjectTypesManager;

    @Autowired
    public ObjectTypesManagerController(@Qualifier(value="objectTypesManager") ObjectTypesManager objectTypesManager) {
        this._ObjectTypesManager = objectTypesManager;
    }

    @RequestMapping(value={"/{objectType}"})
    @ResponseBody
    public ObjectTypeSpec getObjectTypeSpec(@PathVariable(value="objectType") String string) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /objectTypes/", string}));
        }
        ObjectTypeSpec objectTypeSpec = this._ObjectTypesManager.getObjectTypeSpec(string);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /objectTypes/", string}));
        }
        return objectTypeSpec;
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public Map<String, ObjectTypeSpec> getObjectTypeSpecs() {
        _logger.debug((Object)"GET /objectsTypes/");
        Map<String, ObjectTypeSpec> map = this._ObjectTypesManager.getAllObjectTypeSpecs();
        _logger.trace((Object)"Finish execution of GET /objectsTypes/");
        return map;
    }
}

