/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.model.QuickSearchResult;
import com.vmware.vise.mvc.search.model.SearchTypeData;
import com.vmware.vise.util.StringUtil;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"}, method={RequestMethod.GET})
public class SearchController {
    private static final Log _logger = LogFactory.getLog(SearchController.class);
    private final SearchManager _searchManager;

    @Autowired
    public SearchController(SearchManager searchManager) {
        this._searchManager = searchManager;
    }

    @RequestMapping(value={"/quicksearch"})
    @ResponseBody
    public List<QuickSearchResult> getQuickSearchResults(@RequestParam(value="query") String string, @RequestParam(value="opId") String string2) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /search/quicksearch for ", string, " with opId: ", string2}));
        }
        string = string.trim();
        List<QuickSearchResult> list = this._searchManager.getQuickSearchResults(string, string2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /search/quicksearch for ", string, " with opId: ", string2}));
        }
        return list;
    }

    @RequestMapping(value={"/simplesearch/summary"})
    @ResponseBody
    public List<SearchTypeData> getAllQuickSearchResults(@RequestParam(value="query") String string, @RequestParam(value="opId") String string2) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /search/simplesearch/summary/ for ", string, " with opId: ", string2}));
        }
        string = string.trim();
        List<SearchTypeData> list = this._searchManager.getSimpleSearchResults(string, string2);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /search/simplesearch/summary/ for ", string, " with opId: ", string2}));
        }
        return list;
    }
}

