/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.tasks.TaskQueryUtil;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.common.error.ErrorReportArgs;
import com.vmware.vsphere.client.common.error.ErrorReportService;
import com.vmware.vsphere.client.common.error.ErrorStack;
import com.vmware.vsphere.client.security.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tasks"})
public class TasksController {
    private static final Log _logger = LogFactory.getLog(TasksController.class);
    public static final String ALL = "all";
    public static final String RUNNING = "running";
    public static final String FAILED = "failed";
    private final String _opId = "h5c-" + this.getClass().getSimpleName();
    private final int MAX_PAGE_SIZE_COUNT = 100;
    private final DataService _dataService;
    private final ObjectTypesManager _objectTypesManager;
    private final ObjectReferenceService _objectReferenceService;
    private final QueryExecutor _queryExecutor;
    private final ErrorReportService _errorReportService;
    private static Comparator<ClientTaskInfo> startTimeComparator = new Comparator<ClientTaskInfo>(){

        @Override
        public int compare(ClientTaskInfo clientTaskInfo, ClientTaskInfo clientTaskInfo2) {
            return clientTaskInfo2.queueTime.compareTo(clientTaskInfo.queueTime);
        }
    };

    @Autowired
    public TasksController(DataService dataService, ObjectTypesManager objectTypesManager, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, QueryExecutor queryExecutor, ErrorReportService errorReportService) {
        this._dataService = dataService;
        this._objectTypesManager = objectTypesManager;
        this._objectReferenceService = objectReferenceService;
        this._queryExecutor = queryExecutor;
        this._errorReportService = errorReportService;
    }

    @RequestMapping(value={"/recenttasks"})
    @ResponseBody
    public ClientTaskInfo[] getRecentTasks(@RequestParam(value="taskState", defaultValue="all") String string, @RequestParam(value="startedByLoggedInUserOnly", defaultValue="true") boolean bl) throws Exception {
        UserSession userSession;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /tasks/recenttasks for ", string, " startedByLoggedInUserOnly = ", bl}));
        }
        String string2 = null;
        if (bl) {
            userSession = Util.getUserSession();
            if (userSession == null) {
                throw new IllegalStateException("User is not logged in.");
            }
            string2 = userSession.userName;
        }
        userSession = TaskQueryUtil.createTaskQuerySpec(null, false, true, null, string2, -1, 0);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[1];
        requestSpec.querySpec[0] = userSession;
        userSession.name = this._opId;
        Response response = this._dataService.getData(requestSpec);
        ClientTaskInfo[] clientTaskInfoArray = this.filterTasksBasedOnState(response, string);
        Arrays.sort(clientTaskInfoArray, startTimeComparator);
        this.process(clientTaskInfoArray);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /tasks/recenttasks for ", string, " startedByLoggedInUserOnly = ", bl}));
        }
        return clientTaskInfoArray;
    }

    @RequestMapping(value={"/"})
    @ResponseBody
    public List<ClientTaskInfo> getTasks(@RequestParam(value="objectId", required=false) String string, @RequestParam(value="pageSize", defaultValue="-1") int n, @RequestParam(value="requestedPage", defaultValue="0") int n2, @RequestParam(value="requestingPrevPage", defaultValue="false") boolean bl) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /tasks/ for ", string, " requestedPage = ", n2, " requestingPrevPage = ", bl}));
        }
        Object object = null;
        if (string != null) {
            object = this._objectReferenceService.getReference(string, true);
        }
        if (n > 100) {
            _logger.warn((Object)("Reducing the pageSize task count from " + n + " to " + 100));
            n = 100;
        }
        QuerySpec querySpec = TaskQueryUtil.createTaskQuerySpec(object, false, false, null, null, n, n2);
        querySpec.resultSpec.maxResultCount = n;
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        if (resultSet == null) {
            return null;
        }
        List<ClientTaskInfo> list = this.formatResults(resultSet);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /tasks/ for ", string, " requestedPage = ", n2, " requestingPrevPage = ", bl}));
        }
        return list;
    }

    @RequestMapping(value={"/errorStack"})
    @ResponseBody
    public List<String> getErrorStack(@RequestParam(value="eventId", required=false) String string, @RequestParam(value="taskId", required=false) String string2, @RequestParam(value="parentTaskId", required=false) String string3, @RequestParam(value="serverGuid", required=true) String string4) throws Exception {
        _logger.info((Object)"GET /tasks/errorStack");
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /tasks/errorStack for ", string, " taskId = ", string2, " parentTaskId = ", string3, " serverGuid = ", string4}));
        }
        ErrorReportArgs errorReportArgs = new ErrorReportArgs();
        errorReportArgs.eventId = string;
        errorReportArgs.taskId = string2;
        errorReportArgs.parentTaskId = string3;
        errorReportArgs.serverGuid = string4;
        ErrorStack errorStack = this._errorReportService.getErrorStack(errorReportArgs);
        LinkedList<String> linkedList = new LinkedList<String>();
        this.addErrorStackMessages(linkedList, errorStack);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /tasks/errorStack for ", string, " taskId = ", string2, " parentTaskId = ", string3, " serverGuid = ", string4}));
        }
        return linkedList;
    }

    private void addErrorStackMessages(List<String> list, ErrorStack errorStack) {
        if (errorStack != null) {
            if (!StringUtil.isNullOrEmpty((String)errorStack.message)) {
                list.add(errorStack.message);
            }
            if (errorStack.messages != null) {
                for (LocalizableMessage localizableMessage : errorStack.messages) {
                    list.add(localizableMessage.getMessage());
                }
            }
            if (errorStack.cause != null) {
                for (LocalizableMessage localizableMessage : errorStack.cause) {
                    this.addErrorStackMessages(list, (ErrorStack)localizableMessage);
                }
            }
        }
    }

    private List<ClientTaskInfo> formatResults(ResultSet resultSet) {
        ArrayList<ClientTaskInfo> arrayList = new ArrayList<ClientTaskInfo>();
        for (ResultItem resultItem : resultSet.items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                if (!propertyValue.propertyName.equals("info")) continue;
                arrayList.add((ClientTaskInfo)propertyValue.value);
            }
        }
        return arrayList;
    }

    private void process(ClientTaskInfo[] clientTaskInfoArray) {
        for (ClientTaskInfo clientTaskInfo : clientTaskInfoArray) {
            ObjectTypeSpec objectTypeSpec = this._objectTypesManager.getObjectTypeSpec(clientTaskInfo.entityType);
            if (objectTypeSpec != null) {
                clientTaskInfo.entityIconId = objectTypeSpec.icon;
            }
            if (clientTaskInfo.progress == -1 && clientTaskInfo.state.equals((Object)TaskState.SUCCESS)) {
                clientTaskInfo.progress = 100;
            }
            if (clientTaskInfo.taskRef != null) {
                clientTaskInfo.taskUid = this._objectReferenceService.getUid(clientTaskInfo.taskRef);
            }
            if (clientTaskInfo.entity != null) {
                clientTaskInfo.entityUid = this._objectReferenceService.getUid(clientTaskInfo.entity);
            }
            if (clientTaskInfo.result == null) continue;
            clientTaskInfo.resultEntityUid = this._objectReferenceService.getUid(clientTaskInfo.result);
        }
    }

    private ClientTaskInfo[] filterTasksBasedOnState(Response response, String string) throws Exception {
        if (response == null || response.resultSet == null || response.resultSet.length == 0) {
            return new ClientTaskInfo[0];
        }
        ArrayList<ClientTaskInfo> arrayList = new ArrayList<ClientTaskInfo>();
        for (ResultItem resultItem : response.resultSet[0].items) {
            if (resultItem.properties.length <= 0 || resultItem.properties[0].propertyName != "info" || !(resultItem.properties[0].value instanceof ClientTaskInfo)) continue;
            ClientTaskInfo clientTaskInfo = (ClientTaskInfo)resultItem.properties[0].value;
            if (string.equals(ALL)) {
                arrayList.add(clientTaskInfo);
            }
            if (string.equals(RUNNING) && (clientTaskInfo.state == TaskState.QUEUED || clientTaskInfo.state == TaskState.RUNNING)) {
                arrayList.add(clientTaskInfo);
            }
            if (!string.equals(FAILED) || clientTaskInfo.state != TaskState.ERROR) continue;
            arrayList.add(clientTaskInfo);
        }
        return arrayList.toArray(new ClientTaskInfo[arrayList.size()]);
    }
}

