/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeItem;
import com.vmware.vise.mvc.tree.TreePath;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/tree"})
public class TreeController {
    private static final Log _logger = LogFactory.getLog(TreeController.class);
    private final TreeManager _treeManager;

    @Autowired
    public TreeController(TreeManager treeManager) {
        this._treeManager = treeManager;
    }

    @ResponseBody
    @RequestMapping(value={"/root"})
    public List<TreeNodeItem> getRoot(@RequestParam(value="treeId") String string, @RequestParam(value="objRef", required=false) String string2) {
        _logger.debug((Object)"GET /tree/root");
        List<TreeNodeItem> list = this._treeManager.getRoot(string, string2);
        _logger.trace((Object)"Finish execution of GET /tree/root");
        return list;
    }

    @RequestMapping(value={"/children"})
    @ResponseBody
    public List<TreeNodeItem> getChildren(@RequestParam(value="treeId") String string, @RequestParam(value="nodeTypeId") String string2, @RequestParam(value="objRef") String string3) {
        _logger.debug((Object)"GET /tree/children");
        List<TreeNodeItem> list = this._treeManager.getChildren(string, string2, string3);
        _logger.trace((Object)"Finish execution of GET /tree/children");
        return list;
    }

    @RequestMapping(value={"/childrenByObjectIds"}, method={RequestMethod.POST})
    public Map<String, List<TreeNodeItem>> getChildrenByObjectIds(@RequestBody Map<String, Object> map) throws Exception {
        List list;
        String string;
        _logger.debug((Object)"POST /tree/childrenByObjectIds");
        try {
            string = (String)map.get("treeId");
            list = (List)map.get("parents");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Wrong layout for treeId or parents.");
        }
        if (string == null || list == null) {
            throw new IllegalArgumentException("Missing treeId or parents.");
        }
        HashMap<String, List<TreeNodeItem>> hashMap = new HashMap<String, List<TreeNodeItem>>(list.size());
        for (Map map2 : list) {
            String string2 = (String)map2.get("nodeTypeId");
            String string3 = (String)map2.get("objRef");
            if (string2 == null || string3 == null) {
                throw new IllegalArgumentException("All parents must have nodeTypeId and objRef.");
            }
            hashMap.put(string3, this._treeManager.getChildren(string, string2, string3));
        }
        _logger.trace((Object)"Finish execution of POST /tree/childrenByObjectIds");
        return hashMap;
    }

    @RequestMapping(value={"/path"})
    @ResponseBody
    public TreePath getPath(@RequestParam(value="treeId") String string, @RequestParam(value="rootRef", required=false) String string2, @RequestParam(value="objRef") String string3, @RequestParam(value="options", required=false) String string4) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /tree/path for ", string, " rootRef = ", string2, " objRef = ", string3}));
        }
        _logger.debug((Object)"GET /tree/path");
        TreePath treePath = this._treeManager.getPath(string, string2, string3, string4);
        _logger.trace((Object)"Finish execution of GET /tree/path");
        return treePath;
    }

    @RequestMapping(value={"/propertiesByObjectIds"}, method={RequestMethod.POST})
    public Map<String, Map<String, Object>> getPropertiesByObjectIds(@RequestBody Map<String, ArrayList<String>> map) throws Exception {
        _logger.debug((Object)"POST /tree/propertiesByObjectIds");
        List list = map.get("objectIds");
        if (list == null) {
            throw new IllegalArgumentException("ObjectIds are required.");
        }
        Map<String, Map<String, Object>> map2 = this._treeManager.getPropertiesByObjectIds(list);
        _logger.trace((Object)"Finish execution of POST /tree/propertiesByObjectIds");
        return map2;
    }

    @RequestMapping(value={"/supportedTypes"})
    @ResponseBody
    public List<String> getSupportedTypes(@RequestParam(value="treeId") String string) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /tree/supportedTypes for ", string}));
        }
        List<String> list = this._treeManager.getSupportedTypes(string);
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /tree/supportedTypes for ", string}));
        }
        return list;
    }
}

