/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.google.common.collect.ImmutableMap;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vsphere.client.usersession.UserSessionInfo;
import com.vmware.vsphere.client.usersession.UserSessionServerInfo;
import com.vmware.vsphere.client.usersession.UserSessionServiceInternal;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/usersession"}, method={RequestMethod.GET})
public class UserSessionController {
    private final AtomicReference<UserSessionServiceInternal> _userSessionServiceRef = new AtomicReference();
    private final ServiceRegistry _serviceRegistry;
    private static final Log _logger = LogFactory.getLog(UserSessionController.class);
    private static final Map<String, String> SERVER_ERROR_MESSAGES = ImmutableMap.of((Object)"connectError", (Object)"error.peerVcConnectionError", (Object)"sslError", (Object)"error.vcSslError", (Object)"sspiError", (Object)"error.vcSspiError", (Object)"invalidCredentials", (Object)"error.vcInvalidCredentials", (Object)"compatibilityError", (Object)"error.incompatibleVcs");

    @Autowired
    public UserSessionController(ServiceRegistry serviceRegistry) {
        this._serviceRegistry = serviceRegistry;
    }

    @RequestMapping
    @ResponseBody
    public UserSessionInfo getUserSessionInfo() {
        _logger.debug((Object)"GET /usersession");
        UserSessionInfo userSessionInfo = this.getUserSessionInfoInternal();
        _logger.trace((Object)"Finish execution of GET /usersession");
        return userSessionInfo;
    }

    @RequestMapping(value={"/ping"})
    @ResponseBody
    public void ping() {
        _logger.debug((Object)"GET /usersession/ping");
        UserSessionServiceInternal userSessionServiceInternal = this.getUserSessionService();
        if (userSessionServiceInternal != null) {
            userSessionServiceInternal.ping();
        } else {
            _logger.warn((Object)"No-op on ping operation, since userSessionService is un-available.");
        }
        _logger.trace((Object)"Finish execution of GET /usersession/ping");
    }

    @RequestMapping(value={"/serverInfo"})
    @ResponseBody
    public UserSessionServerInfo getUserSessionServerInfo() {
        UserSessionServiceInternal userSessionServiceInternal = this.getUserSessionService();
        return userSessionServiceInternal.getUserSessionServerInfo();
    }

    @RequestMapping(value={"/userSessionServerErrors"})
    @ResponseBody
    public String[] getUserSessionErrors() {
        UserSessionServiceInternal userSessionServiceInternal = this.getUserSessionService();
        UserSessionServerInfo userSessionServerInfo = userSessionServiceInternal.getUserSessionServerInfo();
        if (userSessionServerInfo == null) {
            _logger.error((Object)"Error when getting user sesion info. The user session does not exists or the user has been logged out.");
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ServerInfo serverInfo : userSessionServerInfo.serversInfo) {
            if (!(serverInfo instanceof ServerInfoEx)) continue;
            ServerInfoEx serverInfoEx = (ServerInfoEx)serverInfo;
            String string = serverInfoEx.errorCode;
            String string2 = SERVER_ERROR_MESSAGES.get(string);
            if (string2 == null) continue;
            arrayList.add(CommonUtils.text(string2, serverInfoEx.serviceUrl));
        }
        return arrayList.toArray(new String[0]);
    }

    private UserSessionInfo getUserSessionInfoInternal() {
        UserSessionServiceInternal userSessionServiceInternal = this.getUserSessionService();
        return userSessionServiceInternal.getUserSessionInfo();
    }

    private UserSessionServiceInternal getUserSessionService() {
        UserSessionServiceInternal userSessionServiceInternal = this._userSessionServiceRef.get();
        if (userSessionServiceInternal == null) {
            UserSessionServiceInternal userSessionServiceInternal2 = null;
            try {
                userSessionServiceInternal2 = (UserSessionServiceInternal)this._serviceRegistry.getService(UserSessionServiceInternal.class.getName());
            }
            catch (Exception exception) {
                _logger.error((Object)("Error when getting service of UserSessionService interface" + exception.getMessage()));
                return null;
            }
            boolean bl = this._userSessionServiceRef.compareAndSet(null, userSessionServiceInternal2);
            if (bl) {
                Assert.notNull((Object)userSessionServiceInternal2, (String)"UserSessionService should not be null from the service registry");
                return userSessionServiceInternal2;
            }
            userSessionServiceInternal = this._userSessionServiceRef.get();
        }
        Assert.notNull((Object)userSessionServiceInternal, (String)"UserSessionService should not be null");
        return userSessionServiceInternal;
    }
}

