/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.controllers;

import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.usersession.ServerInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.security.Util;
import com.vmware.vsphere.client.usersession.CloneSessionInfo;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/usersessionex"}, method={RequestMethod.GET})
public class UserSessionInternalController {
    private static final Log _logger = LogFactory.getLog(UserSessionInternalController.class);
    private boolean internalUser = false;
    private String hostName = null;

    @RequestMapping(value={"/acquireCloneTicket/{serverGuid}"})
    @ResponseBody
    public CloneSessionInfo acquireCloneTicket(@PathVariable(value="serverGuid") String string) throws Exception {
        String string2;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)StringUtil.appendStrings((Object[])new Object[]{"GET /usersessionex/acquireCloneTicket/", string}));
        }
        if (StringUtil.isNullOrEmpty((String)(string2 = (String)SessionUtil.getData((String)"USER_NAME")))) {
            _logger.error((Object)"acquireCloneTicket called on an inactive session.");
            MixedUtil.throwNotAuthenticatedError(null);
        }
        VcService vcService = VimSessionUtil.getService((String)string);
        ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().sessionManager;
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        String string3 = sessionManager.acquireCloneTicket();
        CloneSessionInfo cloneSessionInfo = new CloneSessionInfo();
        ServerInfoEx serverInfoEx = Util.toServerInfo((VcService)vcService);
        cloneSessionInfo.setServerInfo((ServerInfo)serverInfoEx);
        cloneSessionInfo.setSessionTicket(string3);
        cloneSessionInfo.setUserName(string2);
        Locale locale = ResourceUtil.getLocale();
        if (locale != null) {
            cloneSessionInfo.setLocale(locale.toString());
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /usersessionex/acquireCloneTicket/", string}));
        }
        return cloneSessionInfo;
    }

    @RequestMapping(value={"/internalinfo"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getInternalInfo() {
        _logger.debug((Object)"GET /usersessionex/internalinfo");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isInternal", String.valueOf(this.internalUser));
        if (this.hostName != null) {
            hashMap.put("hostName", this.hostName);
        }
        _logger.trace((Object)"Finish execution of GET /usersessionex/internalinfo");
        return hashMap;
    }
}

