/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.events;

import com.vmware.vim.binding.vim.event.AlarmEventArgument;
import com.vmware.vim.binding.vim.event.ComputeResourceEventArgument;
import com.vmware.vim.binding.vim.event.DatacenterEventArgument;
import com.vmware.vim.binding.vim.event.DatastoreEventArgument;
import com.vmware.vim.binding.vim.event.DvsEventArgument;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.HostEventArgument;
import com.vmware.vim.binding.vim.event.ManagedEntityEventArgument;
import com.vmware.vim.binding.vim.event.NetworkEventArgument;
import com.vmware.vim.binding.vim.event.ResourcePoolEventArgument;
import com.vmware.vim.binding.vim.event.VmEventArgument;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.core.model.event.ClientEventEntityInfo;
import com.vmware.vise.core.model.event.ClientEventInfo;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkableEntityParser {
    public Map<String, ClientEventEntityInfo> getLinkableEntities(ClientEventInfo clientEventInfo) {
        HashMap<String, ClientEventEntityInfo> hashMap = new HashMap<String, ClientEventEntityInfo>();
        Pattern pattern = Pattern.compile("\\{[^{}]+\\}");
        Matcher matcher = pattern.matcher(clientEventInfo.linkableFormattedMessage);
        while (matcher.find()) {
            String string = matcher.group().substring(matcher.group().indexOf("{") + 1, matcher.group().indexOf("}"));
            hashMap.put(string, this.getClientEventEntityOf(string, clientEventInfo.serverEvent));
        }
        return hashMap;
    }

    private ClientEventEntityInfo getClientEventEntityOf(String string, Object object) {
        Object object2;
        String[] stringArray = string.split("\\.");
        if (object instanceof EventEx) {
            object2 = (EventEx)object;
            if (object2.arguments != null) {
                for (KeyAnyValue keyAnyValue : object2.arguments) {
                    if (!keyAnyValue.getKey().equals(string)) continue;
                    return this.buildClientEventEntityInfoByEventArgument(keyAnyValue.getValue());
                }
            } else {
                return null;
            }
        }
        object2 = this.getEntityEventArgumentOf(stringArray[0], object);
        return this.buildClientEventEntityInfoByEventArgument(object2);
    }

    private ClientEventEntityInfo buildClientEventEntityInfoByEventArgument(Object object) {
        ClientEventEntityInfo clientEventEntityInfo = null;
        if (object instanceof ComputeResourceEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((ComputeResourceEventArgument)object);
        } else if (object instanceof DatacenterEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((DatacenterEventArgument)object);
        } else if (object instanceof DatastoreEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((DatastoreEventArgument)object);
        } else if (object instanceof DvsEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((DvsEventArgument)object);
        } else if (object instanceof HostEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((HostEventArgument)object);
        } else if (object instanceof NetworkEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((NetworkEventArgument)object);
        } else if (object instanceof VmEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((VmEventArgument)object);
        } else if (object instanceof ManagedEntityEventArgument) {
            ManagedEntityEventArgument managedEntityEventArgument = (ManagedEntityEventArgument)object;
            clientEventEntityInfo = new ClientEventEntityInfo(managedEntityEventArgument);
        } else if (object instanceof AlarmEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((AlarmEventArgument)object);
        } else if (object instanceof ResourcePoolEventArgument) {
            clientEventEntityInfo = new ClientEventEntityInfo((ResourcePoolEventArgument)object);
        }
        return clientEventEntityInfo;
    }

    private Object getEntityEventArgumentOf(String string, Object object) {
        return this.findFieldFromObjectHierarchy(string, object);
    }

    private Object findFieldFromObjectHierarchy(String string, Object object) {
        Class<?> clazz = object.getClass();
        while (true) {
            try {
                Field field = clazz.getDeclaredField(string);
                return field.get(object);
            }
            catch (Exception exception) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }
}

