/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.exception;

import com.vmware.vise.data.query.DataException;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final String ERROR_STACK_TRACE_FLAG = "error.stackTrace.show";
    private static final Log _logger = LogFactory.getLog(GlobalExceptionHandler.class);
    private ConfigurationService _configurationService;

    @Autowired
    void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    @ExceptionHandler
    @ResponseStatus
    @ResponseBody
    public Map<String, Object> handleException(Exception exception) {
        Object object;
        Object object2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message", exception.getMessage());
        if (exception.getCause() != null) {
            object2 = exception.getCause();
            if (((Throwable)object2).getCause() != null) {
                object2 = ((Throwable)object2).getCause();
            }
            hashMap.put("cause", ((Throwable)object2).toString());
        }
        if (((String[])(object2 = ExceptionUtils.getRootCauseStackTrace((Throwable)exception))).length > 0) {
            _logger.error((Object)"Exception handled: ", (Throwable)exception);
            object = this._configurationService.getProperty(ERROR_STACK_TRACE_FLAG);
            if (Boolean.parseBoolean((String)object)) {
                StringBuilder stringBuilder = new StringBuilder((String)object2[0]);
                for (int i = 1; i < ((Object)object2).length; ++i) {
                    stringBuilder.append('\n');
                    stringBuilder.append((String)object2[i]);
                }
                hashMap.put("stackTrace", stringBuilder.toString());
            }
        }
        if (exception instanceof DataException) {
            object = (DataException)exception;
            if (!ArrayUtil.isNullOrEmpty((Object[])object.objects)) {
                hashMap.put("de_objects", object.objects);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])object.properties)) {
                hashMap.put("de_properties", object.properties);
            }
        }
        return hashMap;
    }
}

