/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CapabilityFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(CapabilityFilter.class);
    static final String CAPABILITY = "capability";
    static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String CAPABILITY_PREFIX = "capability.";
    private static final String NEGATION = "!";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;

    public CapabilityFilter(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        this._queryService = queryServiceFactory.getQueryService();
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = CAPABILITY;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = CONTEXT_OBJECTS;
        propertyInfo2.type = Object[].class.getName();
        propertyInfo2.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo2};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        ResultSet resultSet;
        if (map == null) {
            return list;
        }
        Set<String> set = this.getServerGuids(map);
        if (set.size() == 0) {
            return list;
        }
        Object[] objectArray = CapabilityFilter.getRequestedCapabilites(list);
        Map<String, Boolean> map2 = new HashMap<String, Boolean>();
        if (!ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            try {
                resultSet = this._queryService.select((String[])objectArray).from(new String[]{ServiceInstance.class.getSimpleName()}).where("@instanceUuid", PropertyPredicate.ComparisonOperator.IN, set).fetch();
                map2 = CapabilityFilter.extractCapabilityValues((String[])objectArray, resultSet.getItems());
            }
            catch (Exception exception) {
                _logger.error((Object)"Error when doing filter based on capability: ", (Throwable)exception);
                return list;
            }
        }
        resultSet = CapabilityFilter.filterExtensionsByCapability(list, map2);
        return resultSet;
    }

    private Set<String> getServerGuids(Map<String, Object> map) {
        Object object = map.get(CONTEXT_OBJECTS);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object2 : objectArray) {
            String string = this._objRefService.getServerGuid(object2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private static Map<String, Boolean> extractCapabilityValues(String[] stringArray, List<ResourceItem> list) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (!CollectionUtil.isNullOrEmpty(list)) {
            for (ResourceItem resourceItem : list) {
                for (String string : stringArray) {
                    boolean bl = true;
                    if (hashMap.containsKey(string)) {
                        bl = (Boolean)hashMap.get(string);
                    }
                    Object object = resourceItem.get(string);
                    hashMap.put(string, bl &= Boolean.TRUE.equals(object));
                }
            }
        } else {
            for (String string : stringArray) {
                hashMap.put(string, true);
            }
        }
        return hashMap;
    }

    private static String[] getRequestedCapabilites(List<ExtensionInfo> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ExtensionInfo extensionInfo : list) {
            String string = (String)extensionInfo.getMetadata().get(CAPABILITY);
            if (StringUtil.isNullOrEmpty((String)string)) {
                _logger.error((Object)("Invalid metadata for extension info: " + extensionInfo.getId()));
                continue;
            }
            string = StringUtils.stripStart((String)string, (String)NEGATION);
            String string2 = CAPABILITY_PREFIX + string;
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[0]);
    }

    private static List<ExtensionInfo> filterExtensionsByCapability(List<ExtensionInfo> list, Map<String, Boolean> map) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            String string = (String)extensionInfo.getMetadata().get(CAPABILITY);
            if (string == null) {
                _logger.error((Object)("Invalid metadata for extension info: " + extensionInfo.getId()));
                continue;
            }
            boolean bl = string.startsWith(NEGATION);
            string = StringUtils.stripStart((String)string, (String)NEGATION);
            String string2 = CAPABILITY_PREFIX + string;
            boolean bl2 = Boolean.TRUE.equals(map.get(string2));
            if (!(bl ^ bl2)) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }
}

