/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionHostFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(ExtensionHostFilter.class);
    private static final String REQUIRES_HOSTED_EXTENSIONS = "requiresHostedExtensions";
    private final PropertyInfo[] _filterProperties;
    private ExtensionService _extensionService;

    public ExtensionHostFilter(ExtensionService extensionService) {
        this._extensionService = extensionService;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = REQUIRES_HOSTED_EXTENSIONS;
        propertyInfo.type = Boolean.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        block0: for (ExtensionInfo extensionInfo : list) {
            Boolean bl = (Boolean)extensionInfo.getMetadata().get(REQUIRES_HOSTED_EXTENSIONS);
            if (bl == null || !bl.booleanValue()) {
                arrayList.add(extensionInfo);
                continue;
            }
            Object[] objectArray = extensionInfo.getHostedPointsIds();
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                _logger.error((Object)("ExtensionHostFilter: Extension with id '" + extensionInfo.getId() + "' should specify at least 1 hostedPoint."));
                continue;
            }
            for (Object object : objectArray) {
                List list2 = this._extensionService.getExtensionObjects((String)object, map, false);
                if (list2 == null || list2.isEmpty()) continue;
                arrayList.add(extensionInfo);
                continue block0;
            }
        }
        return arrayList;
    }
}

