/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderTypeFilter
implements ExtensionObjectFilter {
    private static final String FOLDER_TYPE = "folderType";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String DC_FOLDER_TYPE = "DatacenterFolder";
    private static final String VM_FOLDER_TYPE = "VirtualMachineFolder";
    private static final String DS_FOLDER_TYPE = "DatastoreFolder";
    private static final String HOST_FOLDER_TYPE = "HostFolder";
    private static final String NETWORK_FOLDER_TYPE = "NetworkFolder";
    private static final String ROOT_FOLDER = "RootFolder";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;

    public FolderTypeFilter() {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = FOLDER_TYPE;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = CONTEXT_OBJECTS;
        propertyInfo2.type = Object[].class.getName();
        propertyInfo2.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo2};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        Object[] objectArray = this.getContextObjects(map);
        if (objectArray.length != 1) {
            return list;
        }
        Object object = objectArray[0];
        if (!(object instanceof ManagedObjectReference)) {
            return list;
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            String string = (String)extensionInfo.getMetadata().get(FOLDER_TYPE);
            if (StringUtil.isNullOrWhitespace((String)string) || !(string = string.trim()).equalsIgnoreCase(this.getFolderType(managedObjectReference))) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private Object[] getContextObjects(Map<String, Object> map) {
        if (map == null) {
            return new Object[0];
        }
        Object object = map.get(CONTEXT_OBJECTS);
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return objectArray;
    }

    private String getFolderType(ManagedObjectReference managedObjectReference) {
        if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
            return ROOT_FOLDER;
        }
        if (ManagedObjectUtil.isDatacenterFolder((ManagedObjectReference)managedObjectReference)) {
            return DC_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isStorageFolder((ManagedObjectReference)managedObjectReference)) {
            return DS_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)managedObjectReference)) {
            return VM_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isHostFolder((ManagedObjectReference)managedObjectReference)) {
            return HOST_FOLDER_TYPE;
        }
        if (ManagedObjectUtil.isNetworkFolder((ManagedObjectReference)managedObjectReference)) {
            return NETWORK_FOLDER_TYPE;
        }
        return "";
    }
}

