/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class GlobalPrivilegeFilter
implements ExtensionObjectFilter {
    private static final String GLOBAL_FILTER_METADATA_TAG = "globalPrivileges";
    private static final String GRANTED_PRIVILEGES_PROP = "grantedPrivileges";
    private static final String GLOBAL_OBJECT = "urn:vri:acl:RootPermissionNode:root";
    private static final String PRECLUSION_SIGN = "!";
    private static final String CACHED_GLOBAL_PRIVILEGES = "cachedGlobalPrivileges";
    private final PropertyInfo[] _filterProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objectReferenceService;

    @Autowired
    public GlobalPrivilegeFilter(QueryServiceFactory queryServiceFactory, ObjectReferenceService objectReferenceService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{queryServiceFactory, objectReferenceService});
        this._queryService = queryServiceFactory.getQueryService();
        this._objectReferenceService = objectReferenceService;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = GLOBAL_FILTER_METADATA_TAG;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        if (!this.isPrivilegeCheckNeeded(list)) {
            return list;
        }
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        Set<String> set = null;
        ConcurrentMap<String, Boolean> concurrentMap = this.getSessionCache();
        if (concurrentMap == null) {
            concurrentMap = this.createSessionCache();
            set = this.getPrivileges();
        }
        for (ExtensionInfo extensionInfo : list) {
            String[] stringArray = ((String)extensionInfo.getMetadata().get(GLOBAL_FILTER_METADATA_TAG)).split(",");
            this.updateCachedPrivileges(concurrentMap, stringArray, set);
            if (!this.hasAllPrivileges(concurrentMap, stringArray)) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private void updateCachedPrivileges(ConcurrentMap<String, Boolean> concurrentMap, String[] stringArray, @Nullable Set<String> set) {
        Set<String> set2 = set;
        for (String string : stringArray) {
            String string2 = this.escape(string);
            Boolean bl = (Boolean)concurrentMap.get(string2);
            if (bl != null) continue;
            if (set2 == null) {
                set2 = this.getPrivileges();
            }
            concurrentMap.putIfAbsent(string2, set2.contains(string2));
        }
    }

    private boolean hasAllPrivileges(ConcurrentMap<String, Boolean> concurrentMap, String[] stringArray) {
        for (String string : stringArray) {
            boolean bl = this.isPrecluded(string);
            String string2 = this.escape(string);
            Boolean bl2 = (Boolean)concurrentMap.get(string2);
            if (bl2 == null) {
                return false;
            }
            if (bl) {
                bl2 = bl2 == false;
            }
            if (bl2.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private Set<String> getPrivileges() {
        Object object = this._objectReferenceService.getReference(GLOBAL_OBJECT, true);
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>();
        arrayList.add(new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Collections.singletonList(object)));
        String[] stringArray = new String[]{this._objectReferenceService.getResourceObjectType(object)};
        String[] stringArray2 = new String[]{GRANTED_PRIVILEGES_PROP};
        ResultSet resultSet = this._queryService.select(stringArray2).from(stringArray).where(LogicalOperator.AND, arrayList).fetch();
        String[] stringArray3 = (String[])((ResourceItem)resultSet.getItems().get(0)).get(GRANTED_PRIVILEGES_PROP);
        HashSet<String> hashSet = new HashSet<String>();
        if (stringArray3 != null) {
            Collections.addAll(hashSet, stringArray3);
        }
        return hashSet;
    }

    private boolean isPrivilegeCheckNeeded(List<ExtensionInfo> list) {
        for (ExtensionInfo extensionInfo : list) {
            if (extensionInfo.getMetadata() == null || StringUtil.isNullOrEmpty((String)((String)extensionInfo.getMetadata().get(GLOBAL_FILTER_METADATA_TAG)))) continue;
            return true;
        }
        return false;
    }

    private boolean isPrecluded(String string) {
        return string.startsWith(PRECLUSION_SIGN);
    }

    private String escape(String string) {
        return this.isPrecluded(string) ? string.trim().substring(1) : string.trim();
    }

    protected ConcurrentMap<String, Boolean> getSessionCache() {
        return (ConcurrentMap)SessionUtil.getData((String)CACHED_GLOBAL_PRIVILEGES);
    }

    protected ConcurrentMap<String, Boolean> createSessionCache() {
        ConcurrentHashMap<String, Boolean> concurrentHashMap = new ConcurrentHashMap<String, Boolean>(4);
        ConcurrentHashMap concurrentHashMap2 = (ConcurrentHashMap)SessionUtil.setDataIfAbsent((String)CACHED_GLOBAL_PRIVILEGES, concurrentHashMap);
        if (concurrentHashMap2 != null) {
            return concurrentHashMap2;
        }
        return concurrentHashMap;
    }
}

