/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultipleTargetsOnlyFilter
implements ExtensionObjectFilter {
    private static final String REQUIRES_MULTIPLE_TARGETS = "requiresMultipleTargets";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;

    public MultipleTargetsOnlyFilter() {
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = REQUIRES_MULTIPLE_TARGETS;
        propertyInfo.type = Boolean.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = CONTEXT_OBJECTS;
        propertyInfo2.type = Object[].class.getName();
        propertyInfo2.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo2};
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        Object[] objectArray = this.getContextObjects(map);
        if (objectArray.length > 1) {
            return list;
        }
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            Boolean bl = (Boolean)extensionInfo.getMetadata().get(REQUIRES_MULTIPLE_TARGETS);
            if (bl != null && bl.booleanValue()) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    private Object[] getContextObjects(Map<String, Object> map) {
        Object object = map.get(CONTEXT_OBJECTS);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return objectArray;
    }
}

