/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrivilegeFilter
implements ExtensionObjectFilter {
    private static final Log _logger = LogFactory.getLog(PrivilegeFilter.class);
    private static final String PRIVILEGE_PROPERTY = "privilege";
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final String PRECLUSION_SIGN = "!";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final QueryService _queryService;
    private final ObjectReferenceService _objRefService;

    public PrivilegeFilter(ObjectReferenceService objectReferenceService, QueryServiceFactory queryServiceFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, queryServiceFactory});
        this._queryService = queryServiceFactory.getQueryService();
        this._objRefService = objectReferenceService;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = PRIVILEGE_PROPERTY;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = CONTEXT_OBJECTS;
        propertyInfo2.type = Object[].class.getName();
        propertyInfo2.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo2};
    }

    public boolean returnsInstantly() {
        return false;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list, map});
        if (!this.isPrivilegeCheckNeeded(list)) {
            return list;
        }
        Object[] objectArray = this.findContextObjects(map);
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray) || objectArray[0] == null) {
            return Collections.emptyList();
        }
        Map<String, List<Object>> map2 = this.groupObjectsByType(objectArray);
        if (map2.isEmpty()) {
            _logger.error((Object)("No type found for a single context object! objects: " + Arrays.toString(objectArray)));
            return list;
        }
        return this.findValidExtensions(list, objectArray, map2);
    }

    protected List<ManagedObjectReference> findRootFolders() {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getLinkedVcGroups()) {
            if (linkedVcGroup == null) continue;
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                ServiceInstanceContent serviceInstanceContent;
                if (vcService == null || (serviceInstanceContent = vcService.getServiceInstanceContent()) == null) continue;
                arrayList.add(serviceInstanceContent.getRootFolder());
            }
        }
        return arrayList;
    }

    private List<ExtensionInfo> findValidExtensions(List<ExtensionInfo> list, Object[] objectArray, Map<String, List<Object>> map) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        Map<Object, List<String>> map2 = this.createPrivilegesByObject(map);
        for (ExtensionInfo extensionInfo : list) {
            if (!this.isExtensionValid(extensionInfo, map2, objectArray)) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private Map<String, List<Object>> groupObjectsByType(Object[] objectArray) {
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        for (Object object : objectArray) {
            String string = this._objRefService.getResourceObjectType(object);
            if (string == null) {
                _logger.error((Object)("Unknown type for reference: " + object));
                continue;
            }
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(object);
        }
        return hashMap;
    }

    private Map<Object, List<String>> createPrivilegesByObject(Map<String, List<Object>> map) {
        HashMap<Object, List<String>> hashMap = new HashMap<Object, List<String>>();
        for (Map.Entry<String, List<Object>> entry : map.entrySet()) {
            ResultSet resultSet = this._queryService.select(new String[]{"grantedPrivileges"}).from(new String[]{entry.getKey()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, entry.getValue()).fetch();
            for (ResourceItem resourceItem : resultSet.getItems()) {
                hashMap.put(resourceItem.getKey(), Arrays.asList((String[])resourceItem.get("grantedPrivileges")));
            }
        }
        return hashMap;
    }

    private boolean isExtensionValid(ExtensionInfo extensionInfo, Map<Object, List<String>> map, Object[] objectArray) {
        if (extensionInfo.getMetadata() == null) {
            return true;
        }
        String string = (String)extensionInfo.getMetadata().get(PRIVILEGE_PROPERTY);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return true;
        }
        for (Object object : objectArray) {
            List<String> list = map.get(object);
            if (list == null) {
                _logger.error((Object)("Null grantedPrivileges for: " + object));
                continue;
            }
            if (this.isPrivilegeGranted(string, list)) continue;
            return false;
        }
        return true;
    }

    private boolean isPrivilegeGranted(String string, List<String> list) {
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (string2.startsWith(PRECLUSION_SIGN)) {
                arrayList.add(string2.substring(1));
                continue;
            }
            arrayList2.add(string2);
        }
        for (String string3 : arrayList) {
            if (list.indexOf(string3) == -1) continue;
            return false;
        }
        for (String string4 : arrayList2) {
            if (list.indexOf(string4) != -1) continue;
            return false;
        }
        return true;
    }

    private boolean isPrivilegeCheckNeeded(List<ExtensionInfo> list) {
        for (ExtensionInfo extensionInfo : list) {
            if (extensionInfo.getMetadata() == null || StringUtil.isNullOrEmpty((String)((String)extensionInfo.getMetadata().get(PRIVILEGE_PROPERTY)))) continue;
            return true;
        }
        return false;
    }

    private Object[] findContextObjects(Map<String, Object> map) {
        Object object = map.get(CONTEXT_OBJECTS);
        if (object == null) {
            return this.findRootFolders().toArray(new Object[0]);
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        return new Object[]{object};
    }
}

