/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vsphere.client.usersession.UserSessionSSODomainInfo;
import com.vmware.vsphere.client.usersession.UserSessionServiceInternal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class SsoGroupsFilter
implements ExtensionObjectFilter {
    private static final String SSO_GROUPS_METADATA_TAG = "requiredSsoGroups";
    private final PropertyInfo[] _filterProperties;
    private final UserSessionServiceInternal _userSessionServiceInternal;

    @Autowired
    public SsoGroupsFilter(UserSessionServiceInternal userSessionServiceInternal) {
        this._userSessionServiceInternal = userSessionServiceInternal;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = SSO_GROUPS_METADATA_TAG;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return null;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        UserSessionSSODomainInfo userSessionSSODomainInfo = this._userSessionServiceInternal.getUserSessionSSODomainInfo();
        String[] stringArray = userSessionSSODomainInfo.groups;
        String[] stringArray2 = userSessionSSODomainInfo.systemDomains;
        for (ExtensionInfo extensionInfo : list) {
            String string = (String)extensionInfo.getMetadata().get(SSO_GROUPS_METADATA_TAG);
            String[] stringArray3 = string.split(",");
            boolean bl = this.isMemberOf(stringArray3, stringArray, stringArray2);
            if (!bl) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private boolean isMemberOf(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        for (String string : stringArray) {
            if ((string = string.trim()) == "") {
                return true;
            }
            for (String string2 : stringArray3) {
                String string3 = string2 + "\\" + string;
                for (String string4 : stringArray2) {
                    if (!string4.equalsIgnoreCase(string3)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

