/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TypeFilter
implements ExtensionObjectFilter {
    private static final String OBJECT_TYPE = "objectType";
    public static final String CONTEXT_OBJECTS = "contextObjects";
    public static final String NO_OBJECT = "NO_OBJECT";
    private final PropertyInfo[] _filterProperties;
    private final PropertyInfo[] _contextProperties;
    private final ObjectReferenceService _objRefService;

    @Autowired
    public TypeFilter(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = OBJECT_TYPE;
        propertyInfo.type = String.class.getName();
        propertyInfo.optional = false;
        this._filterProperties = new PropertyInfo[]{propertyInfo};
        PropertyInfo propertyInfo2 = new PropertyInfo();
        propertyInfo2.name = CONTEXT_OBJECTS;
        propertyInfo2.type = Object[].class.getName();
        propertyInfo2.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo2};
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        if (map == null) {
            return list;
        }
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        Object object = map.get(CONTEXT_OBJECTS);
        Set<String> set = this.getObjectTypes(object);
        for (ExtensionInfo extensionInfo : list) {
            String string = (String)extensionInfo.getMetadata().get(OBJECT_TYPE);
            if (StringUtil.isNullOrEmpty((String)(string = string.trim()))) continue;
            boolean bl = this.isNegatedExpression(string);
            String[] stringArray = this.getEiObjectTypes(string);
            boolean bl2 = true;
            for (String string2 : set) {
                if (this.matchType(string2, stringArray, bl)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return this._filterProperties;
    }

    private Set<String> getObjectTypes(Object object) {
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        for (Object object2 : objectArray) {
            String string = null;
            string = object2 instanceof String && NO_OBJECT.equals(object2) ? NO_OBJECT : this._objRefService.getResourceObjectType(object2);
            hashSet.add(string);
        }
        return hashSet;
    }

    private boolean matchType(String string, String[] stringArray, boolean bl) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            if (!string.equals(string2)) continue;
            bl2 = true;
        }
        if (bl) {
            return !bl2;
        }
        return bl2;
    }

    private String[] splitAndTrim(String string, String string2) {
        String[] stringArray = string.split(string2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    private String[] getEiObjectTypes(String string) {
        String string2 = null;
        string2 = string.startsWith("!(") && string.endsWith(")") ? string.substring(2, string.length() - 1) : string;
        String[] stringArray = this.splitAndTrim(string2, ",");
        return stringArray;
    }

    private boolean isNegatedExpression(String string) {
        return string.startsWith("!(") && string.endsWith(")");
    }
}

