/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.filters;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VSphereObjectViewFilter
implements ExtensionObjectFilter {
    private static final String CONTEXT_OBJECTS = "contextObjects";
    private static final List<String> VSPHERE_OBJECT_VALUES = Arrays.asList(VirtualMachine.class.getSimpleName(), HostSystem.class.getSimpleName(), ClusterComputeResource.class.getSimpleName(), VirtualApp.class.getSimpleName(), ResourcePool.class.getSimpleName(), Folder.class.getSimpleName(), Datacenter.class.getSimpleName(), Datastore.class.getSimpleName(), StoragePod.class.getSimpleName(), Network.class.getSimpleName(), VmwareDistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualSwitch.class.getSimpleName(), DistributedVirtualPortgroup.class.getSimpleName(), "com.vmware.content.Library", "com.vmware.content.library.Item");
    private static final Set<String> VSPHERE_OBJECTS = new HashSet<String>(VSPHERE_OBJECT_VALUES);
    private static final List<String> VALID_PLUGIN_PACKAGES = Arrays.asList("com.vmware.vsphere.client", "com.vmware.vum.client", "com.vmware.__defaultPluginPackage__");
    private static final String VSPHERE_TOP_VIEW_PREFIX = "vsphere.core.";
    private static final String VSPHERE_TOP_VIEW_SUFFIX = ".views";
    private final PropertyInfo[] _contextProperties;
    private final ObjectReferenceService _objRefService;

    public VSphereObjectViewFilter(ObjectReferenceService objectReferenceService) {
        this._objRefService = objectReferenceService;
        PropertyInfo propertyInfo = new PropertyInfo();
        propertyInfo.name = CONTEXT_OBJECTS;
        propertyInfo.type = Object[].class.getName();
        propertyInfo.optional = false;
        this._contextProperties = new PropertyInfo[]{propertyInfo};
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return this._contextProperties;
    }

    public PropertyInfo[] getFilterProperties() {
        return null;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> list, Map<String, Object> map) {
        Object[] objectArray = this.getContextObjects(map);
        if (objectArray.length != 1) {
            return list;
        }
        Object object = objectArray[0];
        String string = this._objRefService.getResourceObjectType(object);
        if (!VSPHERE_OBJECTS.contains(string)) {
            return list;
        }
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : list) {
            String string2;
            if (extensionInfo.getExtendedPointIds() == null) continue;
            boolean bl = false;
            for (String string3 : extensionInfo.getExtendedPointIds()) {
                if (!string3.startsWith(VSPHERE_TOP_VIEW_PREFIX) || !string3.endsWith(VSPHERE_TOP_VIEW_SUFFIX)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(extensionInfo);
                continue;
            }
            Map map2 = extensionInfo.getMetadata();
            Object v = map2.get("pluginPackageId");
            if (!(v instanceof String) || !VALID_PLUGIN_PACKAGES.contains(string2 = (String)v)) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private Object[] getContextObjects(Map<String, Object> map) {
        Object object = map.get(CONTEXT_OBJECTS);
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        return objectArray;
    }
}

