/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.lists.util;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.lists.ColumnDataSourceInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class ListUtil {
    private static final Log _logger = LogFactory.getLog(ListUtil.class);
    public static final String[] DEFAULT_PROPERTIES = new String[]{"name", "primaryIconId", "labelIds"};

    public static String[] getPropertiesToFetch(ExtensionService extensionService, String string) {
        ExtensionInfo extensionInfo = null;
        try {
            extensionInfo = extensionService.getExtensionInfo(string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when fetching extension info for " + string));
            return DEFAULT_PROPERTIES;
        }
        if (extensionInfo == null) {
            return DEFAULT_PROPERTIES;
        }
        if (extensionInfo.getHostedPointsIds().length > 1) {
            throw new IllegalArgumentException("Multiple hosted point ids not supported, extension id: " + string);
        }
        String string2 = extensionInfo.getHostedPointsIds()[0];
        ArrayList arrayList = new ArrayList();
        List list = extensionService.getExtensionObjects(string2, null, false);
        for (ColumnDataSourceInfo columnDataSourceInfo : list) {
            if (columnDataSourceInfo.requestedProperties == null) continue;
            CollectionUtils.mergeArrayIntoCollection((Object)columnDataSourceInfo.requestedProperties, arrayList);
        }
        if (arrayList.size() == 0) {
            return DEFAULT_PROPERTIES;
        }
        return arrayList.toArray(new String[0]);
    }
}

