/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.model;

import com.vmware.vise.extensionfw.PluginPackageInfo;
import java.util.concurrent.ConcurrentMap;

public class Plugin {
    private String id;
    private String version;
    private String name;
    private String vendor;
    private String description;
    private String state;
    private String vmwareCertifiedMessage;

    public Plugin(PluginPackageInfo pluginPackageInfo) {
        this.setId(pluginPackageInfo.getId());
        this.setVersion(pluginPackageInfo.getVersion());
        this.setName(pluginPackageInfo.getName());
        this.setVendor(pluginPackageInfo.getVendor());
        this.setDescription(pluginPackageInfo.getDescription());
        this.setState(this.calculateState(pluginPackageInfo));
    }

    private String calculateState(PluginPackageInfo pluginPackageInfo) {
        ConcurrentMap concurrentMap = pluginPackageInfo.getMetadata();
        if ("incompatible".equals(concurrentMap.get("compatibilityStatus"))) {
            return "incompatible";
        }
        if ("deployedAndDisabled".equals(concurrentMap.get("deploymentStatus"))) {
            return "deployedAndDisabled";
        }
        return "enabled";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getVmwareCertifiedMessage() {
        return this.vmwareCertifiedMessage;
    }

    public void setVmwareCertifiedMessage(String string) {
        this.vmwareCertifiedMessage = string;
    }
}

