/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.model.data;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.core.model.annotation.Dto;
import org.apache.commons.lang.Validate;

@Dto
public class PropertyPredicateSpec {
    private String property;
    private PredicateComparisonOperator operator;
    private Object comparableValue;
    private boolean ignoreCase;

    public PropertyPredicateSpec() {
    }

    public PropertyPredicateSpec(String string, PredicateComparisonOperator predicateComparisonOperator, Object object, boolean bl) {
        Validate.notEmpty((String)string, (String)"Argument `property' must not be null or empty.");
        Validate.notNull((Object)((Object)predicateComparisonOperator), (String)"Argument `operator' must not be null.");
        Validate.notNull((Object)object, (String)"Argument `comparableValue' must not be null.");
        this.property = string;
        this.operator = predicateComparisonOperator;
        this.comparableValue = object;
        this.ignoreCase = bl;
    }

    public String getProperty() {
        return this.property;
    }

    public PredicateComparisonOperator getOperator() {
        return this.operator;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="_type")
    public Object getComparableValue() {
        return this.comparableValue;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public PropertyPredicate buildPropertyPredicateFromSpec() {
        Validate.notEmpty((String)this.property);
        Validate.notNull((Object)((Object)this.operator));
        Validate.notNull((Object)this.comparableValue);
        return new PropertyPredicate(this.property, this.getComparisonOperator(), this.comparableValue, this.ignoreCase);
    }

    private PropertyPredicate.ComparisonOperator getComparisonOperator() {
        return PropertyPredicate.ComparisonOperator.values()[this.operator.ordinal()];
    }

    @Dto
    public static enum PredicateComparisonOperator {
        EQUAL,
        NOT_EQUAL,
        GREATER,
        GREATER_OR_EQUAL,
        LESS,
        LESS_OR_EQUAL,
        IN,
        NOT_IN,
        LIKE,
        UNSET;

    }
}

