/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator;

import com.google.common.base.Throwables;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.impl.Filterer;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.model.CategoryNode;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectNavigatorManagerImpl
implements ObjectNavigatorManager {
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorManagerImpl.class);
    private static final String OBJECT_NAVIGATOR_EXT_POINT = "vise.navigator.nodespecs";
    private final ExtensionService _extensionService;
    private final ServiceRegistry _serviceRegistry;
    private static final int MAX_LEVELS = 2;

    public ObjectNavigatorManagerImpl(ExtensionService extensionService, ServiceRegistry serviceRegistry) {
        this._extensionService = extensionService;
        this._serviceRegistry = serviceRegistry;
    }

    @Override
    public CategoryNode getCategoryNode(String string, List<ObjectNavigatorNodeSpec> list) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getCategoryNode(): nodeId is empty");
            return null;
        }
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec = this.getNodeSpecById(string, list);
        if (objectNavigatorNodeSpec == null) {
            _logger.warn((Object)("getCategoryNode(): ObjectNavigatorSpec not found for nodeId=" + string));
            return null;
        }
        CategoryNode categoryNode = this.transformObjectSpecsToCategoryNode(objectNavigatorNodeSpec);
        this.populateCategoryNode(categoryNode, list);
        return categoryNode;
    }

    @Override
    public CategoryNode getRoot(List<ObjectNavigatorNodeSpec> list) {
        return this.transformObjectSpecsToCategoryNode(this.getRootNode(list));
    }

    @Override
    public ObjectNavigatorNodeSpec getNodeByNavigationTargetUid(String string, List<ObjectNavigatorNodeSpec> list) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getNodeByNavigationTargetUid(): navigationTargetUid is null");
            return null;
        }
        List<ObjectNavigatorNodeSpec> list2 = ObjectNavigatorManagerImpl.sortNodeSpecs(list);
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list2) {
            if (!string.equals(objectNavigatorNodeSpec.navigationTargetUid)) continue;
            return objectNavigatorNodeSpec;
        }
        return null;
    }

    private static List<ObjectNavigatorNodeSpec> sortNodeSpecs(List<ObjectNavigatorNodeSpec> list) {
        LinkedList<ObjectNavigatorNodeSpec> linkedList = new LinkedList<ObjectNavigatorNodeSpec>();
        HashMap<String, ObjectNavigatorNodeSpec> hashMap = new HashMap<String, ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            if (objectNavigatorNodeSpec.parentUid == null) {
                linkedList.add(objectNavigatorNodeSpec);
                continue;
            }
            hashMap.put(objectNavigatorNodeSpec.parentUid, objectNavigatorNodeSpec);
        }
        for (int i = 0; i < hashMap.size(); ++i) {
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec;
            objectNavigatorNodeSpec = (ObjectNavigatorNodeSpec)hashMap.get(linkedList.getFirst().getUid());
            if (objectNavigatorNodeSpec != null) {
                linkedList.addFirst(objectNavigatorNodeSpec);
                continue;
            }
            _logger.error((Object)("Incorrect extension detected for vise.navigator.nodespecs extension point. There are multiple extensions with the same navigationTargetUid: " + linkedList.getFirst().navigationTargetUid + ", but from different parent chains."));
        }
        return linkedList;
    }

    @Override
    public ObjectNavigatorNodeSpec getClosestAncestorNodeThatCanBeFocused(String string, List<ObjectNavigatorNodeSpec> list) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getClosestAncestorNodeThatCanBeFocused(): id is not set");
            return null;
        }
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec = this.getNodeSpecById(string, list);
        if (objectNavigatorNodeSpec != null && objectNavigatorNodeSpec.isFocusable.booleanValue()) {
            return objectNavigatorNodeSpec;
        }
        if (objectNavigatorNodeSpec == null) {
            return null;
        }
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec2 = this.getNodeSpecById(objectNavigatorNodeSpec.parentUid, list);
        while (objectNavigatorNodeSpec2 != null) {
            if (objectNavigatorNodeSpec2.isFocusable.booleanValue()) {
                return objectNavigatorNodeSpec2;
            }
            objectNavigatorNodeSpec2 = this.getNodeSpecById(objectNavigatorNodeSpec2.parentUid, list);
        }
        return null;
    }

    private void populateCategoryNode(CategoryNode categoryNode, List<ObjectNavigatorNodeSpec> list) {
        ArrayList<CategoryNode> arrayList = new ArrayList<CategoryNode>();
        arrayList.add(categoryNode);
        for (int i = 0; i != 2; ++i) {
            ArrayList<CategoryNode> arrayList2 = new ArrayList<CategoryNode>();
            for (CategoryNode categoryNode2 : arrayList) {
                this.retrieveAndAddChildren(categoryNode2, arrayList2, list);
            }
            arrayList = arrayList2;
        }
    }

    private void retrieveAndAddChildren(CategoryNode categoryNode, List<CategoryNode> list, List<ObjectNavigatorNodeSpec> list2) {
        List<ObjectNavigatorNodeSpec> list3 = this.getChildrenNodeSpecsByParentId(categoryNode.uid, list2);
        if (list3.isEmpty()) {
            return;
        }
        if (categoryNode.children == null) {
            categoryNode.children = new ArrayList<CategoryNode>();
        }
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list3) {
            CategoryNode categoryNode2 = this.transformObjectSpecsToCategoryNode(objectNavigatorNodeSpec);
            categoryNode.children.add(categoryNode2);
            list.add(categoryNode2);
        }
    }

    private CategoryNode transformObjectSpecsToCategoryNode(ObjectNavigatorNodeSpec objectNavigatorNodeSpec) {
        CategoryNode categoryNode = null;
        if (objectNavigatorNodeSpec != null) {
            categoryNode = new CategoryNode(objectNavigatorNodeSpec.getUid());
            categoryNode.title = objectNavigatorNodeSpec.title;
            categoryNode.icon = objectNavigatorNodeSpec.icon;
            categoryNode.viewOpenedUponFocus = objectNavigatorNodeSpec.getViewOpenedUponFocus();
            if (categoryNode.viewOpenedUponFocus != null) {
                categoryNode.viewOpenedUponFocus.setUid(objectNavigatorNodeSpec.getUid());
            }
            categoryNode.navigationTargetUid = objectNavigatorNodeSpec.navigationTargetUid;
            categoryNode.nodeObjectType = objectNavigatorNodeSpec.nodeObjectType;
        }
        return categoryNode;
    }

    private ObjectNavigatorNodeSpec getNodeSpecById(String string, List<ObjectNavigatorNodeSpec> list) {
        if (string == null) {
            return null;
        }
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            if (!string.equals(objectNavigatorNodeSpec.getUid())) continue;
            return objectNavigatorNodeSpec;
        }
        return null;
    }

    private ObjectNavigatorNodeSpec getRootNode(List<ObjectNavigatorNodeSpec> list) {
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            if (objectNavigatorNodeSpec.parentUid != null) continue;
            return objectNavigatorNodeSpec;
        }
        return null;
    }

    private List<ObjectNavigatorNodeSpec> getChildrenNodeSpecsByParentId(String string, List<ObjectNavigatorNodeSpec> list) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<ObjectNavigatorNodeSpec> arrayList = new ArrayList<ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            if (!string.equals(objectNavigatorNodeSpec.parentUid)) continue;
            arrayList.add(objectNavigatorNodeSpec);
        }
        return arrayList;
    }

    @Override
    public List<ObjectNavigatorNodeSpec> getNodeSpecs() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("onlyLocalFilters", true);
        return this._extensionService.getExtensionObjects(OBJECT_NAVIGATOR_EXT_POINT, hashMap, false);
    }

    @Override
    public List<ObjectNavigatorNodeSpec> getNavigableNodeSpecsAndAncestors(String string, List<ObjectNavigatorNodeSpec> list) {
        if (StringUtil.isNullOrEmpty((String)string) || list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        List<ObjectNavigatorNodeSpec> list2 = this.getNodeSpecsByNavigationTargetUid(string, list);
        this.addNodeSpecAncestors(list2, list);
        list2 = this.filterNodeSpecs(list2);
        return list2;
    }

    @Override
    public Set<String> getValidExtensionUids(CategoryNode categoryNode) {
        if (categoryNode == null) {
            return Collections.emptySet();
        }
        List<ExtensionInfo> list = this.getCategoryExtensionInfos(categoryNode);
        return this.runRemoteFilters(list);
    }

    private List<ExtensionInfo> getCategoryExtensionInfos(CategoryNode categoryNode) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        arrayList.add(this.getExtensionInfo(categoryNode.uid));
        List<CategoryNode> list = categoryNode.children;
        if (list == null) {
            return arrayList;
        }
        while (!list.isEmpty()) {
            ArrayList<CategoryNode> arrayList2 = new ArrayList<CategoryNode>();
            for (CategoryNode categoryNode2 : list) {
                arrayList.add(this.getExtensionInfo(categoryNode2.uid));
                if (categoryNode2.children == null || categoryNode2.children.isEmpty()) continue;
                arrayList2.addAll(categoryNode2.children);
            }
            list = arrayList2;
        }
        return arrayList;
    }

    private List<ObjectNavigatorNodeSpec> filterNodeSpecs(List<ObjectNavigatorNodeSpec> list) {
        if (list.isEmpty()) {
            return list;
        }
        List<ExtensionInfo> list2 = this.getExtensionInfos(list);
        Set<String> set = this.runRemoteFilters(list2);
        ArrayList<ObjectNavigatorNodeSpec> arrayList = new ArrayList<ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            if (!set.contains(objectNavigatorNodeSpec.getUid())) continue;
            arrayList.add(objectNavigatorNodeSpec);
        }
        return arrayList;
    }

    private List<ObjectNavigatorNodeSpec> getNodeSpecsByNavigationTargetUid(String string, List<ObjectNavigatorNodeSpec> list) {
        ArrayList<ObjectNavigatorNodeSpec> arrayList = new ArrayList<ObjectNavigatorNodeSpec>();
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.warn((Object)"getNodeSpecsByNavigationTargetUid(): navigationTargetUid is null");
            return arrayList;
        }
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            if (!string.equals(objectNavigatorNodeSpec.navigationTargetUid)) continue;
            arrayList.add(objectNavigatorNodeSpec);
        }
        return arrayList;
    }

    private void addNodeSpecAncestors(List<ObjectNavigatorNodeSpec> list, List<ObjectNavigatorNodeSpec> list2) {
        if (list.isEmpty()) {
            _logger.warn((Object)"addNodeSpecAncestors(): navigationNodeSpecs is empty");
            return;
        }
        HashMap<String, ObjectNavigatorNodeSpec> hashMap = new HashMap<String, ObjectNavigatorNodeSpec>();
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list2) {
            hashMap.put(objectNavigatorNodeSpec.getUid(), objectNavigatorNodeSpec);
        }
        Iterator<ObjectNavigatorNodeSpec> iterator = list.listIterator();
        while (iterator.hasNext()) {
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec;
            objectNavigatorNodeSpec = (ObjectNavigatorNodeSpec)iterator.next();
            ObjectNavigatorNodeSpec objectNavigatorNodeSpec2 = (ObjectNavigatorNodeSpec)hashMap.get(objectNavigatorNodeSpec.parentUid);
            hashMap.remove(objectNavigatorNodeSpec.getUid());
            while (objectNavigatorNodeSpec2 != null) {
                if (!list.contains(objectNavigatorNodeSpec2)) {
                    iterator.add(objectNavigatorNodeSpec2);
                }
                hashMap.remove(objectNavigatorNodeSpec2.getUid());
                objectNavigatorNodeSpec2 = (ObjectNavigatorNodeSpec)hashMap.get(objectNavigatorNodeSpec2.parentUid);
            }
        }
    }

    private Set<String> runRemoteFilters(List<ExtensionInfo> list) {
        HashSet<String> hashSet = new HashSet<String>();
        if (list.isEmpty()) {
            return hashSet;
        }
        Filterer filterer = new Filterer(false);
        HashMap hashMap = new HashMap();
        List list2 = this._serviceRegistry.getServices(ExtensionObjectFilter.class.getName());
        Filterer.FilterResult filterResult = filterer.filterExtensions(list, hashMap, list2);
        for (ExtensionInfo extensionInfo : filterResult.extensionInfos) {
            hashSet.add(extensionInfo.getId());
        }
        return hashSet;
    }

    private List<ExtensionInfo> getExtensionInfos(List<ObjectNavigatorNodeSpec> list) {
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
        for (ObjectNavigatorNodeSpec objectNavigatorNodeSpec : list) {
            ExtensionInfo extensionInfo = this.getExtensionInfo(objectNavigatorNodeSpec.getUid());
            if (extensionInfo == null) continue;
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private ExtensionInfo getExtensionInfo(String string) {
        ExtensionInfo extensionInfo = null;
        try {
            extensionInfo = this._extensionService.getExtensionInfo(string);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
        }
        assert (extensionInfo != null);
        return extensionInfo;
    }
}

