/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorNavigationManager;
import com.vmware.vise.mvc.objectnavigator.interpreter.NavigationRequestInterpreter;
import com.vmware.vise.mvc.objectnavigator.model.NavigationRequest;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.util.concurrent.annotation.GuardedBy;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ObjectNavigatorNavigationManagerImpl
implements ObjectNavigatorNavigationManager {
    private static final String INTERFACE_NAME = NavigationRequestInterpreter.class.getName();
    private final ServiceRegistry _serviceRegistry;
    private final ExtensionService _extensionService;
    @GuardedBy(value="LOCK")
    private volatile List<NavigationRequestInterpreter> _interpreters;
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorNavigationManagerImpl.class);
    private final Object LOCK = new Object();
    private final ServiceListener _serviceListener;

    @Autowired
    public ObjectNavigatorNavigationManagerImpl(ServiceRegistry serviceRegistry, ExtensionService extensionService) {
        this._serviceRegistry = serviceRegistry;
        this._extensionService = extensionService;
        this._serviceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceAdded(Object object) {
                Object object2 = ObjectNavigatorNavigationManagerImpl.this.LOCK;
                synchronized (object2) {
                    ObjectNavigatorNavigationManagerImpl.this.processNavRequestInterpreters();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(Object object) {
                Object object2 = ObjectNavigatorNavigationManagerImpl.this.LOCK;
                synchronized (object2) {
                    ObjectNavigatorNavigationManagerImpl.this.processNavRequestInterpreters();
                }
            }
        };
        this.registerNavRequestInterpreters();
    }

    @Override
    public NavigationResponse handleNavigationRequest(String string, String string2, String string3, String string4) {
        if (this._interpreters == null) {
            throw new IllegalStateException("Interpreters have not been initialized");
        }
        NavigationResponse navigationResponse = null;
        for (NavigationRequestInterpreter navigationRequestInterpreter : this._interpreters) {
            NavigationRequest navigationRequest = this.createNavigationRequest(string, string2, string3, string4);
            try {
                navigationResponse = navigationRequestInterpreter.interpretNavigationRequest(navigationRequest);
            }
            catch (Exception exception) {
                _logger.error((Object)("Error in interpreting request, interpreter=" + navigationRequestInterpreter + " error: "), (Throwable)exception);
            }
            if (navigationResponse == null) continue;
            return navigationResponse;
        }
        _logger.info((Object)new StringBuilder(200).append("handleNavigationRequest(). Could not interpret navigation request. targetID=").append(string).append(" ,context=").append(string2).toString());
        return navigationResponse;
    }

    public void destroy() {
        this._serviceRegistry.unregisterServiceListener(INTERFACE_NAME, this._serviceListener);
    }

    private NavigationRequest createNavigationRequest(String string, String string2, String string3, String string4) {
        NavigationRequest navigationRequest = new NavigationRequest();
        navigationRequest.targetViewId = string;
        navigationRequest.contextObject = string2;
        navigationRequest.navigator = string3;
        navigationRequest.prevNavigator = string4;
        try {
            navigationRequest.extensionPaths = this._extensionService.getExtensionHosts(string);
        }
        catch (Exception exception) {
            _logger.error((Object)"Error in querying extension paths.", (Throwable)exception);
        }
        return navigationRequest;
    }

    private void registerNavRequestInterpreters() {
        this._serviceRegistry.registerServiceListener(INTERFACE_NAME, this._serviceListener);
    }

    private void processNavRequestInterpreters() {
        List list = this._serviceRegistry.getServices(NavigationRequestInterpreter.class.getName());
        this._interpreters = new ArrayList<NavigationRequestInterpreter>(list);
    }
}

