/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator.interpreter;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.mvc.model.ObjectSpec;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.interpreter.NavigationRequestInterpreter;
import com.vmware.vise.mvc.objectnavigator.model.NavigationRequest;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.mvc.objectnavigator.util.ObjectNavigatorUtil;
import com.vmware.vise.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CategoryNodeNavReqInterpreter
implements NavigationRequestInterpreter {
    private static final Log _logger = LogFactory.getLog(CategoryNodeNavReqInterpreter.class);
    private final ObjectNavigatorManager _objectNavigatorManager;

    @Autowired
    public CategoryNodeNavReqInterpreter(ObjectNavigatorManager objectNavigatorManager) {
        this._objectNavigatorManager = objectNavigatorManager;
    }

    @Override
    public NavigationResponse interpretNavigationRequest(NavigationRequest navigationRequest) {
        NavigationResponse navigationResponse;
        if (!StringUtil.isNullOrEmpty((String)navigationRequest.contextObject) && navigationRequest.navigator != null) {
            return null;
        }
        ExtensionInfo extensionInfo = ObjectNavigatorUtil.getRootExtension(navigationRequest.extensionPaths);
        String string = extensionInfo != null ? extensionInfo.getId() : null;
        List<ObjectNavigatorNodeSpec> list = this._objectNavigatorManager.getNodeSpecs();
        List<ObjectNavigatorNodeSpec> list2 = this._objectNavigatorManager.getNavigableNodeSpecsAndAncestors(navigationRequest.targetViewId, list);
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec = this._objectNavigatorManager.getNodeByNavigationTargetUid(navigationRequest.targetViewId, list2);
        if (objectNavigatorNodeSpec == null && !StringUtil.isNullOrEmpty((String)string)) {
            list2 = this._objectNavigatorManager.getNavigableNodeSpecsAndAncestors(string, list);
            objectNavigatorNodeSpec = this._objectNavigatorManager.getNodeByNavigationTargetUid(string, list2);
        }
        if (objectNavigatorNodeSpec == null) {
            return null;
        }
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec2 = this._objectNavigatorManager.getClosestAncestorNodeThatCanBeFocused(objectNavigatorNodeSpec.getUid(), list2);
        if (objectNavigatorNodeSpec2 == null) {
            _logger.warn((Object)("interpretNavigationRequest(): Parent node is not set for selectedNode: " + objectNavigatorNodeSpec.getUid() + " ,targetViewUId=" + navigationRequest.targetViewId));
            return null;
        }
        String string2 = null;
        if (!objectNavigatorNodeSpec2.getUid().equals(objectNavigatorNodeSpec.getUid())) {
            string2 = objectNavigatorNodeSpec.getUid();
        }
        if ((navigationResponse = this.createNavigationResponse(objectNavigatorNodeSpec2)) != null && string2 != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("selectedNodeId", string2);
            navigationResponse.viewState = hashMap;
        }
        return navigationResponse;
    }

    private NavigationResponse createNavigationResponse(ObjectNavigatorNodeSpec objectNavigatorNodeSpec) {
        ObjectSpec objectSpec;
        NavigationResponse navigationResponse = null;
        if (objectNavigatorNodeSpec != null && (objectSpec = objectNavigatorNodeSpec.getViewOpenedUponFocus()) != null) {
            objectSpec.setUid(objectNavigatorNodeSpec.getUid());
            navigationResponse = new NavigationResponse();
            navigationResponse.uid = objectNavigatorNodeSpec.getUid();
            navigationResponse.title = objectNavigatorNodeSpec.title;
            navigationResponse.icon = objectNavigatorNodeSpec.icon;
            navigationResponse.viewSpec = objectSpec;
        }
        return navigationResponse;
    }
}

