/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.objectnavigator.interpreter;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.mvc.model.ObjectSpec;
import com.vmware.vise.mvc.objectnavigator.ObjectNavigatorManager;
import com.vmware.vise.mvc.objectnavigator.interpreter.NavigationRequestInterpreter;
import com.vmware.vise.mvc.objectnavigator.model.NavigationRequest;
import com.vmware.vise.mvc.objectnavigator.model.NavigationResponse;
import com.vmware.vise.mvc.objectnavigator.model.ObjectNavigatorNodeSpec;
import com.vmware.vise.mvc.objectnavigator.util.ObjectNavigatorUtil;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.util.StringUtil;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ObjectNodeNavReqInterpreter
implements NavigationRequestInterpreter {
    private static final Log _logger = LogFactory.getLog(ObjectNodeNavReqInterpreter.class);
    private static final String SERVER_EXTENSION_ID = "vsphere.core.inventory.serverObjectViewsExtension";
    private static final String RELATED_ITEMS_VIEW = "resources/ui/views/objectnavigator/RelatedItemsView.html";
    private static final String OBJECT_NOT_FOUND_VIEW = "resources/ui/views/objectnavigator/error/ObjectNotFound.html";
    private static final String TREE_ID = "tree";
    private final ObjectReferenceService _objRefService;
    private final ObjectNavigatorManager _objectNavigatorManager;
    private final QueryService _queryService;
    private final ObjectSpec _relatedItemSpec = new ObjectSpec();
    private final ObjectSpec _notFoundObjectSpec = new ObjectSpec();

    @Autowired
    public ObjectNodeNavReqInterpreter(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ObjectNavigatorManager objectNavigatorManager, QueryServiceFactory queryServiceFactory) {
        this._objRefService = objectReferenceService;
        this._objectNavigatorManager = objectNavigatorManager;
        this._queryService = queryServiceFactory.getQueryService();
        this._relatedItemSpec.url = RELATED_ITEMS_VIEW;
        this._notFoundObjectSpec.url = OBJECT_NOT_FOUND_VIEW;
    }

    @Override
    public NavigationResponse interpretNavigationRequest(NavigationRequest navigationRequest) {
        if (!this.isRequestValid(navigationRequest)) {
            return null;
        }
        NavigationResponse navigationResponse = this.checkAndCreateNavigationResponseForObjectNotFound(navigationRequest);
        if (navigationResponse != null) {
            return navigationResponse;
        }
        if (StringUtil.isNullOrEmpty((String)navigationRequest.navigator)) {
            return this.createNavResponseForFocusedObject(navigationRequest);
        }
        NavigationResponse navigationResponse2 = this.createNavigationResponseForObjectInTree(navigationRequest);
        return navigationResponse2;
    }

    private boolean isRequestValid(NavigationRequest navigationRequest) {
        String string;
        if (StringUtil.isNullOrEmpty((String)navigationRequest.contextObject)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("interpretNavigationRequest(): Null context object set. Target extension id=" + navigationRequest.targetViewId));
            }
            return false;
        }
        ExtensionInfo extensionInfo = ObjectNavigatorUtil.getRootExtension(navigationRequest.extensionPaths);
        String string2 = string = extensionInfo != null ? extensionInfo.getId() : null;
        if (!SERVER_EXTENSION_ID.equals(navigationRequest.targetViewId) && !SERVER_EXTENSION_ID.equals(string)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)new StringBuilder(200).append("interpretNavigationRequest(): Target or root extension id not SERVER_EXTENSION_ID. targetExtensionID=").append(navigationRequest.targetViewId).append(", rootViewExtensionId=").append(string).toString());
            }
            return false;
        }
        return true;
    }

    private NavigationResponse checkAndCreateNavigationResponseForObjectNotFound(NavigationRequest navigationRequest) {
        Object object = this._objRefService.getReference(navigationRequest.contextObject, true);
        if (object == null || !this.objectExists(object)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)new StringBuilder(200).append("interpretNavigationRequest(): Context object is not a valid resource ref. Target extension id=").append(navigationRequest.targetViewId).append(", objectId=").append(navigationRequest.contextObject).toString());
            }
            return this.createNavigationResponse(navigationRequest.contextObject, this._notFoundObjectSpec);
        }
        return null;
    }

    private boolean objectExists(Object object) {
        String string = this._objRefService.getResourceObjectType(object);
        ResultSet resultSet = this._queryService.select(new String[0]).withTotalCount().from(new String[]{string}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).limit(0).fetch();
        return resultSet.getTotalCount() != 0;
    }

    private NavigationResponse createNavResponseForFocusedObject(NavigationRequest navigationRequest) {
        NavigationResponse navigationResponse = this.createNavigationResponse(navigationRequest.contextObject, this._relatedItemSpec);
        return navigationResponse;
    }

    private NavigationResponse createNavigationResponseForObjectInTree(NavigationRequest navigationRequest) {
        Object object;
        Object object2 = navigationRequest.navigator;
        if (((String)object2).equals(TREE_ID)) {
            object = TreeList.getAssociatedTreeIdForObject(navigationRequest.contextObject, navigationRequest.prevNavigator, this._objRefService, this._queryService);
            if (object != null) {
                object2 = object;
            } else {
                return this.createNavResponseForFocusedObject(navigationRequest);
            }
        }
        if ((object = this.getObjectNavigatorNodeSpec((String)object2)) == null) {
            _logger.warn((Object)("No focusable navigator node with ID: " + navigationRequest.navigator));
            return null;
        }
        NavigationResponse navigationResponse = this.createNavigationResponseWithTreeView((ObjectNavigatorNodeSpec)object, navigationRequest.contextObject);
        return navigationResponse;
    }

    private ObjectNavigatorNodeSpec getObjectNavigatorNodeSpec(String string) {
        ObjectSpec objectSpec;
        List<ObjectNavigatorNodeSpec> list = this._objectNavigatorManager.getNodeSpecs();
        List<ObjectNavigatorNodeSpec> list2 = this._objectNavigatorManager.getNavigableNodeSpecsAndAncestors(string, list);
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec = this._objectNavigatorManager.getNodeByNavigationTargetUid(string, list2);
        ObjectNavigatorNodeSpec objectNavigatorNodeSpec2 = objectNavigatorNodeSpec == null || objectNavigatorNodeSpec.isFocusable != false ? objectNavigatorNodeSpec : this._objectNavigatorManager.getClosestAncestorNodeThatCanBeFocused(objectNavigatorNodeSpec.getUid(), list2);
        ObjectSpec objectSpec2 = objectSpec = objectNavigatorNodeSpec2 != null ? objectNavigatorNodeSpec2.getViewOpenedUponFocus() : null;
        if (objectSpec != null) {
            objectSpec.setUid(objectNavigatorNodeSpec2.getUid());
        }
        return objectNavigatorNodeSpec2;
    }

    private NavigationResponse createNavigationResponseWithTreeView(ObjectNavigatorNodeSpec objectNavigatorNodeSpec, String string) {
        NavigationResponse navigationResponse = new NavigationResponse();
        navigationResponse.uid = objectNavigatorNodeSpec.getUid();
        navigationResponse.title = objectNavigatorNodeSpec.title;
        navigationResponse.icon = objectNavigatorNodeSpec.icon;
        navigationResponse.viewSpec = objectNavigatorNodeSpec.getViewOpenedUponFocus();
        navigationResponse.viewState = string != null ? ImmutableMap.of((Object)"selectedObject", (Object)string) : null;
        return navigationResponse;
    }

    private NavigationResponse createNavigationResponse(String string, ObjectSpec objectSpec) {
        NavigationResponse navigationResponse = new NavigationResponse();
        navigationResponse.uid = string;
        navigationResponse.viewSpec = objectSpec;
        return navigationResponse;
    }
}

