/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.psc;

import com.vmware.vise.mvc.psc.SecureStore;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.ConnectIOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class PscRestClient {
    private static final String DATE_HEADER = "Date";
    private static final ContentType APPLICATION_JSON_UTF8 = ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)"UTF-8");
    private static final Log _logger = LogFactory.getLog(PscRestClient.class);
    private final ConfigurationService _configurationService;
    private final SecureStore _secureStore;
    private final HttpClient _httpClient;

    public PscRestClient(SecureStore secureStore, ConfigurationService configurationService) throws Exception {
        this._configurationService = configurationService;
        this._secureStore = secureStore;
        TrustManager[] trustManagerArray = this.loadTrustManagers();
        this._httpClient = this.makeHttpClient(trustManagerArray);
    }

    public HttpResponse sendPostMessage(URI uRI, String string, String string2, String string3, String string4) throws ConnectIOException, ClientProtocolException, IOException, URISyntaxException {
        if (uRI.getPort() == -1) {
            uRI = new URIBuilder(uRI).setPort(uRI.toURL().getDefaultPort()).build();
        }
        HttpResponse httpResponse = this._httpClient.execute((HttpUriRequest)this.createHttpPost(uRI, string, string2, string3, string4));
        return httpResponse;
    }

    public HttpResponse sendPutMessage(URI uRI, String string, String string2, String string3, String string4) throws ConnectIOException, ClientProtocolException, IOException, URISyntaxException {
        if (uRI.getPort() == -1) {
            uRI = new URIBuilder(uRI).setPort(uRI.toURL().getDefaultPort()).build();
        }
        HttpResponse httpResponse = this._httpClient.execute((HttpUriRequest)this.createHttpPut(uRI, string, string2, string3, string4));
        return httpResponse;
    }

    public HttpResponse sendDeleteMessage(URI uRI, String string, String string2, String string3) throws ConnectIOException, ClientProtocolException, IOException, URISyntaxException {
        if (uRI.getPort() == -1) {
            uRI = new URIBuilder(uRI).setPort(uRI.toURL().getDefaultPort()).build();
        }
        HttpResponse httpResponse = this._httpClient.execute((HttpUriRequest)this.createHttpDelete(uRI, string, string2, string3));
        return httpResponse;
    }

    private HttpPost createHttpPost(URI uRI, String string, String string2, String string3, String string4) {
        HttpPost httpPost = new HttpPost(uRI);
        httpPost.setHeader(DATE_HEADER, string3);
        httpPost.setHeader("Content-Type", "application/json");
        StringBuilder stringBuilder = new StringBuilder().append("access_token=").append(string).append("&").append("token_type=").append("saml").append("&").append("token_signature=").append(string2);
        if (!string4.equals("")) {
            stringBuilder = stringBuilder.append("&").append(string4);
        }
        httpPost.setEntity((HttpEntity)new StringEntity(stringBuilder.toString(), APPLICATION_JSON_UTF8));
        return httpPost;
    }

    private HttpDeleteWithBody createHttpDelete(URI uRI, String string, String string2, String string3) {
        HttpDeleteWithBody httpDeleteWithBody = new HttpDeleteWithBody(uRI);
        httpDeleteWithBody.setHeader(DATE_HEADER, string3);
        httpDeleteWithBody.setHeader("Content-Type", "application/json");
        StringBuilder stringBuilder = new StringBuilder().append("access_token=").append(string).append("&").append("token_type=").append("saml").append("&").append("token_signature=").append(string2);
        httpDeleteWithBody.setEntity((HttpEntity)new StringEntity(stringBuilder.toString(), APPLICATION_JSON_UTF8));
        _logger.debug((Object)("Request body: " + stringBuilder));
        return httpDeleteWithBody;
    }

    private HttpPut createHttpPut(URI uRI, String string, String string2, String string3, String string4) {
        HttpPut httpPut = new HttpPut(uRI);
        httpPut.setHeader(DATE_HEADER, string3);
        httpPut.setHeader("Content-Type", "application/json");
        StringBuilder stringBuilder = new StringBuilder().append("access_token=").append(string).append("&").append("token_type=").append("saml").append("&").append("token_signature=").append(string2);
        if (!string4.equals("")) {
            stringBuilder = stringBuilder.append("&").append(string4);
        }
        httpPut.setEntity((HttpEntity)new StringEntity(stringBuilder.toString(), APPLICATION_JSON_UTF8));
        return httpPut;
    }

    private HttpClient makeHttpClient(TrustManager[] trustManagerArray) throws Exception {
        return PscRestClient.newHttpsClient(trustManagerArray);
    }

    public static HttpClient newHttpsClient(TrustManager[] trustManagerArray) throws Exception {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
        sSLContext.init(null, trustManagerArray, new SecureRandom());
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContext, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        Registry registry = RegistryBuilder.create().register("https", (Object)sSLConnectionSocketFactory).build();
        BasicHttpClientConnectionManager basicHttpClientConnectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)basicHttpClientConnectionManager);
        return httpClientBuilder.build();
    }

    private TrustManager[] loadTrustManagers() throws Exception {
        KeyStore keyStore = this._secureStore.getTrustStore(this._configurationService);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        public HttpDeleteWithBody(String string) {
            this.setURI(URI.create(string));
        }

        public HttpDeleteWithBody(URI uRI) {
            this.setURI(uRI);
        }

        public HttpDeleteWithBody() {
        }
    }
}

