/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.psc;

import com.vmware.af.VmAfClient;
import com.vmware.vise.mvc.psc.PscRestClient;
import com.vmware.vise.mvc.psc.PscVmwKeyStore;
import com.vmware.vise.usersession.UserSession;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vsphere.client.security.util.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PscUtil {
    public static final String DC_PROPERTY_KEY = "psc.dc";
    public static final String DOMAIN_NAME_PROPERTY_KEY = "psc.domain.name";
    public static final String RHTTP_PROXY_PORT_PROPERTY_KEY = "psc.rhttp.proxy.port";
    public static final String DEFAULT_RHTTP_PORT = "443";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static VmAfClient _vmAfClient = null;
    private static UserSession userSession = null;
    private static PscRestClient _restClient;
    private static final Log _logger;

    public static String getDomainController(ConfigurationService configurationService) {
        String string = null;
        try {
            string = PscUtil.getVmAfClient().getDomainController();
        }
        catch (Error error) {
            string = configurationService.getProperty(DC_PROPERTY_KEY);
        }
        return string;
    }

    public static String getDomainName(ConfigurationService configurationService) {
        String string = null;
        try {
            string = PscUtil.getVmAfClient().getDomainName();
        }
        catch (Error error) {
            string = configurationService.getProperty(DOMAIN_NAME_PROPERTY_KEY);
        }
        return string;
    }

    public static String getRhttpProxyPort(ConfigurationService configurationService) {
        String string;
        block3: {
            string = null;
            try {
                string = Integer.valueOf(PscUtil.getVmAfClient().getRHTTPProxyPort()).toString();
            }
            catch (RuntimeException runtimeException) {
                string = DEFAULT_RHTTP_PORT;
            }
            catch (Error error) {
                string = configurationService.getProperty(RHTTP_PROXY_PORT_PROPERTY_KEY);
                if (string != null && !string.isEmpty()) break block3;
                string = DEFAULT_RHTTP_PORT;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PscRestClient getRestClient(ConfigurationService configurationService) {
        PscRestClient pscRestClient = _restClient;
        if (pscRestClient != null) return _restClient;
        Class<PscUtil> clazz = PscUtil.class;
        synchronized (PscUtil.class) {
            pscRestClient = _restClient;
            if (pscRestClient != null) return _restClient;
            try {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"Creating PSC REST client");
                }
                _restClient = pscRestClient = new PscRestClient(new PscVmwKeyStore(), configurationService);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error when creating PSC Rest Client.", exception);
            }
            return _restClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VmAfClient getVmAfClient() {
        VmAfClient vmAfClient = _vmAfClient;
        if (vmAfClient != null) return _vmAfClient;
        Class<PscUtil> clazz = PscUtil.class;
        synchronized (PscUtil.class) {
            vmAfClient = _vmAfClient;
            if (vmAfClient != null) return _vmAfClient;
            try {
                String string = "localhost";
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Creating vmafd client at " + string));
                }
                _vmAfClient = vmAfClient = new VmAfClient(string);
            }
            catch (Error error) {
                throw new RuntimeException("Error when creating VmAfClient.", error);
            }
            return _vmAfClient;
        }
    }

    public static String getSignature(String string, String string2, URI uRI, Date date, String string3, ConfigurationService configurationService) throws Exception {
        String string4 = "";
        if (string3 != null && string3 != "") {
            string4 = PscUtil.computeMD5(string3);
        }
        _logger.debug((Object)("Computed md5 string : " + string4));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("\n");
        stringBuilder.append(string4).append("\n");
        stringBuilder.append(string2).append("\n");
        stringBuilder.append(PscUtil.getHttpFormattedDate(date)).append("\n");
        stringBuilder.append(uRI);
        String string5 = stringBuilder.toString();
        String string6 = PscUtil.sign(string5, configurationService);
        return string6;
    }

    public static String getEncodedSAMLXML() throws Exception {
        userSession = Util.getUserSession();
        String string = PscUtil.userSession.samlTokenXml.toString();
        byte[] byArray = string.getBytes("UTF-8");
        String string2 = new String(Base64.encodeBase64((byte[])byArray));
        return string2;
    }

    public static String getHttpFormattedDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat.format(date);
    }

    public static String computeMD5(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("An error occurred while getting the message digest", noSuchAlgorithmException);
        }
        return Hex.encodeHexString((byte[])messageDigest.digest(string.getBytes(StandardCharsets.UTF_8)));
    }

    private static PrivateKey getNgcPrivateKeyFromVecs() throws Exception {
        KeyStore keyStore = null;
        PrivateKey privateKey = null;
        try {
            keyStore = KeyStore.getInstance("VKS2");
            Class<?> clazz = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)clazz.getConstructor(String.class).newInstance("vsphere-webclient");
            keyStore.load(loadStoreParameter);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Keystore loaded successfully");
            }
            privateKey = (PrivateKey)keyStore.getKey("vsphere-webclient", null);
        }
        catch (Exception exception) {
            throw new IOException("Failed to load keystore ", exception);
        }
        return privateKey;
    }

    private static PrivateKey getNgcPrivateKeyFromJKS(ConfigurationService configurationService) throws Exception {
        KeyStore keyStore = null;
        PrivateKey privateKey = null;
        try {
            char[] cArray = configurationService.getProperty("keystore.jks.password").toCharArray();
            keyStore = KeyStore.getInstance("JKS");
            FileInputStream fileInputStream = new FileInputStream(configurationService.getProperty("keystore.jks.path"));
            keyStore.load(fileInputStream, cArray);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"Keystore loaded successfully");
            }
            privateKey = (PrivateKey)keyStore.getKey("vsphere-webclient", cArray);
        }
        catch (Exception exception) {
            throw new IOException("Failed to load keystore ", exception);
        }
        return privateKey;
    }

    public static String sign(String string, ConfigurationService configurationService) throws InvalidKeyException, SignatureException, Exception {
        Signature signature;
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        PrivateKey privateKey = null;
        try {
            privateKey = PscUtil.getNgcPrivateKeyFromVecs();
        }
        catch (Exception exception) {
            _logger.warn((Object)"Failed to load keystore from VECS, using JKS store.");
            privateKey = PscUtil.getNgcPrivateKeyFromJKS(configurationService);
        }
        try {
            signature = Signature.getInstance(SHA256_WITH_RSA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalArgumentException("An error occurred while getting the signature algorithm", noSuchAlgorithmException);
        }
        signature.initSign(privateKey);
        signature.update(byArray);
        return Hex.encodeHexString((byte[])signature.sign());
    }

    static {
        _logger = LogFactory.getLog(PscUtil.class);
    }
}

