/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.psc;

import com.vmware.vise.mvc.psc.SecureStore;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.io.FileInputStream;
import java.security.KeyStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PscVmwKeyStore
implements SecureStore {
    private static final Log _log = LogFactory.getLog(PscVmwKeyStore.class);

    @Override
    public KeyStore getTrustStore(ConfigurationService configurationService) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("VKS2");
            Class<?> clazz = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)clazz.getConstructor(String.class).newInstance("TRUSTED_ROOTS");
            keyStore.load(loadStoreParameter);
        }
        catch (Exception exception) {
            _log.warn((Object)"Unable to load VKS store, using JKS store");
            try {
                char[] cArray = configurationService.getProperty("keystore.jks.password").toCharArray();
                keyStore = KeyStore.getInstance("JKS");
                FileInputStream fileInputStream = new FileInputStream(configurationService.getProperty("keystore.jks.path"));
                keyStore.load(fileInputStream, cArray);
            }
            catch (Exception exception2) {
                _log.error((Object)"Unable to load JKS store");
            }
        }
        return keyStore;
    }

    @Override
    public KeyStore getKeyStore() {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("VKS2");
            Class<?> clazz = Class.forName("com.vmware.provider.VecsLoadStoreParameter");
            KeyStore.LoadStoreParameter loadStoreParameter = (KeyStore.LoadStoreParameter)clazz.getConstructor(String.class).newInstance("vsphere-webclient");
            keyStore.load(loadStoreParameter);
        }
        catch (Exception exception) {
            _log.warn((Object)"VKS key store is not available");
        }
        return keyStore;
    }
}

