/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.relateditems;

import com.google.common.base.Optional;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.mvc.lists.util.ListUtil;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.relateditems.RelatedItemsManager;
import com.vmware.vise.mvc.relateditems.model.ObjectRelationSetSpec;
import com.vmware.vise.mvc.relateditems.model.ObjectSimpleRelationSetSpec;
import com.vmware.vise.mvc.relateditems.model.RelatedItemSummary;
import com.vmware.vise.mvc.relateditems.model.RelationSpec;
import com.vmware.vise.mvc.relateditems.model.SimpleRelatedItemResult;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class RelatedItemsManagerImpl
implements ExtensionListener,
RelatedItemsManager {
    private static final Log _logger = LogFactory.getLog(RelatedItemsManagerImpl.class);
    private static final String RELATED_ITEMS_EXT_POINT = "vise.relateditems.specs";
    private static final String SIMPLE_RELATED_ITEMS_EXT_POINT = "vsphere.relatedobjects.summary.specs";
    private static final String LIST_EXT_POINT = "vise.inventory.lists";
    private static final String NO_CONDITION_KEY = "noCondition";
    private static final String OBJECT_ID = "id";
    private static final String INVERSE_SUFFIX = "/@deprecatedInverse";
    private final ExtensionService _extensionService;
    private final ObjectReferenceService _objRefService;
    private final DataService _dataService;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, Map<String, Map<String, List<RelationSpec>>>> _relationSpecsByViewByConditionByType;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, ComponentSpec> _listComponentSpecById;
    @GuardedBy(value="_readWriteLock")
    private final Map<String, List<RelationSpec>> _simpleRelationSpecsByType;
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();
    private final List<ObjectRelationSetSpec> _objectRelationSetSpecs;
    private final QueryExecutor _queryExecutor;

    @Autowired
    public RelatedItemsManagerImpl(ExtensionService extensionService, @Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, DataService dataService, QueryExecutor queryExecutor) throws Exception {
        this._extensionService = extensionService;
        this._objRefService = objectReferenceService;
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
        this._relationSpecsByViewByConditionByType = new HashMap<String, Map<String, Map<String, List<RelationSpec>>>>();
        this._listComponentSpecById = new HashMap<String, ComponentSpec>();
        this._simpleRelationSpecsByType = new HashMap<String, List<RelationSpec>>();
        this._objectRelationSetSpecs = new ArrayList<ObjectRelationSetSpec>();
        if (this._extensionService.getExtensionPointInfo(RELATED_ITEMS_EXT_POINT) != null) {
            this.loadSpecs();
        }
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        this.loadSpecs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelatedItemSummary[] getRelatedItemsSummary(Object object, String string, boolean bl, boolean bl2, String string2) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        try {
            RelatedItemSummary[] relatedItemSummaryArray;
            RelationSpec relationSpec;
            List<Object> list;
            this._readLock.lock();
            if (StringUtil.isNullOrEmpty((String)string)) {
                list = this.getRelationSpecs(object, bl, string2);
            } else {
                list = new ArrayList();
                relationSpec = this.getRelationSpec(object, string, string2);
                if (relationSpec != null) {
                    list.add(relationSpec);
                }
            }
            relationSpec = null;
            if (bl2 && ((relationSpec = this._dataService.getData((RequestSpec)(relatedItemSummaryArray = this.transformRelationSpecToQuery(list, object, new String[0], true)))) == null || ((Response)relationSpec).resultSet == null)) {
                RelatedItemSummary[] relatedItemSummaryArray2 = new RelatedItemSummary[]{};
                return relatedItemSummaryArray2;
            }
            RelatedItemSummary[] relatedItemSummaryArray3 = relatedItemSummaryArray = this.transformRelationDataToSummary(object, (Response)relationSpec, list, bl2, string2 != null);
            return relatedItemSummaryArray3;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelatedItemSummary getRelatedItemSummary(Object object, String string, String string2) throws Exception {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, string, string2});
        try {
            this._readLock.lock();
            Optional<ObjectRelationSetSpec> optional2 = this.findOrss(object, string, string2);
            if (!optional2.isPresent()) {
                throw new IllegalArgumentException("ORSS not found for listViewId: " + string);
            }
            ObjectRelationSetSpec objectRelationSetSpec = (ObjectRelationSetSpec)optional2.get();
            RelationSpec relationSpec = null;
            for (RelationSpec relationSpec2 : objectRelationSetSpec.relationSpecs) {
                if (!relationSpec2.listViewId.equals(string)) continue;
                relationSpec = relationSpec2;
                break;
            }
            if (relationSpec == null) {
                throw new IllegalStateException("RelationSpec not found for listViewId: " + string);
            }
            Object[] objectArray = this.transformRelationDataToSummary(object, null, Arrays.asList(relationSpec), false, false);
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                throw new IllegalStateException("Empty summary for: " + objectRelationSetSpec.relationsViewId);
            }
            if (objectArray.length > 1) {
                throw new IllegalStateException("Summary size bigger than expected for: " + objectRelationSetSpec.relationsViewId + ". Expected size of 1, got: " + objectArray.length);
            }
            Object object2 = objectArray[0];
            return object2;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getRelatedItems(Object object, String string, String[] stringArray) {
        try {
            List<Map<String, Object>> list;
            this._readLock.lock();
            RelationSpec relationSpec = this.getRelationSpec(object, string, null);
            if (relationSpec == null) {
                throw new IllegalArgumentException("No matching RelationSpec found for relation id - " + string);
            }
            if (stringArray == null) {
                stringArray = ListUtil.getPropertiesToFetch(this._extensionService, relationSpec.listViewId);
            }
            ArrayList<RelationSpec> arrayList = new ArrayList<RelationSpec>();
            arrayList.add(relationSpec);
            RequestSpec requestSpec = this.transformRelationSpecToQuery(arrayList, object, stringArray, false);
            Response response = this._dataService.getData(requestSpec);
            if (response == null || response.resultSet == null) {
                List<Map<String, Object>> list2 = null;
                return list2;
            }
            List<Map<String, Object>> list3 = list = this.transformRelationDataToMap(response.resultSet[0]);
            return list3;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SimpleRelatedItemResult> getSimpleRelatedItems(Object object) {
        try {
            this._readLock.lock();
            String string = this._objRefService.getResourceObjectType(object);
            List<RelationSpec> list = this._simpleRelationSpecsByType.get(string);
            ArrayList<SimpleRelatedItemResult> arrayList = new ArrayList<SimpleRelatedItemResult>();
            if (list == null) {
                ArrayList<SimpleRelatedItemResult> arrayList2 = arrayList;
                return arrayList2;
            }
            RequestSpec requestSpec = this.transformRelationSpecToQuery(list, object, RelatedItemsManager.DEFAULT_PROPERTIES, false);
            Response response = this._dataService.getData(requestSpec);
            if (response == null || response.resultSet == null) {
                ArrayList<SimpleRelatedItemResult> arrayList3 = arrayList;
                return arrayList3;
            }
            for (int i = 0; i < response.resultSet.length; ++i) {
                if (response.resultSet[i].items.length <= 0) continue;
                SimpleRelatedItemResult simpleRelatedItemResult = new SimpleRelatedItemResult();
                simpleRelatedItemResult.label = list.get((int)i).label;
                simpleRelatedItemResult.relatedItems = this.transformRelationDataToMap(response.resultSet[i]);
                arrayList.add(simpleRelatedItemResult);
            }
            ArrayList<SimpleRelatedItemResult> arrayList4 = arrayList;
            return arrayList4;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Filter> getFilterByRelationId(Object object, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, string});
        try {
            this._readLock.lock();
            String string2 = this._objRefService.getResourceObjectType(object);
            if (string2 == null) {
                Optional optional2 = Optional.absent();
                return optional2;
            }
            for (ObjectRelationSetSpec objectRelationSetSpec : this._objectRelationSetSpecs) {
                if (!string2.equals(objectRelationSetSpec.type)) continue;
                for (RelationSpec relationSpec : objectRelationSetSpec.relationSpecs) {
                    if (!string.equals(relationSpec.id)) continue;
                    Optional<Filter> optional3 = this.getRelatedItemFilter(relationSpec, object);
                    return optional3;
                }
            }
            Optional optional4 = Optional.absent();
            return optional4;
        }
        finally {
            this._readLock.unlock();
        }
    }

    private Optional<Filter> getRelatedItemFilter(RelationSpec relationSpec, Object object) {
        String string;
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>();
        if (!StringUtil.isNullOrEmpty((String)relationSpec.inverseRelation)) {
            arrayList.add(new PropertyPredicate(relationSpec.inverseRelation, PropertyPredicate.ComparisonOperator.EQUAL, object));
        } else if (!StringUtil.isNullOrEmpty((String)relationSpec.relation)) {
            string = relationSpec.relation + INVERSE_SUFFIX;
            arrayList.add(new PropertyPredicate(string, PropertyPredicate.ComparisonOperator.EQUAL, object));
        }
        if (!StringUtil.isNullOrEmpty((String)relationSpec.conditionalProperty)) {
            string = relationSpec.conditionalProperty;
            boolean bl = true;
            if (relationSpec.conditionalProperty.charAt(0) == '!') {
                bl = false;
                string = relationSpec.conditionalProperty.substring(1);
            }
            arrayList.add(new PropertyPredicate(string, PropertyPredicate.ComparisonOperator.EQUAL, (Object)bl));
        }
        if (arrayList.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)new Filter(arrayList));
    }

    private boolean isValidRelationSpec(RelationSpec relationSpec, String string, String string2) {
        return relationSpec.listViewId != null && relationSpec.targetType != null && relationSpec.listViewId.equals(string) && relationSpec.targetType.equals(string2);
    }

    private Optional<ObjectRelationSetSpec> findOrss(Object object, String string, String string2) throws Exception {
        ArrayList<ObjectRelationSetSpec> arrayList = new ArrayList<ObjectRelationSetSpec>();
        String string3 = this._objRefService.getResourceObjectType(object);
        if (string3 == null) {
            throw new IllegalArgumentException("Invalid REF?! " + object);
        }
        HashMap<Property, ObjectRelationSetSpec> hashMap = new HashMap<Property, ObjectRelationSetSpec>();
        for (ObjectRelationSetSpec propertyValueArray2 : this._objectRelationSetSpecs) {
            if (!propertyValueArray2.type.equals(string3)) continue;
            for (RelationSpec relationSpec : propertyValueArray2.relationSpecs) {
                if (!this.isValidRelationSpec(relationSpec, string, string2)) continue;
                if (propertyValueArray2.conditionalProperty != null) {
                    Property property = propertyValueArray2.conditionalProperty.charAt(0) == '!' ? new Property(this.cleanPropertyName(propertyValueArray2.conditionalProperty), 2) : new Property(propertyValueArray2.conditionalProperty, 1);
                    hashMap.put(property, propertyValueArray2);
                }
                arrayList.add(propertyValueArray2);
            }
        }
        if (arrayList.isEmpty()) {
            return Optional.absent();
        }
        if (hashMap.isEmpty()) {
            if (arrayList.size() > 1) {
                _logger.error((Object)("Got multiple specs for listViewId: " + string));
                return Optional.absent();
            }
            return Optional.of(arrayList.get(0));
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object object2 : hashMap.keySet()) {
            arrayList2.add(((Property)object2).getName());
        }
        PropertyValue[] propertyValueArray = this._queryExecutor.getProperties(object, arrayList2.toArray(new String[0]));
        for (PropertyValue propertyValue : propertyValueArray) {
            boolean bl = (Boolean)propertyValue.value;
            String string4 = propertyValue.propertyName;
            for (Property property : hashMap.keySet()) {
                if (!this.isConditionMatched(bl, string4, property)) continue;
                ObjectRelationSetSpec objectRelationSetSpec = (ObjectRelationSetSpec)hashMap.get(property);
                if (objectRelationSetSpec == null) {
                    throw new IllegalStateException("Got a null ORSS, this should never happen!");
                }
                return Optional.of((Object)objectRelationSetSpec);
            }
        }
        return Optional.absent();
    }

    private boolean isConditionMatched(boolean bl, String string, Property property) {
        return !property.isNegated() && property.getName().equals(string) && bl || property.isNegated() && property.getName().equals(string) && !bl;
    }

    private RelationSpec getRelationSpec(Object object, String string, String string2) {
        List<RelationSpec> list = this.getRelationSpecs(object, false, string2);
        for (RelationSpec relationSpec : list) {
            if (!relationSpec.id.equals(string)) continue;
            return relationSpec;
        }
        return null;
    }

    private List<RelationSpec> getRelationSpecs(Object object, boolean bl, String string) {
        String string2 = this._objRefService.getResourceObjectType(object);
        String[] stringArray = this.getConditionalPropertyNames(string2, bl);
        Map<String, Object> map = null;
        if (stringArray != null && stringArray.length > 0) {
            map = this.getProperties(object, stringArray);
        }
        return this.getFilteredRelationSpecs(string2, bl, map, string);
    }

    private RequestSpec transformRelationSpecToQuery(List<RelationSpec> list, Object object, String[] stringArray, boolean bl) {
        QuerySpec[] querySpecArray = new QuerySpec[list.size()];
        int n = 0;
        for (RelationSpec relationSpec : list) {
            Constraint constraint = this.getRelatedItemConstraint(relationSpec, object);
            QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])stringArray);
            ResultSpec resultSpec = new ResultSpec();
            if (bl) {
                resultSpec.maxResultCount = 0;
            } else {
                resultSpec.order = RelatedItemsManagerImpl.getOrderingCriteria(constraint.targetType);
            }
            querySpec.resultSpec = resultSpec;
            querySpecArray[n++] = querySpec;
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        return requestSpec;
    }

    private RelatedItemSummary[] transformRelationDataToSummary(Object object, Response response, List<RelationSpec> list, boolean bl, boolean bl2) throws Exception {
        ArrayList<RelatedItemSummary> arrayList = new ArrayList<RelatedItemSummary>();
        int n = 0;
        for (RelationSpec relationSpec : list) {
            if (bl2 && !this._listComponentSpecById.containsKey(relationSpec.listViewId)) {
                _logger.warn((Object)("No list spec found for relation - " + relationSpec.id));
                continue;
            }
            RelatedItemSummary relatedItemSummary = new RelatedItemSummary();
            relatedItemSummary.icon = relationSpec.icon;
            relatedItemSummary.type = relationSpec.targetType;
            relatedItemSummary.label = relationSpec.label;
            relatedItemSummary.relationId = relationSpec.id;
            relatedItemSummary.inverseRelation = relationSpec.inverseRelation;
            if (bl) {
                relatedItemSummary.count = this.extractRelatedItemCount(response, n);
            }
            if (bl2) {
                relatedItemSummary.listSpec = this._listComponentSpecById.get(relationSpec.listViewId);
            }
            arrayList.add(n++, relatedItemSummary);
        }
        return arrayList.toArray(new RelatedItemSummary[0]);
    }

    private List<Map<String, Object>> transformRelationDataToMap(ResultSet resultSet) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        for (ResultItem resultItem : resultSet.items) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            String string = this._objRefService.getUid(resultItem.resourceObject, true);
            hashMap.put(OBJECT_ID, string);
            for (PropertyValue propertyValue : resultItem.properties) {
                hashMap.put(propertyValue.propertyName, propertyValue.value);
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private Integer extractRelatedItemCount(Response response, int n) {
        ResultSet resultSet = response.resultSet[n];
        if (resultSet == null) {
            return null;
        }
        if (resultSet.error != null) {
            _logger.warn((Object)("Error when fetching related items data - " + resultSet.error.getMessage()));
        }
        if (resultSet.totalMatchedObjectCount == null) {
            return null;
        }
        return resultSet.totalMatchedObjectCount;
    }

    private Map<String, Object> getProperties(Object object, String[] stringArray) {
        HashMap<String, Object> hashMap = null;
        try {
            PropertyValue[] propertyValueArray = this._queryExecutor.getProperties(object, stringArray);
            hashMap = new HashMap<String, Object>();
            for (PropertyValue propertyValue : propertyValueArray) {
                hashMap.put(propertyValue.propertyName, propertyValue.value);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when fetching conditional properties.", (Throwable)exception);
        }
        return hashMap;
    }

    private List<RelationSpec> getFilteredRelationSpecs(String string, boolean bl, Map<String, Object> map, String string2) {
        Map<String, Map<String, List<RelationSpec>>> map2 = this._relationSpecsByViewByConditionByType.get(string);
        ArrayList<RelationSpec> arrayList = new ArrayList<RelationSpec>();
        if (map2 == null) {
            return arrayList;
        }
        for (Map.Entry<String, Map<String, List<RelationSpec>>> entry : map2.entrySet()) {
            String string3 = entry.getKey();
            boolean bl2 = false;
            bl2 = string3.equals(NO_CONDITION_KEY) ? true : map != null && this.valueSatisfiesProperty(string3, map.get(this.cleanPropertyName(string3)));
            for (Map.Entry<String, List<RelationSpec>> entry2 : entry.getValue().entrySet()) {
                boolean bl3;
                String string4 = entry2.getKey();
                boolean bl4 = bl3 = string2 == null || string4.equals(string2);
                if (!bl2 || !bl3) continue;
                List<RelationSpec> list = entry2.getValue();
                this.concatenateAndFilterFavorites(arrayList, list, bl);
            }
        }
        return arrayList;
    }

    private String[] getConditionalPropertyNames(String string, boolean bl) {
        Map<String, Map<String, List<RelationSpec>>> map = this._relationSpecsByViewByConditionByType.get(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (map == null) {
            return new String[0];
        }
        for (Map.Entry<String, Map<String, List<RelationSpec>>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            if (string2.equals(NO_CONDITION_KEY)) continue;
            String string3 = this.cleanPropertyName(string2);
            if (bl) {
                for (Map.Entry<String, List<RelationSpec>> entry2 : entry.getValue().entrySet()) {
                    List<RelationSpec> list = entry2.getValue();
                    if (!this.hasFavorites(list)) continue;
                    arrayList.add(string3);
                }
                continue;
            }
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[0]);
    }

    private Constraint getRelatedItemConstraint(RelationSpec relationSpec, Object object) {
        if (relationSpec.constraint != null) {
            return relationSpec.constraint;
        }
        boolean bl = relationSpec.relation != null;
        Constraint constraint = null;
        boolean bl2 = !StringUtil.isNullOrEmpty((String)relationSpec.conditionalProperty);
        PropertyConstraint propertyConstraint = null;
        Constraint constraint2 = null;
        if (bl) {
            constraint2 = constraint = QueryUtil.createConstraintForRelationship((Object)object, (String)relationSpec.relation, (String)relationSpec.targetType);
        }
        if (bl2) {
            String string = relationSpec.conditionalProperty;
            boolean bl3 = true;
            if (relationSpec.conditionalProperty.charAt(0) == '!') {
                bl3 = false;
                string = relationSpec.conditionalProperty.substring(1);
            }
            propertyConstraint = QueryUtil.createPropertyConstraint((String)relationSpec.targetType, (String)string, (Comparator)Comparator.EQUALS, (Object)bl3);
            constraint2 = propertyConstraint;
        }
        if (bl && bl2) {
            constraint2 = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{constraint, propertyConstraint}, (Conjoiner)Conjoiner.AND);
        }
        if (constraint2 != null && constraint2.targetType == null) {
            constraint2.targetType = relationSpec.targetType;
        }
        if (constraint2 == null && relationSpec.targetType != null) {
            constraint2 = new Constraint();
            constraint2.targetType = relationSpec.targetType;
        }
        return constraint2;
    }

    private String cleanPropertyName(String string) {
        if (string.charAt(0) == '!') {
            return string.substring(1);
        }
        return string;
    }

    private boolean hasFavorites(List<RelationSpec> list) {
        for (RelationSpec relationSpec : list) {
            if (!relationSpec.isFavorite) continue;
            return true;
        }
        return false;
    }

    private boolean valueSatisfiesProperty(String string, Object object) {
        if (object == null || !(object instanceof Boolean)) {
            return false;
        }
        Boolean bl = (Boolean)object;
        return bl == (string.charAt(0) != '!');
    }

    private void concatenateAndFilterFavorites(List<RelationSpec> list, List<RelationSpec> list2, boolean bl) {
        for (RelationSpec relationSpec : list2) {
            if (!relationSpec.isFavorite && bl) continue;
            list.add(relationSpec);
        }
    }

    private static OrderingCriteria getOrderingCriteria(String string) {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        orderingPropertySpec.propertyNames = new String[]{"name"};
        orderingPropertySpec.orderingType = SortType.ASCENDING;
        orderingPropertySpec.type = StringUtil.isNullOrEmpty((String)string) ? "Object" : string;
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = new OrderingPropertySpec[]{orderingPropertySpec};
        return orderingCriteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSpecs() {
        try {
            Object object;
            Object object22;
            this._writeLock.lock();
            this._relationSpecsByViewByConditionByType.clear();
            this._listComponentSpecById.clear();
            this._simpleRelationSpecsByType.clear();
            this._objectRelationSetSpecs.clear();
            List list = this._extensionService.getAllExtensionObjects(RELATED_ITEMS_EXT_POINT);
            for (Object object22 : list) {
                this._objectRelationSetSpecs.add((ObjectRelationSetSpec)object22);
                this.processObjectRelationSetSpecForRelationSpecs((ObjectRelationSetSpec)object22);
            }
            List list2 = this._extensionService.getAllExtensionObjects(LIST_EXT_POINT);
            object22 = list2.iterator();
            while (object22.hasNext()) {
                object = (ComponentSpec)object22.next();
                this._listComponentSpecById.put(((ComponentSpec)object).getUid(), (ComponentSpec)object);
            }
            object22 = this._extensionService.getAllExtensionObjects(SIMPLE_RELATED_ITEMS_EXT_POINT);
            object = object22.iterator();
            while (object.hasNext()) {
                ObjectSimpleRelationSetSpec objectSimpleRelationSetSpec = (ObjectSimpleRelationSetSpec)object.next();
                this.addSimpleRelationSpecsToDictionary(objectSimpleRelationSetSpec.type, Arrays.asList(objectSimpleRelationSetSpec.relationSpecs));
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private void processObjectRelationSetSpecForRelationSpecs(ObjectRelationSetSpec objectRelationSetSpec) {
        if (!RelatedItemsManagerImpl.validateRelationSpecs(objectRelationSetSpec)) {
            return;
        }
        Map<String, Map<String, List<RelationSpec>>> map = this._relationSpecsByViewByConditionByType.get(objectRelationSetSpec.type);
        if (map == null) {
            map = new HashMap<String, Map<String, List<RelationSpec>>>();
            this._relationSpecsByViewByConditionByType.put(objectRelationSetSpec.type, map);
        }
        this.processObjectRelationSetSpecByViewByCondition(map, objectRelationSetSpec);
    }

    private void processObjectRelationSetSpecByViewByCondition(Map<String, Map<String, List<RelationSpec>>> map, ObjectRelationSetSpec objectRelationSetSpec) {
        Map<String, List<RelationSpec>> map2;
        String string = objectRelationSetSpec.conditionalProperty;
        if (StringUtil.isNullOrEmpty((String)objectRelationSetSpec.conditionalProperty)) {
            string = NO_CONDITION_KEY;
        }
        if ((map2 = map.get(string)) == null) {
            map2 = new HashMap<String, List<RelationSpec>>();
            map.put(string, map2);
        }
        this.addRelationSpecsByViewToDictionary(map2, objectRelationSetSpec);
    }

    private void addRelationSpecsByViewToDictionary(Map<String, List<RelationSpec>> map, ObjectRelationSetSpec objectRelationSetSpec) {
        List<Object> list;
        if (StringUtil.isNullOrEmpty((String)objectRelationSetSpec.relationsViewId)) {
            _logger.warn((Object)String.format("Skipping processing of ObjectRelationSetSpec for type %s, since relationsViewId is null", objectRelationSetSpec.type));
            return;
        }
        String string = objectRelationSetSpec.relationsViewId.trim();
        if (!map.containsKey(string)) {
            list = new ArrayList();
            map.put(string, list);
        } else {
            list = map.get(string);
        }
        for (RelationSpec relationSpec : objectRelationSetSpec.relationSpecs) {
            if (StringUtil.isNullOrWhitespace((String)relationSpec.id)) continue;
            list.add(relationSpec);
        }
    }

    private void addSimpleRelationSpecsToDictionary(String string, List<RelationSpec> list) {
        List<RelationSpec> list2;
        if (StringUtil.isNullOrEmpty((String)string) || list == null) {
            return;
        }
        if (this._simpleRelationSpecsByType.containsKey(string)) {
            List<RelationSpec> list3 = this._simpleRelationSpecsByType.get(string);
            list2 = new ArrayList<RelationSpec>(list3);
            list2.addAll(list);
        } else {
            list2 = list;
        }
        this._simpleRelationSpecsByType.put(string, list2);
    }

    private static boolean validateRelationSpecs(ObjectRelationSetSpec objectRelationSetSpec) {
        if (objectRelationSetSpec.relationSpecs == null) {
            _logger.error((Object)String.format("Skipping processing of ObjectRelationSetSpec : (%s, %s, %s), since there are not valid RelationSpecs", objectRelationSetSpec.type, objectRelationSetSpec.relationsViewId, objectRelationSetSpec.conditionalProperty));
            return false;
        }
        for (RelationSpec relationSpec : objectRelationSetSpec.relationSpecs) {
            if (StringUtil.isNullOrWhitespace((String)relationSpec.id)) continue;
            return true;
        }
        _logger.error((Object)String.format("Skipping processing of ObjectRelationSetSpec : (%s, %s, %s), since there are not valid RelationSpecs", objectRelationSetSpec.type, objectRelationSetSpec.relationsViewId, objectRelationSetSpec.conditionalProperty));
        return false;
    }

    private static class Property {
        public static final int REGULAR = 1;
        public static final int NEGATED = 2;
        private final String _name;
        private final int _state;

        public Property(String string, int n) {
            this._name = string;
            this._state = n;
        }

        public String getName() {
            return this._name;
        }

        public boolean isNegated() {
            return this._state == 2;
        }
    }
}

