/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.mvc.model.ComponentSpec;
import com.vmware.vise.mvc.model.ObjectTypeSpec;
import com.vmware.vise.mvc.model.ResourceObject;
import com.vmware.vise.mvc.objecttypes.ObjectTypesManager;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.formatter.ISearchableTypeFormatter;
import com.vmware.vise.mvc.search.model.QuickSearchResult;
import com.vmware.vise.mvc.search.model.SearchTypeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class SearchManagerImpl
implements SearchManager {
    private final ObjectReferenceService _objRefService;
    private final ObjectTypesManager _objectTypesManager;
    private final ExtensionService _extensionService;
    private final QueryService _queryService;
    private final ConcurrentMap<String, ISearchableTypeFormatter> _typeFormatters;

    @Autowired
    public SearchManagerImpl(@Qualifier(value="objectReferenceService") ObjectReferenceService objectReferenceService, ObjectTypesManager objectTypesManager, ExtensionService extensionService, QueryServiceFactory queryServiceFactory) {
        this._objRefService = objectReferenceService;
        this._objectTypesManager = objectTypesManager;
        this._extensionService = extensionService;
        this._queryService = queryServiceFactory.getQueryService();
        this._typeFormatters = new ConcurrentHashMap<String, ISearchableTypeFormatter>();
    }

    @Override
    public List<QuickSearchResult> getQuickSearchResults(String string, String string2) throws Exception {
        ResultSet resultSet = this.getData(string, Arrays.asList(QUICK_SEARCH_PROPERTIES), 10, "QuickSearch" + string2);
        return this.formatQuickSearchResults(resultSet);
    }

    @Override
    public List<SearchTypeData> getSimpleSearchResults(String string, String string2) throws Exception {
        ResultSet resultSet = this.getData(string, Collections.emptyList(), 1000, "SimpleSearch" + string2);
        return this.formatSimpleSearchResults(resultSet);
    }

    @Override
    public void registerSearchableTypeFormatter(ISearchableTypeFormatter iSearchableTypeFormatter) {
        if (iSearchableTypeFormatter == null || iSearchableTypeFormatter.getObjectType() == null) {
            throw new IllegalArgumentException("Invalid ISearchableTypeFormatter.");
        }
        this._typeFormatters.put(iSearchableTypeFormatter.getObjectType(), iSearchableTypeFormatter);
    }

    private ResultSet getData(String string, List<String> list, int n, String string2) {
        QueryCommand queryCommand = this._queryService.select(list).from(new String[]{"QuickSearch"}).where("searchTerm", PropertyPredicate.ComparisonOperator.EQUAL, (Object)string).orderBy("@modelKey").limit(n).opId(string2).build();
        return queryCommand.fetch();
    }

    private List<QuickSearchResult> formatQuickSearchResults(ResultSet resultSet) {
        Object object;
        Object object2;
        Object object3;
        String string;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<QuickSearchResult> arrayList = new ArrayList<QuickSearchResult>();
        for (ResourceItem object4 : resultSet.getItems()) {
            string = this._objRefService.getResourceObjectType(object4.getKey());
            if (string == null || this._objectTypesManager.getObjectTypeSpec(string) == null) continue;
            object3 = new ResourceObject();
            object2 = (ISearchableTypeFormatter)this._typeFormatters.get(string);
            if (object2 != null) {
                ((ResourceObject)object3).name = object2.getName(object4);
                ((ResourceObject)object3).type = object2.getRuntimeType(object4);
                ((ResourceObject)object3).id = this._objRefService.getUid(object2.getNavigationEntity(object4));
            } else {
                ((ResourceObject)object3).name = (String)object4.get("name");
                ((ResourceObject)object3).type = string;
                ((ResourceObject)object3).id = this._objRefService.getUid(object4.getKey());
            }
            object = hashMap.containsKey(((ResourceObject)object3).type) ? (List)hashMap.get(((ResourceObject)object3).type) : new ArrayList();
            object.add(object3);
            hashMap.put(((ResourceObject)object3).type, object);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            string = (String)entry.getKey();
            object3 = "";
            object2 = string;
            object = string;
            ObjectTypeSpec objectTypeSpec = this._objectTypesManager.getObjectTypeSpec(string);
            if (objectTypeSpec != null) {
                object2 = objectTypeSpec.labelPlural;
                object = objectTypeSpec.label;
                object3 = objectTypeSpec.icon;
            }
            QuickSearchResult quickSearchResult = new QuickSearchResult();
            quickSearchResult.icon = object3;
            quickSearchResult.labelPlural = object2;
            quickSearchResult.label = object;
            quickSearchResult.results = (List)entry.getValue();
            arrayList.add(quickSearchResult);
        }
        return arrayList;
    }

    private List<SearchTypeData> formatSimpleSearchResults(ResultSet resultSet) throws Exception {
        Object object;
        ArrayList<SearchTypeData> arrayList = new ArrayList<SearchTypeData>();
        HashMap hashMap = new HashMap();
        for (Object object2 : resultSet.getItems()) {
            object = this._objRefService.getResourceObjectType(object2.getKey());
            if (object == null) continue;
            if (!hashMap.containsKey(object)) {
                hashMap.put(object, new HashSet());
            }
            ((Set)hashMap.get(object)).add(this._objRefService.getUid(object2.getKey(), true));
        }
        for (Object object2 : hashMap.keySet()) {
            object = this._objectTypesManager.getObjectTypeSpec((String)object2);
            if (object == null) continue;
            String string = ((ObjectTypeSpec)object).labelPlural;
            String string2 = ((ObjectTypeSpec)object).icon;
            String string3 = ((ObjectTypeSpec)object).listViewId;
            ExtensionInfo extensionInfo = this._extensionService.getExtensionInfo(string3);
            ComponentSpec componentSpec = (ComponentSpec)this._extensionService.getExtensionObject(extensionInfo, null, true);
            SearchTypeData searchTypeData = new SearchTypeData();
            searchTypeData.type = object2;
            searchTypeData.icon = string2;
            searchTypeData.labelPlural = string;
            searchTypeData.listUrl = componentSpec.contentSpec.url;
            searchTypeData.listUid = componentSpec.getUid();
            searchTypeData.listMetadata = componentSpec.contentSpec.metadata;
            searchTypeData.objectUids = ((Set)hashMap.get(object2)).toArray(new String[0]);
            arrayList.add(searchTypeData);
        }
        return arrayList;
    }
}

