/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.formatter;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.ext.ManagedByInfo;
import com.vmware.vise.mvc.search.SearchManager;
import com.vmware.vise.mvc.search.formatter.ISearchableTypeFormatter;
import com.vmware.vise.mvc.util.CommonUtils;

public class VmFormatter
implements ISearchableTypeFormatter {
    private static final String VM_TEMPLATE_TYPE = "VirtualMachineTemplate";
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private static final String PLACEHOLDER_VM = "placeholderVm";

    public VmFormatter(SearchManager searchManager) {
        if (searchManager != null) {
            searchManager.registerSearchableTypeFormatter(this);
        }
    }

    @Override
    public String getObjectType() {
        return VM_TYPE;
    }

    @Override
    public String getName(ResourceItem resourceItem) {
        Object object;
        String string = (String)resourceItem.get("name");
        ManagedByInfo managedByInfo = (ManagedByInfo)resourceItem.get("config/managedBy");
        if (managedByInfo != null && PLACEHOLDER_VM.equals(managedByInfo.getType())) {
            string = CommonUtils.text("placeholderVmFormat", string);
        }
        if ((object = resourceItem.get("config/ftInfo/primaryVM")) != null) {
            string = CommonUtils.text("secondaryVmFormat", string);
        }
        return string;
    }

    @Override
    public String getRuntimeType(ResourceItem resourceItem) {
        Boolean bl = (Boolean)resourceItem.get("config/template");
        if (bl != null && bl.booleanValue()) {
            return VM_TEMPLATE_TYPE;
        }
        return VM_TYPE;
    }

    @Override
    public Object getNavigationEntity(ResourceItem resourceItem) {
        if (resourceItem == null) {
            return null;
        }
        Object object = resourceItem.get("config/ftInfo/primaryVM");
        if (object != null) {
            return object;
        }
        return resourceItem.getKey();
    }
}

