/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.search.util;

import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchUtil {
    private static final String USER_SEARCHABLE_OPTION = "userSearchable";
    private static final String TEXT_SEARCH_TARGET_OPTION = "textSearchTarget";

    public static boolean isUserSearchableDescriptor(Descriptor descriptor) {
        return descriptor.tags != null && descriptor.tags.containsKey(USER_SEARCHABLE_OPTION) && ((String)descriptor.tags.get(USER_SEARCHABLE_OPTION)).equalsIgnoreCase("true");
    }

    public static Map<String, List<String>> getSearchableProperties(List<TypeDescriptor> list, List<PropertyDescriptor> list2) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (TypeDescriptor typeDescriptor : list) {
            if (!SearchUtil.isUserSearchableDescriptor((Descriptor)typeDescriptor)) continue;
            hashMap.put(typeDescriptor.name, new ArrayList());
        }
        for (PropertyDescriptor propertyDescriptor : list2) {
            if (!SearchUtil.isUserSearchableDescriptor((Descriptor)propertyDescriptor) || !propertyDescriptor.valueTypeName.equalsIgnoreCase("string") || !SearchUtil.isTextSearchTargetProperty(propertyDescriptor) || !hashMap.containsKey(propertyDescriptor.providerName)) continue;
            ((List)hashMap.get(propertyDescriptor.providerName)).add(propertyDescriptor.name);
        }
        return hashMap;
    }

    public static boolean isTextSearchTargetProperty(PropertyDescriptor propertyDescriptor) {
        boolean bl = propertyDescriptor.tags == null || !propertyDescriptor.tags.containsKey(TEXT_SEARCH_TARGET_OPTION) || ((String)propertyDescriptor.tags.get(TEXT_SEARCH_TARGET_OPTION)).equalsIgnoreCase("true");
        return bl;
    }
}

