/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.fault.ExtendedFault;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.MutableMessageException;
import com.vmware.vise.data.query.DataException;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionDataContainerMissingException;
import com.vmware.vise.util.session.SessionInvalidatedException;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public class ThrowableSerializer
extends StdSerializer<Throwable> {
    static final String BUNDLE_NAME = "commonmvc";
    static final String PROPERTY_NAME_MESSAGE = "message";
    static final String PROPERTY_UNEXPECTED_STATUS_CODE = "unexpectedStatusCode";
    static final String PROPERTY_LOCALIZED_MESSAGE = "localizedMessage";
    static final String PROPERTY_CAUSE = "cause";
    static final String PROPERTY_FAULT_MESSAGE = "faultMessage";
    static final String PROPERTY_FAULT_CAUSE = "faultCause";
    static final String PROPERTY_SUPPRESSED = "suppressed";
    static final String PROPERTY_STACKTRACE = "stackTrace";
    static final String PROPERTY_TYPE = "_type";
    static final String ERROR_STACK_TRACE_FLAG = "error.stackTrace.show";
    private NotAuthenticatedError _notAuthenticatedError;
    private ConfigurationService _configurationService;
    private final ThreadLocal<Locale> _locale = new ThreadLocal();
    private static final Log _logger = LogFactory.getLog(ThrowableSerializer.class);

    ThrowableSerializer() {
        this(null);
    }

    ThrowableSerializer(Class<Throwable> clazz) {
        super(clazz);
        this._notAuthenticatedError = new NotAuthenticatedError();
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this._configurationService = configurationService;
    }

    public void serialize(Throwable throwable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object object;
        Object object2 = this.getInstanceToSerialize(throwable);
        JavaType javaType = TypeFactory.defaultInstance().constructType(object2.getClass());
        BeanDescription beanDescription = serializerProvider.getConfig().introspect(javaType);
        if (this._locale != null) {
            object = (Locale)SessionUtil.getData((String)"Locale");
            this._locale.set((Locale)object);
        }
        object = this.getObjectPropertyNames(beanDescription, object2);
        Boolean bl = false;
        if (jsonGenerator.getOutputContext().getCurrentIndex() != 0 || jsonGenerator.getOutputContext().inArray()) {
            jsonGenerator.writeStartObject();
            bl = true;
        }
        List list = beanDescription.findProperties();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            BeanPropertyDefinition beanPropertyDefinition = this.getPropertyDefinition(string, list, object2);
            if (beanPropertyDefinition != null) {
                try {
                    Object object3 = beanPropertyDefinition.getGetter() != null ? beanPropertyDefinition.getGetter().callOn(object2) : beanPropertyDefinition.getField().getValue(object2);
                    jsonGenerator.writeObjectField(beanPropertyDefinition.getName(), this.getValue(beanPropertyDefinition.getName(), object3, object2));
                }
                catch (Exception exception) {
                    _logger.warn((Object)("A '" + beanPropertyDefinition.getName() + "' cannot be serialized."));
                }
                continue;
            }
            if (!string.equals(PROPERTY_UNEXPECTED_STATUS_CODE)) continue;
            jsonGenerator.writeFieldName(PROPERTY_UNEXPECTED_STATUS_CODE);
            jsonGenerator.writeNumber(this.getStatusCode(object2));
        }
        if (bl.booleanValue()) {
            jsonGenerator.writeEndObject();
        }
    }

    public void serializeWithType(Throwable throwable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        typeSerializer.writeTypePrefixForObject((Object)throwable, jsonGenerator);
        this.serialize(throwable, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForObject((Object)throwable, jsonGenerator);
    }

    private Object getInstanceToSerialize(Object object) {
        if (object == null || !(object instanceof Throwable)) {
            return object;
        }
        if (Exception.class.getName().equals(object.getClass().getName())) {
            Exception exception = (Exception)object;
            return new MutableMessageException(exception.getMessage());
        }
        Object object2 = object;
        if (ExceptionUtil.isCausedBy((Throwable)((Throwable)object), SessionDataContainerMissingException.class) || ExceptionUtil.isCausedBy((Throwable)((Throwable)object), SessionInvalidatedException.class)) {
            object2 = this._notAuthenticatedError;
        }
        if (MethodFault.class.equals(object.getClass()) && !((object2 = ((Throwable)object).getCause()) instanceof MethodFault) && !(object2 instanceof RuntimeFault)) {
            object2 = object;
        }
        return object2;
    }

    private BeanPropertyDefinition getPropertyDefinition(String string, List<BeanPropertyDefinition> list, Object object) throws IOException {
        BeanPropertyDefinition beanPropertyDefinition = null;
        for (BeanPropertyDefinition beanPropertyDefinition2 : list) {
            if (!string.equals(beanPropertyDefinition2.getName()) || !beanPropertyDefinition2.couldSerialize() || (beanPropertyDefinition2.getGetter() == null || !beanPropertyDefinition2.getGetter().isPublic()) && (beanPropertyDefinition2.getGetter() != null || beanPropertyDefinition2.getField() == null || beanPropertyDefinition2.getField().getValue(object) == null)) continue;
            beanPropertyDefinition = beanPropertyDefinition2;
            break;
        }
        return beanPropertyDefinition;
    }

    private Set<String> getObjectPropertyNames(BeanDescription beanDescription, Object object) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        List list = beanDescription.findProperties();
        for (BeanPropertyDefinition beanPropertyDefinition : list) {
            Boolean bl = beanPropertyDefinition.getGetter() != null && beanPropertyDefinition.getGetter().isPublic();
            Boolean bl2 = beanPropertyDefinition.getGetter() == null && beanPropertyDefinition.getField() != null && beanPropertyDefinition.getField().getValue(object) != null;
            if (!beanPropertyDefinition.couldSerialize() || !bl.booleanValue() && !bl2.booleanValue()) continue;
            hashSet.add(beanPropertyDefinition.getName());
        }
        this.removeStackTracePropertyIfNeeded(hashSet);
        if (object.getClass() == MethodFault.class && !hashSet.contains(PROPERTY_UNEXPECTED_STATUS_CODE)) {
            hashSet.add(PROPERTY_UNEXPECTED_STATUS_CODE);
        }
        return hashSet;
    }

    private Object getValue(String string, Object object, Object object2) throws IOException {
        if (PROPERTY_NAME_MESSAGE.equals(string)) {
            return this.getDetailedFaultMessage(object2);
        }
        if (PROPERTY_LOCALIZED_MESSAGE.equals(string)) {
            return this.getLocalizedFaultMessage(object2);
        }
        if (PROPERTY_UNEXPECTED_STATUS_CODE.equals(string)) {
            return this.getStatusCode(object2);
        }
        return object;
    }

    private int getStatusCode(Object object) throws IOException {
        if (object.getClass() != MethodFault.class) {
            return 0;
        }
        MethodFault methodFault = (MethodFault)object;
        if (!(methodFault.getCause() instanceof UnexpectedStatusCodeException)) {
            return 0;
        }
        UnexpectedStatusCodeException unexpectedStatusCodeException = (UnexpectedStatusCodeException)methodFault.getCause();
        return unexpectedStatusCodeException.getStatusCode();
    }

    private String getLocalizedFaultMessage(Object object) throws IOException {
        String string = null;
        String string2 = null;
        Locale locale = this._locale.get();
        try {
            KeyAnyValue[] keyAnyValueArray = this.constructKeyValuePairs((Throwable)object);
            if (object instanceof ExtendedFault) {
                ExtendedFault extendedFault = (ExtendedFault)object;
                string2 = this.getMessageKey(extendedFault.getFaultTypeId());
                string = locale != null ? this.fillInExtendFaultData(LocalizationUtil.getLocalizedMessageGivenLocale((String)string2, (KeyAnyValue[])keyAnyValueArray, (Locale)locale), extendedFault.getData()) : this.fillInExtendFaultData(LocalizationUtil.getLocalizedMessage((String)string2, (KeyAnyValue[])keyAnyValueArray), extendedFault.getData());
                if (string != null && string.equals(string2)) {
                    string = null;
                }
            } else {
                string2 = this.getMessageKey(object.getClass().getSimpleName());
                string = locale != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)string2, (KeyAnyValue[])keyAnyValueArray, (Locale)locale) : LocalizationUtil.getLocalizedMessage((String)string2, (KeyAnyValue[])keyAnyValueArray);
                if (string == null || string.equals(string2)) {
                    string = this.isServiceNotAvailable((Throwable)object) ? ThrowableSerializer.text("ThrowableProxy.unexpectedStatusCode503") : null;
                }
            }
        }
        catch (NotAuthenticatedError notAuthenticatedError) {
            // empty catch block
        }
        if (StringUtil.isNullOrEmpty(string)) {
            string = ((Throwable)object).getMessage();
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private KeyAnyValue[] constructKeyValuePairs(Throwable throwable) throws IOException {
        Set<String> set = this.getPropertyNames(throwable);
        if (set == null || set.isEmpty()) {
            return null;
        }
        set.remove(PROPERTY_NAME_MESSAGE);
        set.remove(PROPERTY_CAUSE);
        KeyAnyValue[] keyAnyValueArray = new KeyAnyValue[set.size()];
        int n = 0;
        for (String string : set) {
            keyAnyValueArray[n] = ThrowableSerializer.newKeyValue(string, this.getProperty(string, throwable));
            ++n;
        }
        for (KeyAnyValue keyAnyValue : keyAnyValueArray) {
            if (!(keyAnyValue.getValue() instanceof MethodFault)) continue;
            MethodFault methodFault = (MethodFault)keyAnyValue.getValue();
            keyAnyValue.setValue((Object)this.buildMessage((Throwable)methodFault));
        }
        return keyAnyValueArray;
    }

    private Object getProperty(String string, Object object) {
        try {
            Field field = ReflectionUtils.findField(object.getClass(), (String)string);
            ReflectionUtils.makeAccessible((Field)field);
            return ReflectionUtils.getField((Field)field, (Object)object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Set<String> getPropertyNames(Object object) {
        final HashSet<String> hashSet = new HashSet<String>();
        ReflectionUtils.doWithFields(object.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                hashSet.add(field.getName());
            }
        });
        this.removeStackTracePropertyIfNeeded(hashSet);
        if (object.getClass() == MethodFault.class && !hashSet.contains(PROPERTY_UNEXPECTED_STATUS_CODE)) {
            hashSet.add(PROPERTY_UNEXPECTED_STATUS_CODE);
        }
        return hashSet;
    }

    private void removeStackTracePropertyIfNeeded(Set<String> set) {
        String string;
        if (set.contains(PROPERTY_STACKTRACE) && Boolean.parseBoolean(string = this._configurationService.getProperty(ERROR_STACK_TRACE_FLAG))) {
            set.remove(PROPERTY_STACKTRACE);
        }
    }

    private static KeyAnyValue newKeyValue(String string, Object object) {
        KeyAnyValueImpl keyAnyValueImpl = new KeyAnyValueImpl();
        keyAnyValueImpl.setKey(string);
        keyAnyValueImpl.setValue(object);
        return keyAnyValueImpl;
    }

    private String getDetailedFaultMessage(Object object) throws IOException {
        RuntimeFault runtimeFault;
        String string;
        String string2 = this.getPropertyValue(object, PROPERTY_NAME_MESSAGE);
        if (!(object instanceof Throwable)) {
            return string2;
        }
        if (object instanceof CompositeException) {
            CompositeException compositeException = (CompositeException)object;
            String string3 = this.buildCompositeExceptionMessage(compositeException);
            if (!StringUtil.isNullOrEmpty((String)string3)) {
                string2 = string3;
            }
            return string2;
        }
        if (object instanceof DataException) {
            DataException dataException = (DataException)object;
            String string4 = this.buildMessage(dataException.rootCause);
            if (!StringUtil.isNullOrEmpty((String)string4)) {
                string2 = string4;
            }
            return string2;
        }
        if (MethodFault.class.equals(object.getClass())) {
            String string5;
            MethodFault methodFault = (MethodFault)object;
            if (methodFault.getFaultCause() != null && !StringUtil.isNullOrEmpty((String)(string5 = this.buildMessage(methodFault.getFaultCause())))) {
                string2 = string5;
            }
        } else if (object instanceof MethodFault) {
            MethodFault methodFault = (MethodFault)object;
            String string6 = this.buildMessage((Throwable)methodFault);
            if (!StringUtil.isNullOrEmpty((String)string6)) {
                string2 = string6;
            }
        } else if (object instanceof RuntimeFault && !StringUtil.isNullOrEmpty((String)(string = this.buildMessage((Throwable)(runtimeFault = (RuntimeFault)object))))) {
            string2 = string;
        }
        return string2;
    }

    private String getPropertyValue(Object object, String string) {
        try {
            Field field = object.getClass().getField(string);
            return (String)field.get(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.warn((Object)("A '" + string + "' cannot be accessed."));
        }
        return null;
    }

    private String buildCompositeExceptionMessage(CompositeException compositeException) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (Exception exception : compositeException.getExceptions()) {
            if (exception == null) continue;
            this.buildMessage(exception, stringBuilder);
        }
        return stringBuilder.toString().trim();
    }

    private String buildMessage(Throwable throwable) throws IOException {
        return this.buildMessage(throwable, new StringBuilder());
    }

    private String buildMessage(Throwable throwable, StringBuilder stringBuilder) throws IOException {
        Object object;
        if (throwable == null) {
            return stringBuilder.toString();
        }
        String string = this.getLocalizedFaultMessage(throwable = (Throwable)this.getInstanceToSerialize(throwable));
        if (!StringUtil.isNullOrEmpty((String)string)) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        if (throwable instanceof NoPermission) {
            stringBuilder.append(this.getNoPermissionFaultMessage((NoPermission)throwable));
            stringBuilder.append("\n");
        }
        LocalizableMessage[] localizableMessageArray = null;
        Exception exception = null;
        if (throwable instanceof MethodFault) {
            object = (MethodFault)throwable;
            localizableMessageArray = object.getFaultMessage();
            exception = object.getFaultCause();
        } else if (throwable instanceof RuntimeFault) {
            object = (RuntimeFault)throwable;
            localizableMessageArray = object.getFaultMessage();
            exception = object.getFaultCause();
        }
        if (exception == throwable) {
            exception = null;
        }
        if (localizableMessageArray != null) {
            object = this._locale.get();
            for (int i = localizableMessageArray.length - 1; i >= 0; --i) {
                LocalizableMessage localizableMessage;
                String string2;
                String string3 = object != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)string2, (KeyAnyValue[])localizableMessage.getArg(), (Locale)object) : LocalizationUtil.getLocalizedMessage((String)string2, (KeyAnyValue[])localizableMessage.getArg());
                if (string3.equals(string2 = (localizableMessage = localizableMessageArray[i]).getKey())) {
                    string3 = localizableMessage.getMessage();
                }
                String string4 = string3;
                if (StringUtil.isNullOrEmpty((String)string3)) {
                    string4 = !StringUtil.isNullOrEmpty((String)localizableMessage.getMessage()) ? localizableMessage.getMessage() : localizableMessage.getKey();
                }
                if (StringUtil.isNullOrEmpty((String)string4)) continue;
                string4 = string4.trim();
                if (!StringUtil.isNullOrEmpty((String)string) && string.equals(string4)) continue;
                stringBuilder.append(string4);
                stringBuilder.append("\n");
            }
        }
        if (exception != null && !StringUtil.isNullOrEmpty((String)(object = this.buildMessage(exception)))) {
            stringBuilder.append("\n");
            stringBuilder.append(ThrowableSerializer.text("ThrowableProxy.cause"));
            stringBuilder.append("\n");
            stringBuilder.append((String)object);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString().trim();
    }

    private String getNoPermissionFaultMessage(NoPermission noPermission) {
        String string;
        String string2 = noPermission.getPrivilegeId();
        String string3 = this.getPrivilegeText(string2);
        String string4 = "?";
        String string5 = "?";
        ManagedObjectReference managedObjectReference = noPermission.getObject();
        if (managedObjectReference != null) {
            string = managedObjectReference.getType();
            if (string != null) {
                string5 = ManagedObjectUtil.getLocalizedEntityType((String)string);
            } else {
                _logger.warn((Object)("A " + NoPermission.class.getSimpleName() + " fault's moRef contains a null type."));
            }
        }
        string = ThrowableSerializer.text("NoPermission.message.format");
        string = String.format(string, string3, string5, string4);
        return string;
    }

    private String getPrivilegeText(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return "?";
        }
        Locale locale = this._locale.get();
        String[] stringArray = string.split("\\.");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < i + 1; ++j) {
                if ((n = string.indexOf(".", n + 1)) != -1) continue;
                n = string.length();
                break;
            }
            String string2 = string.substring(0, n);
            String string3 = String.format("privilege.%s.label", string2);
            String string4 = locale != null ? LocalizationUtil.getLocalizedMessageGivenLocale((String)string3, null, (Locale)locale) : LocalizationUtil.getLocalizedMessage((String)string3, null);
            if (string4 != null && !string4.equals(string3)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" > ");
                }
                stringBuffer.append(string4);
                continue;
            }
            _logger.warn((Object)("Unable to localize key '" + string3 + "'"));
        }
        return stringBuffer.toString();
    }

    private boolean isServiceNotAvailable(Throwable throwable) throws IOException {
        if (throwable instanceof UnexpectedStatusCodeException) {
            UnexpectedStatusCodeException unexpectedStatusCodeException = (UnexpectedStatusCodeException)throwable;
            return unexpectedStatusCodeException.getStatusCode() == 503;
        }
        return false;
    }

    private String fillInExtendFaultData(String string, KeyValue[] keyValueArray) {
        int n;
        String string2 = string;
        int n2 = string2.indexOf("[data.");
        if (n2 == -1 || keyValueArray == null || keyValueArray.length == 0) {
            return string2;
        }
        while ((n = string2.indexOf("]", n2 + 6)) != -1) {
            String string3 = string2.substring(n2 + 6, n);
            String string4 = null;
            for (KeyValue keyValue : keyValueArray) {
                if (!string3.equals(keyValue.getKey())) continue;
                string4 = this.escapeOpenBrace(keyValue.getValue());
                break;
            }
            if (string4 == null) {
                _logger.warn((Object)("FormatExtensionFaultData: Unable to substitute " + string3));
                string4 = String.format("<%s>", ThrowableSerializer.text("ThrowableProxy.propertyUnset"));
            }
            string2 = string2.substring(0, n2) + string4 + string2.substring(n + 1);
            n2 += string4.length() + 1;
            if ((n2 = string2.indexOf("[data.", n2 + 1)) != -1) continue;
        }
        return string2;
    }

    private String escapeOpenBrace(String string) {
        int n = string.indexOf(123);
        if (n == -1) {
            return string;
        }
        String string2 = "";
        int n2 = 0;
        do {
            string2 = string2 + string.substring(n2, n + 1) + "{";
        } while ((n = string.indexOf(123, n2 = n + 1)) != -1);
        string2 = string2 + string.substring(n2);
        return string2;
    }

    private String getMessageKey(String string) {
        return String.format("%s.summary", string);
    }

    private static String text(String string) {
        return ResourceUtil.getString((String)BUNDLE_NAME, (String)string, (ClassLoader)ThrowableSerializer.class.getClassLoader());
    }
}

