/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tasks;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;

public class TaskQueryUtil {
    public static final String TASK_TYPE_NAME = "Task";
    public static final String MANAGED_ENTITY = "ManagedEntity";

    public static QuerySpec createTaskQuerySpec(Object object, boolean bl, boolean bl2, String[] stringArray, String string, int n, int n2) {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = n;
        CompositeConstraint compositeConstraint = TaskQueryUtil.createTaskSearchConstraint(object, bl, bl2, stringArray, string, n2);
        compositeConstraint.targetType = TASK_TYPE_NAME;
        resourceSpec.constraint = compositeConstraint;
        propertySpec.propertyNames = new String[1];
        propertySpec.propertyNames[0] = "info";
        propertySpec.type = MANAGED_ENTITY;
        resourceSpec.propertySpecs = new PropertySpec[1];
        resourceSpec.propertySpecs[0] = propertySpec;
        querySpec.name = "vsphere:Task-info";
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    public static CompositeConstraint createTaskSearchConstraint(Object object, boolean bl, boolean bl2, String[] stringArray, String string, Integer n) {
        PropertyConstraint propertyConstraint;
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>();
        compositeConstraint.conjoiner = Conjoiner.AND;
        compositeConstraint.targetType = "vsphere:Task";
        if (bl2) {
            propertyConstraint = TaskQueryUtil.createPropertyConstraint("info.recentTasks", bl2, null);
            arrayList.add((Constraint)propertyConstraint);
        }
        if (object != null) {
            propertyConstraint = TaskQueryUtil.createPropertyConstraint("info.entity", object, null);
            arrayList.add((Constraint)propertyConstraint);
        }
        if (bl) {
            propertyConstraint = TaskQueryUtil.createPropertyConstraint("info.activeTasks", bl, null);
            arrayList.add((Constraint)propertyConstraint);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])stringArray)) {
            propertyConstraint = TaskQueryUtil.createPropertyConstraint("info.rootTasks", stringArray, null);
            arrayList.add((Constraint)propertyConstraint);
        }
        if (!StringUtil.isNullOrEmpty((String)string)) {
            TaskQueryUtil.applyUserName(arrayList, string);
        }
        if (n != null) {
            propertyConstraint = TaskQueryUtil.createPropertyConstraint("info.currentPage", n, null);
            arrayList.add((Constraint)propertyConstraint);
        }
        compositeConstraint.nestedConstraints = arrayList.toArray(new Constraint[arrayList.size()]);
        return compositeConstraint;
    }

    public static PropertyConstraint createPropertyConstraint(String string, Object object, String string2) {
        if (string2 == null) {
            string2 = "vsphere:Task";
        }
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.propertyName = string;
        propertyConstraint.comparableValue = object;
        propertyConstraint.targetType = string2;
        propertyConstraint.comparator = Comparator.EQUALS;
        return propertyConstraint;
    }

    private static void applyUserName(ArrayList<Constraint> arrayList, String string) {
    }
}

