/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.vise.mvc.tree.NodeRoute;
import com.vmware.vise.mvc.tree.Tree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InverseTree {
    Tree _tree;
    Map<String, List<NodeRoute>> _typeRoutes = new HashMap<String, List<NodeRoute>>();
    Set<String> _selfChaining = new HashSet<String>();

    InverseTree(Tree tree) {
        this._tree = tree;
    }

    public Tree getRealTree() {
        return this._tree;
    }

    void addRoute(String string, NodeRoute nodeRoute) {
        List<NodeRoute> list = this._typeRoutes.get(string);
        if (list == null) {
            list = new ArrayList<NodeRoute>();
            this._typeRoutes.put(string, list);
        }
        boolean bl = true;
        for (int i = 0; i < list.size(); ++i) {
            NodeRoute nodeRoute2 = list.get(i);
            if (!this.removeSelfChaining(nodeRoute2).equals(this.removeSelfChaining(nodeRoute))) continue;
            if (nodeRoute2.size() < nodeRoute.size()) {
                list.set(i, nodeRoute);
            }
            bl = false;
            break;
        }
        if (bl) {
            list.add(nodeRoute);
        }
    }

    List<NodeRoute> getRoutes(String string) {
        List<NodeRoute> list = this._typeRoutes.get(string);
        return list != null ? list : Collections.emptyList();
    }

    void addSelfChaining(String string) {
        this._selfChaining.add(string);
    }

    boolean isSelfChaining(String string) {
        return this._selfChaining.contains(string);
    }

    private NodeRoute removeSelfChaining(NodeRoute nodeRoute) {
        NodeRoute nodeRoute2 = new NodeRoute();
        for (String string : nodeRoute) {
            if (this.isSelfChaining(string)) continue;
            nodeRoute2.add(string);
        }
        return nodeRoute2;
    }
}

