/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.mvc.tree.Tree;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeList;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeList {
    private static final Log _logger = LogFactory.getLog(TreeList.class);
    private final Map<String, Tree> _treeListMap = new HashMap<String, Tree>();
    private static Map<String, Set<String>> _treeNavIdToSupportedTypes = null;
    private static Map<String, String> _treeIdToNavId = new HashMap<String, String>();
    private static final List<String> _navTreeIds;

    public TreeList() {
        this.buildTreeListMap();
        TreeList.buildTreeIdToSupportedTypesMap();
    }

    Tree getTree(String string) {
        return this._treeListMap.get(string);
    }

    boolean isNavigationalTree(String string) {
        Validate.notEmpty((String)string);
        return _navTreeIds.contains(string);
    }

    boolean isSubsetOfNavigationalTree(String string) {
        Validate.notEmpty((String)string);
        return this.getParentInventoryTreeId(string) != null;
    }

    String getParentInventoryTreeId(String string) {
        Validate.notEmpty((String)string);
        Tree tree = this._treeListMap.get(string);
        if (tree != null) {
            return tree.getParentNavTreeId();
        }
        return null;
    }

    public static String getAssociatedTreeIdForObject(String string, String string2, ObjectReferenceService objectReferenceService, QueryService queryService) {
        ResourceItem resourceItem;
        String string3;
        Object object = objectReferenceService.getReference(string, true);
        String string4 = objectReferenceService.getResourceObjectType(object);
        if (object instanceof ManagedObjectReference && ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)object), VirtualMachine.class) && !(string3 = queryService.select(new String[]{"parent", "config.template"}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object).fetch()).getItems().isEmpty()) {
            resourceItem = (ResourceItem)string3.getItems().get(0);
            ResourceItem resourceItem2 = (ManagedObjectReference)resourceItem.get("parent");
            if (Boolean.TRUE.equals(resourceItem.get("config.template"))) {
                return "vsphere.core.viTree.vmsAndTemplatesView";
            }
            if (resourceItem2 == null) {
                return "vsphere.core.viTree.hostsAndClustersView";
            }
        }
        if ((string3 = TreeList.getFolderType(object, string4)) != null) {
            string4 = string3;
        }
        if (_treeNavIdToSupportedTypes.containsKey(string2) && (resourceItem = _treeNavIdToSupportedTypes.get(string2)).contains(string4)) {
            return string2;
        }
        if (string4.equals(TreeManager.TARGET_VIRTUALMACHINE) || string4.equals(TreeManager.TARGET_VIRTUALAPP)) {
            return "vsphere.core.viTree.vmsAndTemplatesView";
        }
        for (ResourceItem resourceItem3 : resourceItem = new ResourceItem[]{"vsphere.core.viTree.hostsAndClustersView", "vsphere.core.viTree.vmsAndTemplatesView", "vsphere.core.viTree.storageView", "vsphere.core.viTree.networkingView"}) {
            Set<String> set = _treeNavIdToSupportedTypes.get(resourceItem3);
            if (!set.contains(string4)) continue;
            return resourceItem3;
        }
        return null;
    }

    List<String> getSupportedTypes(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return Collections.emptyList();
        }
        if (!_treeIdToNavId.containsKey(string)) {
            return Collections.emptyList();
        }
        String string2 = _treeIdToNavId.get(string);
        if (!_treeNavIdToSupportedTypes.containsKey(string2)) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(_treeNavIdToSupportedTypes.get(string2));
        return Collections.unmodifiableList(arrayList);
    }

    private static String getFolderType(Object object, String string) {
        if (object instanceof ManagedObjectReference && string.equals(TreeManager.TARGET_FOLDER)) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
                return "rootFolder";
            }
            if (ManagedObjectUtil.isDatacenterFolder((ManagedObjectReference)managedObjectReference)) {
                return "datacenterFolder";
            }
            if (ManagedObjectUtil.isHostFolder((ManagedObjectReference)managedObjectReference)) {
                return "hostFolder";
            }
            if (ManagedObjectUtil.isVmFolder((ManagedObjectReference)managedObjectReference)) {
                return "vmFolder";
            }
            if (ManagedObjectUtil.isNetworkFolder((ManagedObjectReference)managedObjectReference)) {
                return "networkFolder";
            }
            if (ManagedObjectUtil.isStorageFolder((ManagedObjectReference)managedObjectReference)) {
                return "storageFolder";
            }
        }
        return null;
    }

    private static void buildTreeIdToSupportedTypesMap() {
        if (_treeNavIdToSupportedTypes != null) {
            return;
        }
        _treeNavIdToSupportedTypes = new HashMap<String, Set<String>>();
        String[] stringArray = new String[]{TreeManager.TARGET_FOLDER, TreeManager.TARGET_DATACENTER, TreeManager.TARGET_COMPUTERESOURCE, TreeManager.TARGET_CLUSTERCOMPUTERESOURCE, TreeManager.TARGET_HOSTSYSTEM, TreeManager.TARGET_RESOURCEPOOL, TreeManager.TARGET_VIRTUALAPP, TreeManager.TARGET_VIRTUALMACHINE, "rootFolder", "datacenterFolder", "hostFolder"};
        String[] stringArray2 = new String[]{TreeManager.TARGET_FOLDER, TreeManager.TARGET_DATACENTER, TreeManager.TARGET_VIRTUALAPP, TreeManager.TARGET_VIRTUALMACHINE, "rootFolder", "datacenterFolder", "vmFolder"};
        String[] stringArray3 = new String[]{TreeManager.TARGET_FOLDER, TreeManager.TARGET_DATACENTER, TreeManager.TARGET_DATASTORE, TreeManager.TARGET_STORAGEPOD, "rootFolder", "datacenterFolder", "storageFolder"};
        String[] stringArray4 = new String[]{TreeManager.TARGET_FOLDER, TreeManager.TARGET_DATACENTER, TreeManager.TARGET_DISTRIBUTEDVIRTUALPORTGROUP, TreeManager.TARGET_DISTRIBUTEDVIRTUALSWITCH, TreeManager.TARGET_NETWORK, TreeManager.TARGET_OPAQUENETWORK, TreeManager.TARGET_VMWAREDISTRIBUTEDVIRTUALSWITCH, "rootFolder", "datacenterFolder", "networkFolder"};
        _treeNavIdToSupportedTypes.put("vsphere.core.viTree.hostsAndClustersView", new HashSet<String>(Arrays.asList(stringArray)));
        _treeNavIdToSupportedTypes.put("vsphere.core.viTree.vmsAndTemplatesView", new HashSet<String>(Arrays.asList(stringArray2)));
        _treeNavIdToSupportedTypes.put("vsphere.core.viTree.storageView", new HashSet<String>(Arrays.asList(stringArray3)));
        _treeNavIdToSupportedTypes.put("vsphere.core.viTree.networkingView", new HashSet<String>(Arrays.asList(stringArray4)));
    }

    private void buildTreeListMap() {
        Class<?>[] classArray;
        for (Class<?> clazz : classArray = TreeList.class.getDeclaredClasses()) {
            if (!Tree.class.isAssignableFrom(clazz)) continue;
            try {
                Tree tree = (Tree)clazz.newInstance();
                this._treeListMap.put(tree.getId(), tree);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                _logger.error((Object)"Cannot intstantiate a tree definition", (Throwable)reflectiveOperationException);
            }
        }
    }

    static {
        _treeIdToNavId.put("vsphere.core.physicalInventorySpec", "vsphere.core.viTree.hostsAndClustersView");
        _treeIdToNavId.put("vsphere.core.virtualInventorySpec", "vsphere.core.viTree.vmsAndTemplatesView");
        _treeIdToNavId.put("vsphere.core.storageInventorySpec", "vsphere.core.viTree.storageView");
        _treeIdToNavId.put("vsphere.core.networkingInventorySpec", "vsphere.core.viTree.networkingView");
        _navTreeIds = new ArrayList<String>(Arrays.asList("vsphere.core.physicalInventorySpec", "vsphere.core.virtualInventorySpec", "vsphere.core.storageInventorySpec", "vsphere.core.networkingInventorySpec"));
    }

    static class MoveResourcePoolsFromSaHostTree
    extends Tree {
        MoveResourcePoolsFromSaHostTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.rpSaHost.moveInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RpParentSaHostRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.StandaloneHostResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.StandaloneHostResPool.class.getSimpleName()));
        }
    }

    static class MoveResourcePoolsFromClusterTree
    extends Tree {
        MoveResourcePoolsFromClusterTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.rpCluster.moveInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RpParentClusterRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.ClusterResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.ClusterResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
        }
    }

    static class ResourcePoolsAndVappsOnlyTree
    extends Tree {
        ResourcePoolsAndVappsOnlyTree() {
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefOrVcAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName(), TreeNodeList.ClusterResPool.class.getSimpleName(), TreeNodeList.StandaloneHostResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.ClusterResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStandaloneHost.class.getSimpleName(), new String[]{TreeNodeList.StandaloneHostResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStandaloneHost.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ClusterResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
        }
    }

    static class VmTemplatesOnlyTree
    extends Tree {
        VmTemplatesOnlyTree() {
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcVmFolder.class.getSimpleName(), TreeNodeList.DcVmTemplate.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcVmFolder.class.getSimpleName(), new String[]{TreeNodeList.VmFolderVmFolder.class.getSimpleName(), TreeNodeList.VmFolderVmTemplate.class.getSimpleName()});
            this.nodes.put(TreeNodeList.VmFolderVmFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcVmFolder.class.getSimpleName()));
        }
    }

    static class MoveDvsToTree
    extends Tree {
        MoveDvsToTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.dvs.moveInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.DcDvsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcNetworkFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcNetworkFolder.class.getSimpleName(), new String[]{TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName(), new String[]{TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName()});
        }
    }

    static class MoveNetworksToTree
    extends Tree {
        MoveNetworksToTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.network.moveInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.DcNetworkRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcNetworkFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcNetworkFolder.class.getSimpleName(), new String[]{TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName(), new String[]{TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName()});
        }
    }

    static class MoveDatastoreToTree
    extends Tree {
        MoveDatastoreToTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.datastore.moveInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.DcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcDatastoreFolder.class.getSimpleName(), TreeNodeList.DcStoragepod.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcDatastoreFolder.class.getSimpleName(), new String[]{TreeNodeList.DatastoreFolderDatastoreFolder.class.getSimpleName(), TreeNodeList.DatastoreFolderStoragepod.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatastoreFolderDatastoreFolder.class.getSimpleName(), new String[]{TreeNodeList.DatastoreFolderDatastoreFolder.class.getSimpleName(), TreeNodeList.DatastoreFolderStoragepod.class.getSimpleName()});
        }
    }

    static class MoveHostToTree
    extends Tree {
        MoveHostToTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.host.moveInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefOrVcAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[0]);
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
        }
    }

    static class DvsInventoryTree
    extends Tree {
        DvsInventoryTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.dvsInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcNetworkFolder.class.getSimpleName(), TreeNodeList.DcDvs.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcNetworkFolder.class.getSimpleName(), new String[]{TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName(), TreeNodeList.NetworkFolderDvs.class.getSimpleName()});
            this.nodes.put(TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcNetworkFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.NetworkFolderDvs.class.getSimpleName(), this.nodes.get(TreeNodeList.DcDvs.class.getSimpleName()));
        }
    }

    static class InvNetworkingTree
    extends Tree {
        InvNetworkingTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.networkingInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcNetworkFolder.class.getSimpleName(), TreeNodeList.DcNetwork.class.getSimpleName(), TreeNodeList.DcOpaqueNetwork.class.getSimpleName(), TreeNodeList.DcDvs.class.getSimpleName(), TreeNodeList.DcDvpg.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcNetworkFolder.class.getSimpleName(), new String[]{TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName(), TreeNodeList.NetworkFolderNetwork.class.getSimpleName(), TreeNodeList.NetworkFolderOpaqueNetwork.class.getSimpleName(), TreeNodeList.NetworkFolderDvs.class.getSimpleName(), TreeNodeList.NetworkFolderDvpg.class.getSimpleName()});
            this.nodes.put(TreeNodeList.NetworkFolderNetworkFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcNetworkFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcDvs.class.getSimpleName(), new String[]{TreeNodeList.DvsDvpg.class.getSimpleName()});
            this.nodes.put(TreeNodeList.NetworkFolderDvs.class.getSimpleName(), this.nodes.get(TreeNodeList.DcDvs.class.getSimpleName()));
        }
    }

    static class InvDataStorageTree
    extends Tree {
        InvDataStorageTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.storageInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcDatastoreFolder.class.getSimpleName(), TreeNodeList.DcStoragepod.class.getSimpleName(), TreeNodeList.DcDatastore.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcDatastoreFolder.class.getSimpleName(), new String[]{TreeNodeList.DatastoreFolderDatastoreFolder.class.getSimpleName(), TreeNodeList.DatastoreFolderStoragepod.class.getSimpleName(), TreeNodeList.DatastoreFolderDatastore.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatastoreFolderDatastoreFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcDatastoreFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStoragepod.class.getSimpleName(), new String[]{TreeNodeList.StoragepodDatastore.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatastoreFolderStoragepod.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStoragepod.class.getSimpleName()));
        }
    }

    static class MigrateHostsAndClustersTree
    extends ComputeResourceSelectionTree {
        MigrateHostsAndClustersTree() {
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.MigrateVMClusterHostSystem.class.getSimpleName(), TreeNodeList.ClusterResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStandaloneHost.class.getSimpleName(), new String[]{TreeNodeList.StandaloneHostResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStandaloneHost.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ClusterResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
        }
    }

    static class ComputeResourceSelectionTree
    extends Tree {
        ComputeResourceSelectionTree() {
        }

        @Override
        public String getParentNavTreeId() {
            return "vsphere.core.physicalInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefOrVcAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.ClusterHostSystem.class.getSimpleName(), TreeNodeList.ClusterResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStandaloneHost.class.getSimpleName(), new String[]{TreeNodeList.StandaloneHostResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStandaloneHost.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ClusterResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
        }
    }

    static class DcClusterAndHostOnlyTree
    extends Tree {
        DcClusterAndHostOnlyTree() {
        }

        @Override
        public String getParentNavTreeId() {
            return "vsphere.core.physicalInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.ClusterHostSystem.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
        }
    }

    static class DcClusterHostAndRpTree
    extends Tree {
        DcClusterHostAndRpTree() {
        }

        @Override
        public String getParentNavTreeId() {
            return "vsphere.core.physicalInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.ClusterHostSystem.class.getSimpleName(), TreeNodeList.ClusterResPoolNoVapp.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStandaloneHost.class.getSimpleName(), new String[]{TreeNodeList.StandaloneHostResPoolNoVapp.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStandaloneHost.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ClusterResPoolNoVapp.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPoolNoVapp.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPoolNoVapp.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPoolNoVapp.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ResPoolResPoolNoVapp.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPoolNoVapp.class.getSimpleName()));
        }
    }

    static class DcHostsAndClustersTree
    extends Tree {
        DcHostsAndClustersTree() {
        }

        @Override
        public String getParentNavTreeId() {
            return "vsphere.core.physicalInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.ClusterHostSystem.class.getSimpleName(), TreeNodeList.ClusterResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStandaloneHost.class.getSimpleName(), new String[]{TreeNodeList.StandaloneHostResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStandaloneHost.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ClusterResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
        }
    }

    static class VmFoldersTreeFromDatacenter
    extends Tree {
        VmFoldersTreeFromDatacenter() {
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DcVmFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcVmFolder.class.getSimpleName(), new String[]{TreeNodeList.VmFolderVmFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.VmFolderVmFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcVmFolder.class.getSimpleName()));
        }
    }

    static class VmFoldersTree
    extends Tree {
        VmFoldersTree() {
        }

        @Override
        public String getParentNavTreeId() {
            return "vsphere.core.virtualInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.RefOrVcAsRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcVmFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcVmFolder.class.getSimpleName(), new String[]{TreeNodeList.VmFolderVmFolder.class.getSimpleName()});
            this.nodes.put(TreeNodeList.VmFolderVmFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcVmFolder.class.getSimpleName()));
        }
    }

    static class VmOnlyTree
    extends Tree {
        VmOnlyTree() {
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcVmFolder.class.getSimpleName(), TreeNodeList.DcVm.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcVmFolder.class.getSimpleName(), new String[]{TreeNodeList.VmFolderVmFolder.class.getSimpleName(), TreeNodeList.VmFolderVm.class.getSimpleName()});
            this.nodes.put(TreeNodeList.VmFolderVmFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcVmFolder.class.getSimpleName()));
        }
    }

    static class VmAndTemplatesTree
    extends Tree {
        VmAndTemplatesTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.virtualInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcVmFolder.class.getSimpleName(), TreeNodeList.DcVApp.class.getSimpleName(), TreeNodeList.DcVm.class.getSimpleName(), TreeNodeList.DcVmTemplate.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcVmFolder.class.getSimpleName(), new String[]{TreeNodeList.VmFolderVmFolder.class.getSimpleName(), TreeNodeList.VmFolderVApp.class.getSimpleName(), TreeNodeList.VmFolderVm.class.getSimpleName(), TreeNodeList.VmFolderVmTemplate.class.getSimpleName()});
            this.nodes.put(TreeNodeList.VmFolderVmFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcVmFolder.class.getSimpleName()));
        }
    }

    static class HostsAndClustersTree
    extends Tree {
        HostsAndClustersTree() {
        }

        @Override
        public String getId() {
            return "vsphere.core.physicalInventorySpec";
        }

        @Override
        protected void buildRoot() {
            this.root = TreeNodeList.VcRoot.class.getSimpleName();
        }

        @Override
        protected void buildNodes() {
            this.nodes.put(this.root, new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DatacenterFolder.class.getSimpleName(), new String[]{TreeNodeList.DatacenterFolder.class.getSimpleName(), TreeNodeList.Datacenter.class.getSimpleName()});
            this.nodes.put(TreeNodeList.Datacenter.class.getSimpleName(), new String[]{TreeNodeList.DcCompResFolder.class.getSimpleName(), TreeNodeList.DcCluster.class.getSimpleName(), TreeNodeList.DcStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.DcCompResFolder.class.getSimpleName(), new String[]{TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), TreeNodeList.CompResFolderCluster.class.getSimpleName(), TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCompResFolder.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCompResFolder.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcCluster.class.getSimpleName(), new String[]{TreeNodeList.ClusterHostSystem.class.getSimpleName(), TreeNodeList.ClusterResPool.class.getSimpleName(), TreeNodeList.ClusterVm.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderCluster.class.getSimpleName(), this.nodes.get(TreeNodeList.DcCluster.class.getSimpleName()));
            this.nodes.put(TreeNodeList.DcStandaloneHost.class.getSimpleName(), new String[]{TreeNodeList.StandaloneHostResPool.class.getSimpleName(), TreeNodeList.StandaloneHostVm.class.getSimpleName()});
            this.nodes.put(TreeNodeList.CompResFolderStandaloneHost.class.getSimpleName(), this.nodes.get(TreeNodeList.DcStandaloneHost.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ClusterResPool.class.getSimpleName(), new String[]{TreeNodeList.ResPoolResPool.class.getSimpleName(), TreeNodeList.ResPoolVm.class.getSimpleName()});
            this.nodes.put(TreeNodeList.StandaloneHostResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
            this.nodes.put(TreeNodeList.ResPoolResPool.class.getSimpleName(), this.nodes.get(TreeNodeList.ClusterResPool.class.getSimpleName()));
        }
    }
}

