/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.tree;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.mvc.tree.Tree;
import com.vmware.vise.mvc.tree.TreeList;
import com.vmware.vise.mvc.tree.TreeManager;
import com.vmware.vise.mvc.tree.TreeNodeItem;
import com.vmware.vise.mvc.tree.TreeNodeList;
import com.vmware.vise.mvc.tree.TreeNodeSpec;
import com.vmware.vise.mvc.tree.TreePath;
import com.vmware.vise.mvc.tree.TreePathHelper;
import com.vmware.vise.mvc.util.CommonUtils;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TreeManagerImpl
implements TreeManager {
    private static final Log _logger = LogFactory.getLog(TreeManagerImpl.class);
    private static final List<String> OBJECT_PROPERTIES = new ArrayList<String>(){
        {
            this.add("name");
            this.add("labelIds");
            this.add("primaryIconId");
            this.add("@modelKey");
        }
    };
    private static final List<String> VM_PROPERTIES = new ArrayList<String>(){
        {
            this.add("name");
            this.add("labelIds");
            this.add("primaryIconId");
            this.add("config.template");
            this.add("@modelKey");
        }
    };
    private final ObjectReferenceService _objRefService;
    private final DataService _dataService;
    private final I18nManager _i18nManager;
    private final TreeList _treeList;
    private final TreeNodeList _treeNodeList;
    private final TreePathHelper _treePathHelper;
    private final QueryService _queryService;
    private boolean _multiAZFeatureEnabled = false;

    @Autowired
    public TreeManagerImpl(ObjectReferenceService objectReferenceService, DataService dataService, I18nManager i18nManager, TreeList treeList, TreeNodeList treeNodeList, TreePathHelper treePathHelper, QueryServiceFactory queryServiceFactory, FeatureStateService featureStateService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectReferenceService, dataService, i18nManager, treeList, treeNodeList, treePathHelper});
        this._objRefService = objectReferenceService;
        this._dataService = dataService;
        this._i18nManager = i18nManager;
        this._treeList = treeList;
        this._treeNodeList = treeNodeList;
        this._treePathHelper = treePathHelper;
        this._queryService = queryServiceFactory.getQueryService();
        this._multiAZFeatureEnabled = featureStateService.isEnabled(Feature.UI_Multi_AZ);
    }

    @Override
    public List<TreeNodeItem> getRoot(String string, String string2) {
        Tree tree = this._treeList.getTree(string);
        if (tree == null) {
            throw new IllegalStateException("No such tree declared: " + string);
        }
        TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(tree.getRoot());
        if (treeNodeSpec == null) {
            throw new IllegalStateException("No such treeNodeSpec declared");
        }
        if (this.isTreeWithVcRoot(tree.getRoot(), string2)) {
            return this.getVcRoot(treeNodeSpec.getId());
        }
        Object object = null;
        if (!StringUtil.isNullOrEmpty((String)string2) && (object = this._objRefService.getReference(string2, true)) == null) {
            _logger.warn((Object)String.format("No root reference found: [treeId=%s, objectId=%s]", string, string2));
        }
        QuerySpec[] querySpecArray = new QuerySpec[]{treeNodeSpec.getQuerySpec(object)};
        Response response = this.retrieveDataFromDs(querySpecArray);
        List<TreeNodeItem> list = this.formatResult(tree, response);
        return list;
    }

    @Override
    public List<TreeNodeItem> getChildren(String string, String string2, String string3) {
        Tree tree = this._treeList.getTree(string);
        if (tree == null) {
            throw new IllegalStateException("No such tree declared");
        }
        String[] stringArray = tree.getChildren(string2);
        if (stringArray == null) {
            _logger.info((Object)String.format("No children for tree:[%s] and nodeType:[%s]", string, string2));
            return new ArrayList<TreeNodeItem>();
        }
        ArrayList<QuerySpec> arrayList = new ArrayList<QuerySpec>();
        Object object = this._objRefService.getReference(string3, true);
        if (object == null) {
            _logger.warn((Object)String.format("Possibly unexpected null MOR of the parent: [treeId=%s, nodeId=%s, parentRef=%s]", string, string2, string3));
        }
        for (String string4 : stringArray) {
            TreeNodeSpec treeNodeSpec = this._treeNodeList.getTreeNodeSpec(string4);
            if (treeNodeSpec == null) {
                throw new IllegalStateException("No such treeNodeSpec declared");
            }
            arrayList.add(treeNodeSpec.getQuerySpec(object));
        }
        String[] stringArray2 = arrayList.toArray(new QuerySpec[arrayList.size()]);
        Response response = this.retrieveDataFromDs((QuerySpec[])stringArray2);
        List<TreeNodeItem> list = this.formatResult(tree, response);
        return list;
    }

    @Override
    public TreePath getPath(String string, String string2, String string3, String string4) {
        Object object;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, string3});
        Object object2 = this._objRefService.getReference(string3, true);
        Object object3 = null;
        if (string2 == null) {
            if (this.isOptimizedPathToRootAvailable(object2, string)) {
                object3 = this.getOptimizedRootRef(object2);
            } else {
                object = this.getRoot(string, null);
                String string5 = this._objRefService.getServerGuid(object2);
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    TreeNodeItem treeNodeItem = (TreeNodeItem)object4.next();
                    Object object5 = this._objRefService.getReference(treeNodeItem.objRef, true);
                    if (string5 == null || !string5.equals(this._objRefService.getServerGuid(object5))) continue;
                    object3 = object5;
                    break;
                }
                if (object3 == null) {
                    _logger.info((Object)String.format("No root items for tree:[%s]", string));
                    object4 = new TreePath();
                    ((TreePath)object4).options = string4;
                    ((TreePath)object4).paths = Collections.emptyList();
                    return object4;
                }
            }
        } else {
            object3 = this._objRefService.getReference(string2, true);
        }
        object = this._treePathHelper.findPaths(string, object3, object2, string4);
        return object;
    }

    @Override
    public Map<String, Map<String, Object>> getPropertiesByObjectIds(List<String> list) {
        List<String> list2;
        HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
        if (ArrayUtil.isNullOrEmpty(list)) {
            return hashMap;
        }
        HashMap hashMap2 = new HashMap(list.size());
        for (String object : list) {
            Object object2 = this._objRefService.getReference(object, true);
            if (object2 == null || (list2 = this._objRefService.getResourceObjectType(object2)) == null) continue;
            if (!hashMap2.containsKey(list2)) {
                hashMap2.put(list2, new ArrayList());
            }
            ((List)hashMap2.get(list2)).add(object2);
        }
        String string = "TreeManagerImpl.getPropertiesByObjectIds";
        for (Object object2 : hashMap2.keySet()) {
            list2 = ((String)object2).equals(TreeManager.TARGET_VIRTUALMACHINE) ? VM_PROPERTIES : OBJECT_PROPERTIES;
            ResultSet resultSet = this._queryService.select(list2).from(new String[]{object2}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, hashMap2.get(object2))}).opId(string).fetch();
            for (ResourceItem resourceItem : resultSet.getItems()) {
                String string2;
                Object object = resourceItem.getKey();
                if (object == null || (string2 = this._objRefService.getUid(object, true)) == null) continue;
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                for (String string3 : list2) {
                    if (string3.equals("@modelKey")) continue;
                    hashMap3.put(string3, resourceItem.get(string3));
                }
                hashMap.put(string2, hashMap3);
            }
        }
        return hashMap;
    }

    @Override
    public List<String> getSupportedTypes(String string) {
        return this._treeList.getSupportedTypes(string);
    }

    private Response retrieveDataFromDs(QuerySpec[] querySpecArray) {
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = this._dataService.getData(requestSpec);
        return response;
    }

    private List<TreeNodeItem> formatResult(Tree tree, Response response) {
        ArrayList<TreeNodeItem> arrayList = new ArrayList<TreeNodeItem>();
        if (response == null) {
            return arrayList;
        }
        com.vmware.vise.data.query.ResultSet[] resultSetArray = response.resultSet;
        if (resultSetArray == null) {
            return arrayList;
        }
        Locale locale = ResourceUtil.getLocale();
        Map map = this._i18nManager.getResourceMap(locale);
        for (com.vmware.vise.data.query.ResultSet resultSet : resultSetArray) {
            arrayList.addAll(this.formatResult(tree, resultSet, map));
        }
        return arrayList;
    }

    private List<TreeNodeItem> formatResult(Tree tree, com.vmware.vise.data.query.ResultSet resultSet, Map<String, Map<String, String>> map) {
        ResultItem[] resultItemArray;
        ArrayList<TreeNodeItem> arrayList = new ArrayList<TreeNodeItem>();
        if (resultSet.error != null) {
            _logger.error((Object)String.format("Error when getting data from dataservice [treeId=%s]: %s", tree.getId(), resultSet.error.getMessage()), resultSet.error.getCause());
        }
        if ((resultItemArray = resultSet.items) == null || resultItemArray.length == 0) {
            return arrayList;
        }
        arrayList.ensureCapacity(resultItemArray.length);
        for (ResultItem resultItem : resultItemArray) {
            Object object2;
            TreeNodeItem treeNodeItem = new TreeNodeItem();
            String string = this._objRefService.getUid(resultItem.resourceObject, true);
            if (string == null) {
                _logger.warn((Object)String.format("Possibly unexpected null uid: [treeId=%s, nodeId=%s]", tree.getId(), resultSet.queryName));
            }
            treeNodeItem.objRef = string;
            treeNodeItem.nodeTypeId = resultSet.queryName;
            if (tree.hasChildren(resultSet.queryName)) {
                treeNodeItem.hasChildren = Boolean.TRUE;
            }
            String string2 = null;
            boolean bl = false;
            String string3 = null;
            for (Object object2 : resultItem.properties) {
                String string4;
                String string5 = object2.propertyName;
                if (StringUtil.isNullOrEmpty((String)string5)) {
                    _logger.error((Object)String.format("Found a null or empty propertyName for: [treeId=%s, nodeId=%s,  uid=%s]", tree.getId(), resultSet.queryName, string));
                    continue;
                }
                String string6 = object2.value.toString();
                if (string5.equalsIgnoreCase("name")) {
                    treeNodeItem.text = string6;
                    continue;
                }
                if (string5.equalsIgnoreCase("primaryIconId")) {
                    treeNodeItem.spriteCssClass = string6;
                    continue;
                }
                if (string5.equalsIgnoreCase("labelIds")) {
                    string2 = CommonUtils.getTaggingLabel(string6, map, null, null);
                    continue;
                }
                if (string5.equalsIgnoreCase("config.template")) {
                    treeNodeItem.isVmTemplate = Boolean.parseBoolean(string6);
                    continue;
                }
                if (string5.equalsIgnoreCase("config.vsanHostConfig.enabled")) {
                    bl = Boolean.parseBoolean(string6);
                    continue;
                }
                if (string5.equalsIgnoreCase("config.vsanHostConfig.faultDomainInfo.name")) {
                    string3 = string6;
                    continue;
                }
                if (treeNodeItem.aliases == null) {
                    treeNodeItem.aliases = new ArrayList<String>();
                }
                if (StringUtil.isNullOrEmpty((String)(string4 = this._objRefService.getUid(object2.value, true)))) continue;
                treeNodeItem.aliases.add(string4);
            }
            String object3 = "italic";
            String string7 = "disconnected";
            String string8 = "inaccessible";
            object2 = "error";
            treeNodeItem.spriteParentCssClass = "";
            if (treeNodeItem.spriteCssClass != null) {
                if (treeNodeItem.spriteCssClass.indexOf(string7) != -1 || treeNodeItem.spriteCssClass.indexOf(string8) != -1 || treeNodeItem.spriteCssClass.indexOf((String)object2) != -1) {
                    treeNodeItem.spriteParentCssClass = treeNodeItem.spriteParentCssClass + " " + object3;
                } else {
                    treeNodeItem.spriteParentCssClass.replaceAll(object3, "");
                }
            }
            if (string2 != null) {
                treeNodeItem.text = treeNodeItem.text + string2;
                if (string2.indexOf(string7) != -1) {
                    treeNodeItem.spriteParentCssClass = treeNodeItem.spriteParentCssClass + " " + object3;
                }
            }
            if (this._multiAZFeatureEnabled && bl && string3 != null && string3.length() > 0) {
                treeNodeItem.text = treeNodeItem.text + " (" + string3 + ")";
            }
            arrayList.add(treeNodeItem);
        }
        return arrayList;
    }

    private ManagedObjectReference getOptimizedRootRef(Object object) {
        boolean bl = object instanceof ManagedObjectReference;
        if (!bl) {
            throw new IllegalArgumentException("Unsupported object type!");
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        ManagedObjectReference managedObjectReference2 = ManagedObjectUtil.getRootFolder((String)managedObjectReference.getServerGuid());
        return managedObjectReference2;
    }

    private boolean isOptimizedPathToRootAvailable(Object object, String string) {
        boolean bl = object instanceof ManagedObjectReference;
        return bl && this._treePathHelper.isOptimizedPathToRootAvailable(string) && VcServiceUtil.is65VcOrLaterByServerGuid((String)((ManagedObjectReference)object).getServerGuid(), (boolean)true);
    }

    private boolean isTreeWithVcRoot(String string, String string2) {
        return TreeNodeList.VcRoot.class.getSimpleName().equals(string) || StringUtil.isNullOrEmpty((String)string2) && TreeNodeList.RefOrVcAsRoot.class.getSimpleName().equals(string);
    }

    private List<TreeNodeItem> getVcRoot(String string) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        if (linkedVcGroupRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<TreeNodeItem> arrayList = new ArrayList<TreeNodeItem>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupRegistry.getLinkedVcGroups()) {
            if (linkedVcGroup == null) continue;
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                ServiceInstanceContent serviceInstanceContent;
                if (vcService == null || (serviceInstanceContent = vcService.getServiceInstanceContent()) == null) continue;
                String string2 = VcServiceUtil.getServiceName((String)vcService.getServiceGuid());
                TreeNodeItem treeNodeItem = new TreeNodeItem();
                treeNodeItem.objRef = this._objRefService.getUid((Object)serviceInstanceContent.getRootFolder(), true);
                treeNodeItem.hasChildren = true;
                treeNodeItem.spriteCssClass = "vsphere-icon-vcenter";
                treeNodeItem.text = string2;
                treeNodeItem.nodeTypeId = string;
                arrayList.add(treeNodeItem);
            }
        }
        TreeManagerImpl.sortRootNodes(arrayList);
        return arrayList;
    }

    private static void sortRootNodes(List<TreeNodeItem> list) {
        Collections.sort(list, new Comparator<TreeNodeItem>(){

            @Override
            public int compare(@Nonnull TreeNodeItem treeNodeItem, @Nonnull TreeNodeItem treeNodeItem2) {
                return treeNodeItem.text.compareToIgnoreCase(treeNodeItem2.text);
            }
        });
    }
}

