/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.mvc.util.impl;

import com.google.gson.Gson;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.mvc.util.I18nServiceHelper;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.I18nManager;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class I18nServiceHelperImpl
implements I18nServiceHelper,
ExtensionListener {
    private static final Log _logger = LogFactory.getLog(I18nServiceHelperImpl.class);
    private final I18nManager _i18nManager;
    private final Gson _gson;
    private static AtomicLong _atomicLong;

    public I18nServiceHelperImpl(I18nManager i18nManager, Gson gson) {
        this._i18nManager = i18nManager;
        this._gson = gson;
        _atomicLong = new AtomicLong(System.currentTimeMillis());
    }

    @Override
    public String getResources(String string) {
        Locale locale = null;
        if (!StringUtil.isNullOrEmpty((String)string)) {
            try {
                locale = ResourceUtil.parseLocale((String)string);
            }
            catch (Exception exception) {
                _logger.warn((Object)("Invalid locale parameter: " + string + ", error: " + exception.getMessage()));
            }
        }
        if (locale == null) {
            locale = ResourceUtil.getLocale();
        }
        Map map = this._i18nManager.getResourceMap(locale);
        return this._gson.toJson((Object)map);
    }

    @Override
    public long getInternalVersion() {
        return _atomicLong.get();
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        _atomicLong.incrementAndGet();
    }
}

