/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.folder.FolderUtils;
import com.vmware.vsphere.client.folder.keyServers.KmipClusterStatusSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipRetrieveServerCertificateSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterKmipPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VCenterKmipPropertyProvider.class);
    public static final int SECONDS_PER_DAY = 86400;
    private final TaskMonitor _taskMonitor;

    public VCenterKmipPropertyProvider(TaskMonitor taskMonitor) {
        this._taskMonitor = taskMonitor;
    }

    @type(value="Folder")
    public KmipClusterInfo[] getKmipClusters(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        return cryptoManagerKmip.listKmipServers(null);
    }

    @type(value="Folder")
    public KmipClusterStatusSpec getH5DefaultKmipClusterStatus(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        try {
            KmipClusterInfo[] clusters = cryptoManagerKmip.listKmipServers(null);
            KmipClusterInfo defaultCluster = this.getDefaultKmsCluster(clusters);
            if (defaultCluster == null) {
                return null;
            }
            ManagedObjectReference task = cryptoManagerKmip.retrieveKmipServersStatus(new KmipClusterInfo[]{defaultCluster});
            TaskInfo taskInfo = this._taskMonitor.monitorTask(task);
            KmipClusterStatusSpec result = new KmipClusterStatusSpec();
            result.noPermission = false;
            result.name = defaultCluster.clusterId.id;
            if (taskInfo.error != null) {
                _logger.error((Object)"Error while retrieving Task Info", (Throwable)taskInfo.error);
                result.connectionStatus = KmipServerInfo.ConnectionStatus.ERROR_RETRIEVING.name();
                result.certificateStatus = KmipServerInfo.CertStatus.ERROR_RETRIEVING;
                return result;
            }
            CryptoManagerKmip.ClusterStatus clusterStatus = ((CryptoManagerKmip.ClusterStatus[])taskInfo.result)[0];
            result.connectionStatus = KmipServerInfo.ConnectionStatus.NO_TRUST_CONNECTION.name();
            result.certificateStatus = this.getCertificateStatus((CryptoManagerKmip.CertificateInfo)clusterStatus.clientCertInfo).certStatus;
            for (CryptoManagerKmip.ServerStatus serverStatus : clusterStatus.servers) {
                if (!result.connectionStatus.equals(KmipServerInfo.ConnectionStatus.NO_TRUST_CONNECTION.name())) continue;
                result.connectionStatus = this.getConnectionStatus(serverStatus);
            }
            return result;
        }
        catch (NoPermission e) {
            KmipClusterStatusSpec result = new KmipClusterStatusSpec();
            result.noPermission = true;
            return result;
        }
    }

    @type(value="Folder")
    public Map<String, KmipServerInfo> getH5KmipServerInfos(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        LinkedHashMap<String, KmipServerInfo> kmipServerInfoSpecsByName = new LinkedHashMap<String, KmipServerInfo>();
        if (cryptoManagerKmip == null) {
            return kmipServerInfoSpecsByName;
        }
        Object[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
        if (ArrayUtil.isNullOrEmpty((Object[])kmipClusterInfos)) {
            return kmipServerInfoSpecsByName;
        }
        for (Object clusterInfo : kmipClusterInfos) {
            for (com.vmware.vim.binding.vim.encryption.KmipServerInfo serverInfo : ((KmipClusterInfo)clusterInfo).servers) {
                KmipServerInfo kmipServerInfo = new KmipServerInfo();
                kmipServerInfoSpecsByName.put(((KmipClusterInfo)clusterInfo).clusterId.id + serverInfo.name, kmipServerInfo);
                kmipServerInfo.name = serverInfo.name;
                kmipServerInfo.clusterName = ((KmipClusterInfo)clusterInfo).clusterId.id;
                kmipServerInfo.useAsDefault = ((KmipClusterInfo)clusterInfo).useAsDefault;
                kmipServerInfo.address = serverInfo.address;
                kmipServerInfo.port = serverInfo.port;
                kmipServerInfo.proxyAddress = serverInfo.proxyAddress;
                kmipServerInfo.proxyPort = serverInfo.proxyPort;
                kmipServerInfo.username = serverInfo.userName;
            }
        }
        return kmipServerInfoSpecsByName;
    }

    @type(value="Folder")
    public Map<String, KmipServerInfo> getH5KmipServerInfosWithStatus(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip.ClusterStatus[] clusterStatuses;
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        LinkedHashMap<String, KmipServerInfo> kmipServerInfoSpecsByName = new LinkedHashMap<String, KmipServerInfo>();
        if (cryptoManagerKmip == null) {
            return kmipServerInfoSpecsByName;
        }
        Object[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
        if (ArrayUtil.isNullOrEmpty((Object[])kmipClusterInfos)) {
            return kmipServerInfoSpecsByName;
        }
        for (Object clusterInfo : kmipClusterInfos) {
            com.vmware.vim.binding.vim.encryption.KmipServerInfo[] kmipServerInfoArray = ((KmipClusterInfo)clusterInfo).servers;
            int n = kmipServerInfoArray.length;
            for (int i = 0; i < n; ++i) {
                com.vmware.vim.binding.vim.encryption.KmipServerInfo serverInfo = kmipServerInfoArray[i];
                KmipServerInfo kmipServerInfo = new KmipServerInfo();
                kmipServerInfoSpecsByName.put(((KmipClusterInfo)clusterInfo).clusterId.id + serverInfo.name, kmipServerInfo);
                kmipServerInfo.name = serverInfo.name;
                kmipServerInfo.clusterName = ((KmipClusterInfo)clusterInfo).clusterId.id;
                kmipServerInfo.useAsDefault = ((KmipClusterInfo)clusterInfo).useAsDefault;
                kmipServerInfo.address = serverInfo.address;
                kmipServerInfo.port = serverInfo.port;
                kmipServerInfo.proxyAddress = serverInfo.proxyAddress;
                kmipServerInfo.proxyPort = serverInfo.proxyPort;
                kmipServerInfo.username = serverInfo.userName;
            }
        }
        ManagedObjectReference task = cryptoManagerKmip.retrieveKmipServersStatus((KmipClusterInfo[])kmipClusterInfos);
        TaskInfo taskInfo = this._taskMonitor.monitorTask(task);
        if (taskInfo.error != null) {
            _logger.error((Object)"Error while retrieving Task Info", (Throwable)taskInfo.error);
            for (KmipServerInfo serverInfo : kmipServerInfoSpecsByName.values()) {
                serverInfo.connectionStatus = KmipServerInfo.ConnectionStatus.ERROR_RETRIEVING.name();
                serverInfo.clusterCertificateStatus = KmipServerInfo.CertStatus.ERROR_RETRIEVING;
                serverInfo.serverCertificateStatus = KmipServerInfo.CertStatus.ERROR_RETRIEVING;
                serverInfo.certificateErrorMessage = taskInfo.error.getMessage();
            }
            return kmipServerInfoSpecsByName;
        }
        for (CryptoManagerKmip.ClusterStatus clusterStatus : clusterStatuses = (CryptoManagerKmip.ClusterStatus[])taskInfo.result) {
            for (CryptoManagerKmip.ServerStatus serverStatus : clusterStatus.servers) {
                KmipServerInfo h5KmipServerInfo = (KmipServerInfo)kmipServerInfoSpecsByName.get(clusterStatus.clusterId.id + serverStatus.name);
                h5KmipServerInfo.connectionStatus = this.getConnectionStatus(serverStatus);
                CertificateStatusExpDate serverExpDate = this.getCertificateStatus(serverStatus.certInfo);
                h5KmipServerInfo.serverCertificateStatus = serverExpDate.certStatus;
                h5KmipServerInfo.serverExpirationDate = serverExpDate.expirationDate;
                h5KmipServerInfo.serverSecondsBeforeExpiration = serverExpDate.secondsBeforeExpire;
                CertificateStatusExpDate clusterStatusExpDate = this.getCertificateStatus(clusterStatus.clientCertInfo);
                h5KmipServerInfo.clusterCertificateStatus = clusterStatusExpDate.certStatus;
                h5KmipServerInfo.clusterExpirationDate = clusterStatusExpDate.expirationDate;
                h5KmipServerInfo.clusterSecondsBeforeExpiration = clusterStatusExpDate.secondsBeforeExpire;
            }
        }
        return kmipServerInfoSpecsByName;
    }

    private CertificateStatusExpDate getCertificateStatus(CryptoManagerKmip.CertificateInfo certInfo) {
        CertificateStatusExpDate certificateStatusExpDate = new CertificateStatusExpDate();
        if (certInfo == null) {
            return certificateStatusExpDate;
        }
        if (certInfo.secondsBeforeExpire <= 0) {
            certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.EXPIRED;
        } else if (certInfo.secondsBeforeExpire <= 432000) {
            certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.ABOUT_TO_EXPIRE;
            certificateStatusExpDate.secondsBeforeExpire = certInfo.secondsBeforeExpire;
        } else {
            certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.GOOD;
            certificateStatusExpDate.expirationDate = LocalizationUtil.formatLocalizedDate((Date)certInfo.notAfter.getTime());
        }
        return certificateStatusExpDate;
    }

    private String getConnectionStatus(CryptoManagerKmip.ServerStatus serverStatus) {
        if (serverStatus.serverTrustClient.booleanValue() && serverStatus.clientTrustServer.booleanValue()) {
            return KmipServerInfo.ConnectionStatus.CONNECTED.name();
        }
        if (serverStatus.clientTrustServer != null && serverStatus.clientTrustServer.booleanValue()) {
            return KmipServerInfo.ConnectionStatus.CLIENT_TRUST_SERVER.name();
        }
        if (serverStatus.serverTrustClient != null && serverStatus.serverTrustClient.booleanValue()) {
            return KmipServerInfo.ConnectionStatus.SERVER_TRUST_CLIENT.name();
        }
        return KmipServerInfo.ConnectionStatus.NO_TRUST_CONNECTION.name();
    }

    @type(value="Folder")
    public boolean getDefaultKmsClusterExists(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return false;
        }
        try {
            KmipClusterInfo[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
            return this.getDefaultKmsCluster(kmipClusterInfos) != null;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve kms servers, returning true opportunistically.", (Throwable)e);
            return true;
        }
    }

    @type(value="Folder")
    public OperationResult getKmipClustersStatus(ManagedObjectReference vcRef, Object[] infos) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KmipClusterInfo[] clustersInfo = (KmipClusterInfo[])Arrays.copyOf(infos, infos.length, KmipClusterInfo[].class);
        OperationResult opResult = new OperationResult();
        opResult.entity = vcRef;
        try {
            opResult.task = cryptoManagerKmip.retrieveKmipServersStatus(clustersInfo);
        }
        catch (Exception exp) {
            _logger.error((Object)"Error retrieving kmip clusters and servers status.", (Throwable)MixedUtil.getMethodFault((Throwable)exp));
            opResult.error = MixedUtil.getMethodFault((Throwable)exp);
        }
        return opResult;
    }

    @type(value="Folder")
    public CryptoManagerKmip.ServerCertInfo getKmipServerTrustedCertificate(ManagedObjectReference vcRef, KmipRetrieveServerCertificateSpec spec) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(spec.clusterName);
        return cryptoManagerKmip.retrieveKmipServerCert(clusterId, spec.serverInfo);
    }

    @type(value="Folder")
    public String getKmipCsrCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        String certificate = cryptoManagerKmip.retrieveClientCsr(clusterId);
        if (StringUtil.isNullOrEmpty((String)certificate)) {
            certificate = cryptoManagerKmip.generateClientCsr(clusterId);
        }
        return certificate;
    }

    @type(value="Folder")
    public String getKmipNewCsrCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        return cryptoManagerKmip.generateClientCsr(clusterId);
    }

    @type(value="Folder")
    public String getKmipClientCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        String certificate = cryptoManagerKmip.retrieveClientCert(clusterId);
        if (StringUtil.isNullOrEmpty((String)certificate)) {
            certificate = cryptoManagerKmip.generateSelfSignedClientCert(clusterId);
            cryptoManagerKmip.updateSelfSignedClientCert(clusterId, certificate);
        }
        return certificate;
    }

    @type(value="Folder")
    public String getKmipNewClientCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        return cryptoManagerKmip.generateSelfSignedClientCert(clusterId);
    }

    private KmipClusterInfo getDefaultKmsCluster(KmipClusterInfo[] kmipClusterInfos) {
        if (kmipClusterInfos != null) {
            for (KmipClusterInfo kmipClusterInfo : kmipClusterInfos) {
                if (!kmipClusterInfo.useAsDefault) continue;
                return kmipClusterInfo;
            }
        }
        return null;
    }

    private class CertificateStatusExpDate {
        KmipServerInfo.CertStatus certStatus = KmipServerInfo.CertStatus.NA;
        String expirationDate;
        Integer secondsBeforeExpire;

        private CertificateStatusExpDate() {
        }
    }
}

